/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceCall;
import com.microsoft.azure.AzureServiceResponseBuilder;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.implementation.LocationInner;
import com.microsoft.azure.management.resources.implementation.PageImpl;
import com.microsoft.azure.management.resources.implementation.PageImpl1;
import com.microsoft.azure.management.resources.implementation.SubscriptionClientImpl;
import com.microsoft.azure.management.resources.implementation.SubscriptionInner;
import com.microsoft.rest.ServiceCall;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public final class SubscriptionsInner {
    private SubscriptionsService service;
    private SubscriptionClientImpl client;

    public SubscriptionsInner(Retrofit retrofit, SubscriptionClientImpl client) {
        this.service = (SubscriptionsService)retrofit.create(SubscriptionsService.class);
        this.client = client;
    }

    public List<LocationInner> listLocations(String subscriptionId) {
        return (List)((ServiceResponse)this.listLocationsWithServiceResponseAsync(subscriptionId).toBlocking().single()).getBody();
    }

    public ServiceCall<List<LocationInner>> listLocationsAsync(String subscriptionId, ServiceCallback<List<LocationInner>> serviceCallback) {
        return ServiceCall.create(this.listLocationsWithServiceResponseAsync(subscriptionId), serviceCallback);
    }

    public Observable<List<LocationInner>> listLocationsAsync(String subscriptionId) {
        return this.listLocationsWithServiceResponseAsync(subscriptionId).map((Func1)new Func1<ServiceResponse<List<LocationInner>>, List<LocationInner>>(){

            public List<LocationInner> call(ServiceResponse<List<LocationInner>> response) {
                return (List)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<List<LocationInner>>> listLocationsWithServiceResponseAsync(String subscriptionId) {
        if (subscriptionId == null) {
            throw new IllegalArgumentException("Parameter subscriptionId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listLocations(subscriptionId, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<LocationInner>>>>(){

            public Observable<ServiceResponse<List<LocationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SubscriptionsInner.this.listLocationsDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl)result.getBody()).getItems(), result.getResponse());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<LocationInner>> listLocationsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PageImpl<LocationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SubscriptionInner get(String subscriptionId) {
        return (SubscriptionInner)((ServiceResponse)this.getWithServiceResponseAsync(subscriptionId).toBlocking().single()).getBody();
    }

    public ServiceCall<SubscriptionInner> getAsync(String subscriptionId, ServiceCallback<SubscriptionInner> serviceCallback) {
        return ServiceCall.create(this.getWithServiceResponseAsync(subscriptionId), serviceCallback);
    }

    public Observable<SubscriptionInner> getAsync(String subscriptionId) {
        return this.getWithServiceResponseAsync(subscriptionId).map((Func1)new Func1<ServiceResponse<SubscriptionInner>, SubscriptionInner>(){

            public SubscriptionInner call(ServiceResponse<SubscriptionInner> response) {
                return (SubscriptionInner)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<SubscriptionInner>> getWithServiceResponseAsync(String subscriptionId) {
        if (subscriptionId == null) {
            throw new IllegalArgumentException("Parameter subscriptionId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(subscriptionId, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SubscriptionInner>>>(){

            public Observable<ServiceResponse<SubscriptionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SubscriptionsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SubscriptionInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<SubscriptionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SubscriptionInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<SubscriptionInner>((Page)response.getBody()){

            public Page<SubscriptionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SubscriptionsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<SubscriptionInner>> listAsync(ListOperationCallback<SubscriptionInner> serviceCallback) {
        return AzureServiceCall.create(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<SubscriptionInner>>>>(){

            public Observable<ServiceResponse<Page<SubscriptionInner>>> call(String nextPageLink) {
                return SubscriptionsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SubscriptionInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<SubscriptionInner>>, Page<SubscriptionInner>>(){

            public Page<SubscriptionInner> call(ServiceResponse<Page<SubscriptionInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<SubscriptionInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<SubscriptionInner>>, Observable<ServiceResponse<Page<SubscriptionInner>>>>(){

            public Observable<ServiceResponse<Page<SubscriptionInner>>> call(ServiceResponse<Page<SubscriptionInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SubscriptionsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SubscriptionInner>>> listSinglePageAsync() {
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SubscriptionInner>>>>(){

            public Observable<ServiceResponse<Page<SubscriptionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SubscriptionsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<SubscriptionInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PageImpl1<SubscriptionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SubscriptionInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SubscriptionInner>((Page)response.getBody()){

            public Page<SubscriptionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SubscriptionsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<SubscriptionInner>> listNextAsync(String nextPageLink, ServiceCall<List<SubscriptionInner>> serviceCall, ListOperationCallback<SubscriptionInner> serviceCallback) {
        return AzureServiceCall.create(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<SubscriptionInner>>>>(){

            public Observable<ServiceResponse<Page<SubscriptionInner>>> call(String nextPageLink) {
                return SubscriptionsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SubscriptionInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<SubscriptionInner>>, Page<SubscriptionInner>>(){

            public Page<SubscriptionInner> call(ServiceResponse<Page<SubscriptionInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<SubscriptionInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<SubscriptionInner>>, Observable<ServiceResponse<Page<SubscriptionInner>>>>(){

            public Observable<ServiceResponse<Page<SubscriptionInner>>> call(ServiceResponse<Page<SubscriptionInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SubscriptionsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SubscriptionInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        return this.service.listNext(nextPageLink, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SubscriptionInner>>>>(){

            public Observable<ServiceResponse<Page<SubscriptionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SubscriptionsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<SubscriptionInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PageImpl1<SubscriptionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface SubscriptionsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="subscriptions/{subscriptionId}/locations")
        public Observable<Response<ResponseBody>> listLocations(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="subscriptions/{subscriptionId}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="subscriptions")
        public Observable<Response<ResponseBody>> list(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="{nextLink}")
        public Observable<Response<ResponseBody>> listNext(@Path(value="nextLink", encoded=true) String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

