/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation;

import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.ExternalChildResourceCollectionImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.models.ExternalChildResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import java.util.List;
import java.util.Map;

public abstract class ExternalChildResourcesCachedImpl<FluentModelTImpl extends ExternalChildResourceImpl<FluentModelT, InnerModelT, ParentImplT, ParentT>, FluentModelT extends ExternalChildResource<FluentModelT, ParentT>, InnerModelT, ParentImplT extends ParentT, ParentT>
extends ExternalChildResourceCollectionImpl<FluentModelTImpl, FluentModelT, InnerModelT, ParentImplT, ParentT> {
    protected ExternalChildResourcesCachedImpl(ParentImplT parent, String childResourceName) {
        super(parent, childResourceName);
    }

    public void refresh() {
        this.cacheCollection();
    }

    protected Map<String, FluentModelTImpl> collection() {
        return this.childCollection;
    }

    protected FluentModelTImpl prepareDefine(String name) {
        return this.prepareDefine(name, name);
    }

    protected final FluentModelTImpl prepareDefine(String name, String key) {
        if (this.find(key) != null) {
            throw new IllegalArgumentException("A child resource ('" + this.childResourceName + "') with name (key) '" + name + " (" + key + ")' already exists");
        }
        FluentModelTImpl childResource = this.newChildResource(name);
        ((ExternalChildResourceImpl)childResource).setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeCreated);
        return childResource;
    }

    protected final FluentModelTImpl prepareUpdate(String name) {
        return this.prepareUpdate(name, name);
    }

    protected final FluentModelTImpl prepareUpdate(String name, String key) {
        Object childResource = this.find(key);
        if (childResource == null || ((ExternalChildResourceImpl)childResource).pendingOperation() == ExternalChildResourceImpl.PendingOperation.ToBeCreated) {
            throw new IllegalArgumentException("A child resource ('" + this.childResourceName + "') with name (key) '" + name + " (" + key + ")' not found");
        }
        if (((ExternalChildResourceImpl)childResource).pendingOperation() == ExternalChildResourceImpl.PendingOperation.ToBeRemoved) {
            throw new IllegalArgumentException("A child resource ('" + this.childResourceName + "') with name (key) '" + name + " (" + key + ")' is marked for deletion");
        }
        ((ExternalChildResourceImpl)childResource).setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeUpdated);
        return childResource;
    }

    protected final void prepareRemove(String name) {
        this.prepareRemove(name, name);
    }

    protected final void prepareRemove(String name, String key) {
        Object childResource = this.find(key);
        if (childResource == null || ((ExternalChildResourceImpl)childResource).pendingOperation() == ExternalChildResourceImpl.PendingOperation.ToBeCreated) {
            throw new IllegalArgumentException("A child resource ('" + this.childResourceName + "') with name (key) '" + name + " (" + key + ")' not found");
        }
        ((ExternalChildResourceImpl)childResource).setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeRemoved);
    }

    protected void addChildResource(FluentModelTImpl childResource) {
        this.addChildResource(((ExternalChildResourceImpl)childResource).name(), childResource);
    }

    protected void addChildResource(String key, FluentModelTImpl childResource) {
        this.childCollection.put(key, childResource);
    }

    protected void cacheCollection() {
        this.childCollection.clear();
        for (ExternalChildResourceImpl childResource : this.listChildResources()) {
            this.childCollection.put(childResource.childResourceKey(), childResource);
        }
    }

    @Override
    protected final boolean clearAfterCommit() {
        return false;
    }

    protected abstract List<FluentModelTImpl> listChildResources();

    protected abstract FluentModelTImpl newChildResource(String var1);
}

