/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.fluentcore.model.implementation;

import com.microsoft.azure.management.resources.fluentcore.dag.TaskItem;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import rx.Observable;
import rx.functions.Action1;

public class CreateUpdateTask<ResourceT>
implements TaskItem<ResourceT> {
    private ResourceCreatorUpdator<ResourceT> resourceCreatorUpdator;
    private ResourceT resource;

    public CreateUpdateTask(ResourceCreatorUpdator<ResourceT> resourceCreatorUpdator) {
        this.resourceCreatorUpdator = resourceCreatorUpdator;
    }

    @Override
    public ResourceT result() {
        return this.resource;
    }

    @Override
    public void prepare() {
        this.resourceCreatorUpdator.prepare();
    }

    @Override
    public boolean isHot() {
        return this.resourceCreatorUpdator.isHot();
    }

    @Override
    public Observable<ResourceT> executeAsync() {
        if (this.resourceCreatorUpdator.isInCreateMode()) {
            return this.resourceCreatorUpdator.createResourceAsync().subscribeOn(SdkContext.getRxScheduler()).doOnNext(new Action1<ResourceT>(){

                public void call(ResourceT resourceT) {
                    CreateUpdateTask.this.resource = resourceT;
                }
            });
        }
        return this.resourceCreatorUpdator.updateResourceAsync().subscribeOn(SdkContext.getRxScheduler()).doOnNext(new Action1<ResourceT>(){

            public void call(ResourceT resourceT) {
                CreateUpdateTask.this.resource = resourceT;
            }
        });
    }

    public static interface ResourceCreatorUpdator<ResultT> {
        public boolean isInCreateMode();

        public void prepare();

        public boolean isHot();

        public Observable<ResultT> createResourceAsync();

        public Observable<ResultT> updateResourceAsync();
    }
}

