/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.fluentcore.utils;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.implementation.PageImpl;
import com.microsoft.rest.RestException;
import java.io.IOException;
import java.util.ArrayList;

public abstract class PagedListConverter<U, V> {
    public abstract V typeConvert(U var1);

    protected boolean filter(U u) {
        return true;
    }

    public PagedList<V> convert(final PagedList<U> uList) {
        if (uList == null || uList.isEmpty()) {
            return new PagedList<V>(){

                public Page<V> nextPage(String s) throws RestException, IOException {
                    return null;
                }
            };
        }
        Page uPage = uList.currentPage();
        PageImpl vPage = new PageImpl();
        vPage.setNextPageLink(uPage.nextPageLink());
        vPage.setItems(new ArrayList());
        for (Object u : uPage.items()) {
            if (!this.filter(u)) continue;
            vPage.items().add(this.typeConvert(u));
        }
        return new PagedList<V>(vPage){

            public Page<V> nextPage(String nextPageLink) throws RestException, IOException {
                Page uPage = uList.nextPage(nextPageLink);
                PageImpl vPage = new PageImpl();
                vPage.setNextPageLink(uPage.nextPageLink());
                vPage.setItems(new ArrayList());
                for (Object u : uPage.items()) {
                    if (!PagedListConverter.this.filter(u)) continue;
                    vPage.items().add(PagedListConverter.this.typeConvert(u));
                }
                return vPage;
            }
        };
    }
}

