/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.Deployment;
import com.microsoft.azure.management.resources.Deployments;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.SupportsGettingByResourceGroupImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasManager;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupPagedList;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.azure.management.resources.implementation.DeploymentExtendedInner;
import com.microsoft.azure.management.resources.implementation.DeploymentImpl;
import com.microsoft.azure.management.resources.implementation.DeploymentsInner;
import com.microsoft.azure.management.resources.implementation.ResourceManager;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.util.List;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

final class DeploymentsImpl
extends SupportsGettingByResourceGroupImpl<Deployment>
implements Deployments,
HasManager<ResourceManager> {
    private final ResourceManager resourceManager;
    private PagedListConverter<DeploymentExtendedInner, Deployment> converter;

    DeploymentsImpl(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.converter = new PagedListConverter<DeploymentExtendedInner, Deployment>(){

            @Override
            public Observable<Deployment> typeConvertAsync(DeploymentExtendedInner deploymentInner) {
                return Observable.just((Object)DeploymentsImpl.this.createFluentModel(deploymentInner));
            }
        };
    }

    @Override
    public PagedList<Deployment> list() {
        final DeploymentsInner client = this.manager().inner().deployments();
        return new GroupPagedList<Deployment>(this.resourceManager.resourceGroups().list()){

            @Override
            public List<Deployment> listNextGroup(String resourceGroupName) {
                return DeploymentsImpl.this.converter.convert(client.listByResourceGroup(resourceGroupName));
            }
        };
    }

    @Override
    public PagedList<Deployment> listByResourceGroup(String groupName) {
        return this.converter.convert(this.manager().inner().deployments().listByResourceGroup(groupName));
    }

    @Override
    public Deployment getByName(String name) {
        for (ResourceGroup group : this.resourceManager.resourceGroups().list()) {
            DeploymentExtendedInner inner = this.manager().inner().deployments().getByResourceGroup(group.name(), name);
            if (inner == null) continue;
            return this.createFluentModel(inner);
        }
        return null;
    }

    @Override
    public Observable<Deployment> getByResourceGroupAsync(String groupName, String name) {
        return this.manager().inner().deployments().getByResourceGroupAsync(groupName, name).map((Func1)new Func1<DeploymentExtendedInner, Deployment>(){

            public Deployment call(DeploymentExtendedInner deploymentExtendedInner) {
                if (deploymentExtendedInner != null) {
                    return DeploymentsImpl.this.createFluentModel(deploymentExtendedInner);
                }
                return null;
            }
        });
    }

    @Override
    public void deleteByResourceGroup(String groupName, String name) {
        this.deleteByResourceGroupAsync(groupName, name).await();
    }

    @Override
    public ServiceFuture<Void> deleteByResourceGroupAsync(String groupName, String name, ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Completable)this.deleteByResourceGroupAsync(groupName, name), callback);
    }

    @Override
    public Completable deleteByResourceGroupAsync(String groupName, String name) {
        return this.manager().inner().deployments().deleteAsync(groupName, name).toCompletable();
    }

    @Override
    public DeploymentImpl define(String name) {
        return this.createFluentModel(name);
    }

    @Override
    public boolean checkExistence(String resourceGroupName, String deploymentName) {
        return this.manager().inner().deployments().checkExistence(resourceGroupName, deploymentName);
    }

    protected DeploymentImpl createFluentModel(String name) {
        return new DeploymentImpl(new DeploymentExtendedInner().withName(name), this.resourceManager);
    }

    protected DeploymentImpl createFluentModel(DeploymentExtendedInner deploymentExtendedInner) {
        return new DeploymentImpl(deploymentExtendedInner, this.resourceManager);
    }

    @Override
    public Deployment getById(String id) {
        return (Deployment)this.getByResourceGroup(ResourceUtils.groupFromResourceId(id), ResourceUtils.nameFromResourceId(id));
    }

    @Override
    public void deleteById(String id) {
        this.deleteByIdAsync(id).await();
    }

    @Override
    public ServiceFuture<Void> deleteByIdAsync(String id, ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Completable)this.deleteByIdAsync(id), callback);
    }

    @Override
    public Completable deleteByIdAsync(String id) {
        return this.deleteByResourceGroupAsync(ResourceUtils.groupFromResourceId(id), ResourceUtils.nameFromResourceId(id));
    }

    @Override
    public ResourceManager manager() {
        return this.resourceManager;
    }

    @Override
    public Observable<Deployment> listAsync() {
        return this.manager().resourceGroups().listAsync().flatMap((Func1)new Func1<ResourceGroup, Observable<Deployment>>(){

            public Observable<Deployment> call(ResourceGroup resourceGroup) {
                return DeploymentsImpl.this.listByResourceGroupAsync(resourceGroup.name());
            }
        });
    }

    @Override
    public Observable<Deployment> listByResourceGroupAsync(String resourceGroupName) {
        DeploymentsInner client = this.manager().inner().deployments();
        return ReadableWrappersImpl.convertPageToInnerAsync(client.listByResourceGroupAsync(resourceGroupName)).map((Func1)new Func1<DeploymentExtendedInner, Deployment>(){

            public Deployment call(DeploymentExtendedInner deploymentExtendedInner) {
                return DeploymentsImpl.this.createFluentModel(deploymentExtendedInner);
            }
        });
    }
}

