/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.fluentcore.dag;

import com.microsoft.azure.management.resources.fluentcore.dag.DAGNode;
import com.microsoft.azure.management.resources.fluentcore.dag.ErroredDependencyTaskException;
import com.microsoft.azure.management.resources.fluentcore.dag.TaskItem;
import rx.Observable;
import rx.functions.Func0;

final class TaskGroupEntry<ResultT, TaskT extends TaskItem<ResultT>>
extends DAGNode<TaskT, TaskGroupEntry<ResultT, TaskT>> {
    private boolean hasFaultedDescentDependencyTask;

    TaskGroupEntry(String taskId, TaskT taskItem) {
        super(taskId, taskItem);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.hasFaultedDescentDependencyTask = false;
    }

    public ResultT taskResult() {
        return (ResultT)this.taskItem().result();
    }

    public Observable<ResultT> executeTaskAsync(boolean ignoreCachedResult) {
        if (this.hasFaultedDescentDependencyTask) {
            return Observable.error((Throwable)new ErroredDependencyTaskException());
        }
        TaskT taskItem = this.taskItem();
        if (!ignoreCachedResult && this.hasCachedResult()) {
            return Observable.just(taskItem.result());
        }
        if (taskItem.isHot()) {
            return Observable.defer((Func0)new Func0<Observable<ResultT>>((TaskItem)taskItem){
                final /* synthetic */ TaskItem val$taskItem;
                {
                    this.val$taskItem = taskItem;
                }

                public Observable<ResultT> call() {
                    return this.val$taskItem.executeAsync();
                }
            });
        }
        return taskItem.executeAsync();
    }

    @Override
    protected void onFaultedResolution(String dependencyKey, Throwable throwable) {
        super.onFaultedResolution(dependencyKey, throwable);
        this.hasFaultedDescentDependencyTask = true;
    }

    private TaskT taskItem() {
        return (TaskT)((TaskItem)super.data());
    }

    private boolean hasCachedResult() {
        return this.taskItem().result() != null;
    }
}

