/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.fluentcore.model.implementation;

import com.microsoft.azure.management.resources.fluentcore.dag.TaskItem;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import rx.Observable;
import rx.functions.Action1;

public class ExecuteTask<ResultT>
implements TaskItem<ResultT> {
    private Executor<ResultT> executor;
    private ResultT result;

    public ExecuteTask(Executor<ResultT> executor) {
        this.executor = executor;
    }

    @Override
    public ResultT result() {
        return this.result;
    }

    @Override
    public void prepare() {
        this.executor.prepare();
    }

    @Override
    public boolean isHot() {
        return this.executor.isHot();
    }

    @Override
    public Observable<ResultT> executeAsync() {
        return this.executor.executeWorkAsync().subscribeOn(SdkContext.getRxScheduler()).doOnNext(new Action1<ResultT>(){

            public void call(ResultT value) {
                ExecuteTask.this.result = value;
            }
        });
    }

    public static interface Executor<ResultT> {
        public void prepare();

        public boolean isHot();

        public Observable<ResultT> executeWorkAsync();
    }
}

