/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.fluentcore.utils;

import com.microsoft.azure.management.resources.fluentcore.utils.DelayProvider;
import com.microsoft.azure.management.resources.fluentcore.utils.ResourceNamer;
import com.microsoft.azure.management.resources.fluentcore.utils.ResourceNamerFactory;
import rx.Scheduler;
import rx.schedulers.Schedulers;

public class SdkContext {
    private static ResourceNamerFactory resourceNamerFactory = new ResourceNamerFactory();
    private static DelayProvider delayProvider = new DelayProvider();
    private static Scheduler rxScheduler = Schedulers.io();

    public static void setResourceNamerFactory(ResourceNamerFactory resourceNamerFactory) {
        SdkContext.resourceNamerFactory = resourceNamerFactory;
    }

    public static ResourceNamerFactory getResourceNamerFactory() {
        return resourceNamerFactory;
    }

    public static String randomResourceName(String prefix, int maxLen) {
        ResourceNamer resourceNamer = SdkContext.getResourceNamerFactory().createResourceNamer("");
        return resourceNamer.randomName(prefix, maxLen);
    }

    public static String[] randomResourceNames(String prefix, int maxLen, int count) {
        String[] names = new String[count];
        ResourceNamer resourceNamer = SdkContext.getResourceNamerFactory().createResourceNamer("");
        for (int i = 0; i < count; ++i) {
            names[i] = resourceNamer.randomName(prefix, maxLen);
        }
        return names;
    }

    public static String randomUuid() {
        ResourceNamer resourceNamer = SdkContext.getResourceNamerFactory().createResourceNamer("");
        return resourceNamer.randomUuid();
    }

    public static void setDelayProvider(DelayProvider delayProvider) {
        SdkContext.delayProvider = delayProvider;
    }

    public static void sleep(int milliseconds) {
        delayProvider.sleep(milliseconds);
    }

    public static Scheduler getRxScheduler() {
        return rxScheduler;
    }

    public static void setRxScheduler(Scheduler rxScheduler) {
        SdkContext.rxScheduler = rxScheduler;
    }
}

