/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.ResourcesMoveInfo;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.azure.management.resources.implementation.GenericResourceExpandedInner;
import com.microsoft.azure.management.resources.implementation.GenericResourceInner;
import com.microsoft.azure.management.resources.implementation.PageImpl;
import com.microsoft.azure.management.resources.implementation.ResourceManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HEAD;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ResourcesInner
implements InnerSupportsListing<GenericResourceExpandedInner> {
    private ResourcesService service;
    private ResourceManagementClientImpl client;

    public ResourcesInner(Retrofit retrofit, ResourceManagementClientImpl client) {
        this.service = (ResourcesService)retrofit.create(ResourcesService.class);
        this.client = client;
    }

    @Override
    public PagedList<GenericResourceExpandedInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<GenericResourceExpandedInner>((Page)response.body()){

            public Page<GenericResourceExpandedInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ResourcesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<GenericResourceExpandedInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<GenericResourceExpandedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<GenericResourceExpandedInner>>>>(){

            public Observable<ServiceResponse<Page<GenericResourceExpandedInner>>> call(String nextPageLink) {
                return ResourcesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<GenericResourceExpandedInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<GenericResourceExpandedInner>>, Page<GenericResourceExpandedInner>>(){

            public Page<GenericResourceExpandedInner> call(ServiceResponse<Page<GenericResourceExpandedInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<GenericResourceExpandedInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<GenericResourceExpandedInner>>, Observable<ServiceResponse<Page<GenericResourceExpandedInner>>>>(){

            public Observable<ServiceResponse<Page<GenericResourceExpandedInner>>> call(ServiceResponse<Page<GenericResourceExpandedInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ResourcesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<GenericResourceExpandedInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        String expand = null;
        Integer top = null;
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), filter, expand, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<GenericResourceExpandedInner>>>>(){

            public Observable<ServiceResponse<Page<GenericResourceExpandedInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ResourcesInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<GenericResourceExpandedInner> listByResourceGroup(String resourceGroupName, String filter, String expand, Integer top) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName, filter, expand, top).toBlocking().single();
        return new PagedList<GenericResourceExpandedInner>((Page)response.body()){

            public Page<GenericResourceExpandedInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ResourcesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<GenericResourceExpandedInner>> listByResourceGroupAsync(String resourceGroupName, String filter, String expand, Integer top, ListOperationCallback<GenericResourceExpandedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName, filter, expand, top), (Func1)new Func1<String, Observable<ServiceResponse<Page<GenericResourceExpandedInner>>>>(){

            public Observable<ServiceResponse<Page<GenericResourceExpandedInner>>> call(String nextPageLink) {
                return ResourcesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<GenericResourceExpandedInner>> listByResourceGroupAsync(String resourceGroupName, String filter, String expand, Integer top) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName, filter, expand, top).map((Func1)new Func1<ServiceResponse<Page<GenericResourceExpandedInner>>, Page<GenericResourceExpandedInner>>(){

            public Page<GenericResourceExpandedInner> call(ServiceResponse<Page<GenericResourceExpandedInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<GenericResourceExpandedInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName, String filter, String expand, Integer top) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName, filter, expand, top).concatMap((Func1)new Func1<ServiceResponse<Page<GenericResourceExpandedInner>>, Observable<ServiceResponse<Page<GenericResourceExpandedInner>>>>(){

            public Observable<ServiceResponse<Page<GenericResourceExpandedInner>>> call(ServiceResponse<Page<GenericResourceExpandedInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ResourcesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<GenericResourceExpandedInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName, String filter, String expand, Integer top) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), filter, expand, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<GenericResourceExpandedInner>>>>(){

            public Observable<ServiceResponse<Page<GenericResourceExpandedInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ResourcesInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<GenericResourceExpandedInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<GenericResourceExpandedInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void moveResources(String sourceResourceGroupName, ResourcesMoveInfo parameters) {
        ((ServiceResponse)this.moveResourcesWithServiceResponseAsync(sourceResourceGroupName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<Void> moveResourcesAsync(String sourceResourceGroupName, ResourcesMoveInfo parameters, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.moveResourcesWithServiceResponseAsync(sourceResourceGroupName, parameters), serviceCallback);
    }

    public Observable<Void> moveResourcesAsync(String sourceResourceGroupName, ResourcesMoveInfo parameters) {
        return this.moveResourcesWithServiceResponseAsync(sourceResourceGroupName, parameters).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> moveResourcesWithServiceResponseAsync(String sourceResourceGroupName, ResourcesMoveInfo parameters) {
        if (sourceResourceGroupName == null) {
            throw new IllegalArgumentException("Parameter sourceResourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        Observable<Response<ResponseBody>> observable = this.service.moveResources(sourceResourceGroupName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginMoveResources(String sourceResourceGroupName, ResourcesMoveInfo parameters) {
        ((ServiceResponse)this.beginMoveResourcesWithServiceResponseAsync(sourceResourceGroupName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginMoveResourcesAsync(String sourceResourceGroupName, ResourcesMoveInfo parameters, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginMoveResourcesWithServiceResponseAsync(sourceResourceGroupName, parameters), serviceCallback);
    }

    public Observable<Void> beginMoveResourcesAsync(String sourceResourceGroupName, ResourcesMoveInfo parameters) {
        return this.beginMoveResourcesWithServiceResponseAsync(sourceResourceGroupName, parameters).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginMoveResourcesWithServiceResponseAsync(String sourceResourceGroupName, ResourcesMoveInfo parameters) {
        if (sourceResourceGroupName == null) {
            throw new IllegalArgumentException("Parameter sourceResourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.beginMoveResources(sourceResourceGroupName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ResourcesInner.this.beginMoveResourcesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginMoveResourcesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void validateMoveResources(String sourceResourceGroupName, ResourcesMoveInfo parameters) {
        ((ServiceResponse)this.validateMoveResourcesWithServiceResponseAsync(sourceResourceGroupName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<Void> validateMoveResourcesAsync(String sourceResourceGroupName, ResourcesMoveInfo parameters, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.validateMoveResourcesWithServiceResponseAsync(sourceResourceGroupName, parameters), serviceCallback);
    }

    public Observable<Void> validateMoveResourcesAsync(String sourceResourceGroupName, ResourcesMoveInfo parameters) {
        return this.validateMoveResourcesWithServiceResponseAsync(sourceResourceGroupName, parameters).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> validateMoveResourcesWithServiceResponseAsync(String sourceResourceGroupName, ResourcesMoveInfo parameters) {
        if (sourceResourceGroupName == null) {
            throw new IllegalArgumentException("Parameter sourceResourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        Observable<Response<ResponseBody>> observable = this.service.validateMoveResources(sourceResourceGroupName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginValidateMoveResources(String sourceResourceGroupName, ResourcesMoveInfo parameters) {
        ((ServiceResponse)this.beginValidateMoveResourcesWithServiceResponseAsync(sourceResourceGroupName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginValidateMoveResourcesAsync(String sourceResourceGroupName, ResourcesMoveInfo parameters, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginValidateMoveResourcesWithServiceResponseAsync(sourceResourceGroupName, parameters), serviceCallback);
    }

    public Observable<Void> beginValidateMoveResourcesAsync(String sourceResourceGroupName, ResourcesMoveInfo parameters) {
        return this.beginValidateMoveResourcesWithServiceResponseAsync(sourceResourceGroupName, parameters).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginValidateMoveResourcesWithServiceResponseAsync(String sourceResourceGroupName, ResourcesMoveInfo parameters) {
        if (sourceResourceGroupName == null) {
            throw new IllegalArgumentException("Parameter sourceResourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.beginValidateMoveResources(sourceResourceGroupName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ResourcesInner.this.beginValidateMoveResourcesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginValidateMoveResourcesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<GenericResourceExpandedInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<GenericResourceExpandedInner>((Page)response.body()){

            public Page<GenericResourceExpandedInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ResourcesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<GenericResourceExpandedInner>> listAsync(ListOperationCallback<GenericResourceExpandedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<GenericResourceExpandedInner>>>>(){

            public Observable<ServiceResponse<Page<GenericResourceExpandedInner>>> call(String nextPageLink) {
                return ResourcesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<GenericResourceExpandedInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<GenericResourceExpandedInner>>, Page<GenericResourceExpandedInner>>(){

            public Page<GenericResourceExpandedInner> call(ServiceResponse<Page<GenericResourceExpandedInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<GenericResourceExpandedInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<GenericResourceExpandedInner>>, Observable<ServiceResponse<Page<GenericResourceExpandedInner>>>>(){

            public Observable<ServiceResponse<Page<GenericResourceExpandedInner>>> call(ServiceResponse<Page<GenericResourceExpandedInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ResourcesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<GenericResourceExpandedInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        String expand = null;
        Integer top = null;
        return this.service.list(this.client.subscriptionId(), filter, expand, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<GenericResourceExpandedInner>>>>(){

            public Observable<ServiceResponse<Page<GenericResourceExpandedInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ResourcesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<GenericResourceExpandedInner> list(String filter, String expand, Integer top) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(filter, expand, top).toBlocking().single();
        return new PagedList<GenericResourceExpandedInner>((Page)response.body()){

            public Page<GenericResourceExpandedInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ResourcesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<GenericResourceExpandedInner>> listAsync(String filter, String expand, Integer top, ListOperationCallback<GenericResourceExpandedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(filter, expand, top), (Func1)new Func1<String, Observable<ServiceResponse<Page<GenericResourceExpandedInner>>>>(){

            public Observable<ServiceResponse<Page<GenericResourceExpandedInner>>> call(String nextPageLink) {
                return ResourcesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<GenericResourceExpandedInner>> listAsync(String filter, String expand, Integer top) {
        return this.listWithServiceResponseAsync(filter, expand, top).map((Func1)new Func1<ServiceResponse<Page<GenericResourceExpandedInner>>, Page<GenericResourceExpandedInner>>(){

            public Page<GenericResourceExpandedInner> call(ServiceResponse<Page<GenericResourceExpandedInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<GenericResourceExpandedInner>>> listWithServiceResponseAsync(String filter, String expand, Integer top) {
        return this.listSinglePageAsync(filter, expand, top).concatMap((Func1)new Func1<ServiceResponse<Page<GenericResourceExpandedInner>>, Observable<ServiceResponse<Page<GenericResourceExpandedInner>>>>(){

            public Observable<ServiceResponse<Page<GenericResourceExpandedInner>>> call(ServiceResponse<Page<GenericResourceExpandedInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ResourcesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<GenericResourceExpandedInner>>> listSinglePageAsync(String filter, String expand, Integer top) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), filter, expand, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<GenericResourceExpandedInner>>>>(){

            public Observable<ServiceResponse<Page<GenericResourceExpandedInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ResourcesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<GenericResourceExpandedInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<GenericResourceExpandedInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public boolean checkExistence(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        return (Boolean)((ServiceResponse)this.checkExistenceWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion).toBlocking().single()).body();
    }

    public ServiceFuture<Boolean> checkExistenceAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, ServiceCallback<Boolean> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkExistenceWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion), serviceCallback);
    }

    public Observable<Boolean> checkExistenceAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        return this.checkExistenceWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion).map((Func1)new Func1<ServiceResponse<Boolean>, Boolean>(){

            public Boolean call(ServiceResponse<Boolean> response) {
                return (Boolean)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Boolean>> checkExistenceWithServiceResponseAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (parentResourcePath == null) {
            throw new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null.");
        }
        if (resourceType == null) {
            throw new IllegalArgumentException("Parameter resourceType is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (apiVersion == null) {
            throw new IllegalArgumentException("Parameter apiVersion is required and cannot be null.");
        }
        return this.service.checkExistence(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<Void>, Observable<ServiceResponse<Boolean>>>(){

            public Observable<ServiceResponse<Boolean>> call(Response<Void> response) {
                try {
                    ServiceResponse clientResponse = ResourcesInner.this.checkExistenceDelegate((Response<Void>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Boolean> checkExistenceDelegate(Response<Void> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).buildEmpty(response);
    }

    public void delete(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (parentResourcePath == null) {
            throw new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null.");
        }
        if (resourceType == null) {
            throw new IllegalArgumentException("Parameter resourceType is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (apiVersion == null) {
            throw new IllegalArgumentException("Parameter apiVersion is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (parentResourcePath == null) {
            throw new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null.");
        }
        if (resourceType == null) {
            throw new IllegalArgumentException("Parameter resourceType is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (apiVersion == null) {
            throw new IllegalArgumentException("Parameter apiVersion is required and cannot be null.");
        }
        return this.service.beginDelete(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ResourcesInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public GenericResourceInner createOrUpdate(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters) {
        return (GenericResourceInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<GenericResourceInner> createOrUpdateAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters, ServiceCallback<GenericResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, parameters), serviceCallback);
    }

    public Observable<GenericResourceInner> createOrUpdateAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, parameters).map((Func1)new Func1<ServiceResponse<GenericResourceInner>, GenericResourceInner>(){

            public GenericResourceInner call(ServiceResponse<GenericResourceInner> response) {
                return (GenericResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GenericResourceInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (parentResourcePath == null) {
            throw new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null.");
        }
        if (resourceType == null) {
            throw new IllegalArgumentException("Parameter resourceType is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (apiVersion == null) {
            throw new IllegalArgumentException("Parameter apiVersion is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, this.client.subscriptionId(), apiVersion, parameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<GenericResourceInner>(){}.getType());
    }

    public GenericResourceInner beginCreateOrUpdate(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters) {
        return (GenericResourceInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<GenericResourceInner> beginCreateOrUpdateAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters, ServiceCallback<GenericResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, parameters), serviceCallback);
    }

    public Observable<GenericResourceInner> beginCreateOrUpdateAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, parameters).map((Func1)new Func1<ServiceResponse<GenericResourceInner>, GenericResourceInner>(){

            public GenericResourceInner call(ServiceResponse<GenericResourceInner> response) {
                return (GenericResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GenericResourceInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (parentResourcePath == null) {
            throw new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null.");
        }
        if (resourceType == null) {
            throw new IllegalArgumentException("Parameter resourceType is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (apiVersion == null) {
            throw new IllegalArgumentException("Parameter apiVersion is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        return this.service.beginCreateOrUpdate(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, this.client.subscriptionId(), apiVersion, parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<GenericResourceInner>>>(){

            public Observable<ServiceResponse<GenericResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ResourcesInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<GenericResourceInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GenericResourceInner>(){}.getType()).register(201, new TypeToken<GenericResourceInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public GenericResourceInner update(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters) {
        return (GenericResourceInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<GenericResourceInner> updateAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters, ServiceCallback<GenericResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, parameters), serviceCallback);
    }

    public Observable<GenericResourceInner> updateAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, parameters).map((Func1)new Func1<ServiceResponse<GenericResourceInner>, GenericResourceInner>(){

            public GenericResourceInner call(ServiceResponse<GenericResourceInner> response) {
                return (GenericResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GenericResourceInner>> updateWithServiceResponseAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (parentResourcePath == null) {
            throw new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null.");
        }
        if (resourceType == null) {
            throw new IllegalArgumentException("Parameter resourceType is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (apiVersion == null) {
            throw new IllegalArgumentException("Parameter apiVersion is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, this.client.subscriptionId(), apiVersion, parameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<GenericResourceInner>(){}.getType());
    }

    public GenericResourceInner beginUpdate(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters) {
        return (GenericResourceInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<GenericResourceInner> beginUpdateAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters, ServiceCallback<GenericResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, parameters), serviceCallback);
    }

    public Observable<GenericResourceInner> beginUpdateAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, parameters).map((Func1)new Func1<ServiceResponse<GenericResourceInner>, GenericResourceInner>(){

            public GenericResourceInner call(ServiceResponse<GenericResourceInner> response) {
                return (GenericResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GenericResourceInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (parentResourcePath == null) {
            throw new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null.");
        }
        if (resourceType == null) {
            throw new IllegalArgumentException("Parameter resourceType is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (apiVersion == null) {
            throw new IllegalArgumentException("Parameter apiVersion is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        return this.service.beginUpdate(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, this.client.subscriptionId(), apiVersion, parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<GenericResourceInner>>>(){

            public Observable<ServiceResponse<GenericResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ResourcesInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<GenericResourceInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GenericResourceInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public GenericResourceInner get(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        return (GenericResourceInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion).toBlocking().single()).body());
    }

    public ServiceFuture<GenericResourceInner> getAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, ServiceCallback<GenericResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion), serviceCallback);
    }

    public Observable<GenericResourceInner> getAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        return this.getWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion).map((Func1)new Func1<ServiceResponse<GenericResourceInner>, GenericResourceInner>(){

            public GenericResourceInner call(ServiceResponse<GenericResourceInner> response) {
                return (GenericResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GenericResourceInner>> getWithServiceResponseAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (parentResourcePath == null) {
            throw new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null.");
        }
        if (resourceType == null) {
            throw new IllegalArgumentException("Parameter resourceType is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (apiVersion == null) {
            throw new IllegalArgumentException("Parameter apiVersion is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<GenericResourceInner>>>(){

            public Observable<ServiceResponse<GenericResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ResourcesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<GenericResourceInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GenericResourceInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public boolean checkExistenceById(String resourceId, String apiVersion) {
        return (Boolean)((ServiceResponse)this.checkExistenceByIdWithServiceResponseAsync(resourceId, apiVersion).toBlocking().single()).body();
    }

    public ServiceFuture<Boolean> checkExistenceByIdAsync(String resourceId, String apiVersion, ServiceCallback<Boolean> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkExistenceByIdWithServiceResponseAsync(resourceId, apiVersion), serviceCallback);
    }

    public Observable<Boolean> checkExistenceByIdAsync(String resourceId, String apiVersion) {
        return this.checkExistenceByIdWithServiceResponseAsync(resourceId, apiVersion).map((Func1)new Func1<ServiceResponse<Boolean>, Boolean>(){

            public Boolean call(ServiceResponse<Boolean> response) {
                return (Boolean)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Boolean>> checkExistenceByIdWithServiceResponseAsync(String resourceId, String apiVersion) {
        if (resourceId == null) {
            throw new IllegalArgumentException("Parameter resourceId is required and cannot be null.");
        }
        if (apiVersion == null) {
            throw new IllegalArgumentException("Parameter apiVersion is required and cannot be null.");
        }
        return this.service.checkExistenceById(resourceId, apiVersion, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<Void>, Observable<ServiceResponse<Boolean>>>(){

            public Observable<ServiceResponse<Boolean>> call(Response<Void> response) {
                try {
                    ServiceResponse clientResponse = ResourcesInner.this.checkExistenceByIdDelegate((Response<Void>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Boolean> checkExistenceByIdDelegate(Response<Void> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).buildEmpty(response);
    }

    public void deleteById(String resourceId, String apiVersion) {
        ((ServiceResponse)this.deleteByIdWithServiceResponseAsync(resourceId, apiVersion).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteByIdAsync(String resourceId, String apiVersion, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteByIdWithServiceResponseAsync(resourceId, apiVersion), serviceCallback);
    }

    public Observable<Void> deleteByIdAsync(String resourceId, String apiVersion) {
        return this.deleteByIdWithServiceResponseAsync(resourceId, apiVersion).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteByIdWithServiceResponseAsync(String resourceId, String apiVersion) {
        if (resourceId == null) {
            throw new IllegalArgumentException("Parameter resourceId is required and cannot be null.");
        }
        if (apiVersion == null) {
            throw new IllegalArgumentException("Parameter apiVersion is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.deleteById(resourceId, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteById(String resourceId, String apiVersion) {
        ((ServiceResponse)this.beginDeleteByIdWithServiceResponseAsync(resourceId, apiVersion).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteByIdAsync(String resourceId, String apiVersion, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteByIdWithServiceResponseAsync(resourceId, apiVersion), serviceCallback);
    }

    public Observable<Void> beginDeleteByIdAsync(String resourceId, String apiVersion) {
        return this.beginDeleteByIdWithServiceResponseAsync(resourceId, apiVersion).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteByIdWithServiceResponseAsync(String resourceId, String apiVersion) {
        if (resourceId == null) {
            throw new IllegalArgumentException("Parameter resourceId is required and cannot be null.");
        }
        if (apiVersion == null) {
            throw new IllegalArgumentException("Parameter apiVersion is required and cannot be null.");
        }
        return this.service.beginDeleteById(resourceId, apiVersion, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ResourcesInner.this.beginDeleteByIdDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteByIdDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public GenericResourceInner createOrUpdateById(String resourceId, String apiVersion, GenericResourceInner parameters) {
        return (GenericResourceInner)((Object)((ServiceResponse)this.createOrUpdateByIdWithServiceResponseAsync(resourceId, apiVersion, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<GenericResourceInner> createOrUpdateByIdAsync(String resourceId, String apiVersion, GenericResourceInner parameters, ServiceCallback<GenericResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateByIdWithServiceResponseAsync(resourceId, apiVersion, parameters), serviceCallback);
    }

    public Observable<GenericResourceInner> createOrUpdateByIdAsync(String resourceId, String apiVersion, GenericResourceInner parameters) {
        return this.createOrUpdateByIdWithServiceResponseAsync(resourceId, apiVersion, parameters).map((Func1)new Func1<ServiceResponse<GenericResourceInner>, GenericResourceInner>(){

            public GenericResourceInner call(ServiceResponse<GenericResourceInner> response) {
                return (GenericResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GenericResourceInner>> createOrUpdateByIdWithServiceResponseAsync(String resourceId, String apiVersion, GenericResourceInner parameters) {
        if (resourceId == null) {
            throw new IllegalArgumentException("Parameter resourceId is required and cannot be null.");
        }
        if (apiVersion == null) {
            throw new IllegalArgumentException("Parameter apiVersion is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdateById(resourceId, apiVersion, parameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<GenericResourceInner>(){}.getType());
    }

    public GenericResourceInner beginCreateOrUpdateById(String resourceId, String apiVersion, GenericResourceInner parameters) {
        return (GenericResourceInner)((Object)((ServiceResponse)this.beginCreateOrUpdateByIdWithServiceResponseAsync(resourceId, apiVersion, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<GenericResourceInner> beginCreateOrUpdateByIdAsync(String resourceId, String apiVersion, GenericResourceInner parameters, ServiceCallback<GenericResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateByIdWithServiceResponseAsync(resourceId, apiVersion, parameters), serviceCallback);
    }

    public Observable<GenericResourceInner> beginCreateOrUpdateByIdAsync(String resourceId, String apiVersion, GenericResourceInner parameters) {
        return this.beginCreateOrUpdateByIdWithServiceResponseAsync(resourceId, apiVersion, parameters).map((Func1)new Func1<ServiceResponse<GenericResourceInner>, GenericResourceInner>(){

            public GenericResourceInner call(ServiceResponse<GenericResourceInner> response) {
                return (GenericResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GenericResourceInner>> beginCreateOrUpdateByIdWithServiceResponseAsync(String resourceId, String apiVersion, GenericResourceInner parameters) {
        if (resourceId == null) {
            throw new IllegalArgumentException("Parameter resourceId is required and cannot be null.");
        }
        if (apiVersion == null) {
            throw new IllegalArgumentException("Parameter apiVersion is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        return this.service.beginCreateOrUpdateById(resourceId, apiVersion, parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<GenericResourceInner>>>(){

            public Observable<ServiceResponse<GenericResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ResourcesInner.this.beginCreateOrUpdateByIdDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<GenericResourceInner> beginCreateOrUpdateByIdDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GenericResourceInner>(){}.getType()).register(201, new TypeToken<GenericResourceInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public GenericResourceInner updateById(String resourceId, String apiVersion, GenericResourceInner parameters) {
        return (GenericResourceInner)((Object)((ServiceResponse)this.updateByIdWithServiceResponseAsync(resourceId, apiVersion, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<GenericResourceInner> updateByIdAsync(String resourceId, String apiVersion, GenericResourceInner parameters, ServiceCallback<GenericResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateByIdWithServiceResponseAsync(resourceId, apiVersion, parameters), serviceCallback);
    }

    public Observable<GenericResourceInner> updateByIdAsync(String resourceId, String apiVersion, GenericResourceInner parameters) {
        return this.updateByIdWithServiceResponseAsync(resourceId, apiVersion, parameters).map((Func1)new Func1<ServiceResponse<GenericResourceInner>, GenericResourceInner>(){

            public GenericResourceInner call(ServiceResponse<GenericResourceInner> response) {
                return (GenericResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GenericResourceInner>> updateByIdWithServiceResponseAsync(String resourceId, String apiVersion, GenericResourceInner parameters) {
        if (resourceId == null) {
            throw new IllegalArgumentException("Parameter resourceId is required and cannot be null.");
        }
        if (apiVersion == null) {
            throw new IllegalArgumentException("Parameter apiVersion is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        Observable<Response<ResponseBody>> observable = this.service.updateById(resourceId, apiVersion, parameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<GenericResourceInner>(){}.getType());
    }

    public GenericResourceInner beginUpdateById(String resourceId, String apiVersion, GenericResourceInner parameters) {
        return (GenericResourceInner)((Object)((ServiceResponse)this.beginUpdateByIdWithServiceResponseAsync(resourceId, apiVersion, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<GenericResourceInner> beginUpdateByIdAsync(String resourceId, String apiVersion, GenericResourceInner parameters, ServiceCallback<GenericResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateByIdWithServiceResponseAsync(resourceId, apiVersion, parameters), serviceCallback);
    }

    public Observable<GenericResourceInner> beginUpdateByIdAsync(String resourceId, String apiVersion, GenericResourceInner parameters) {
        return this.beginUpdateByIdWithServiceResponseAsync(resourceId, apiVersion, parameters).map((Func1)new Func1<ServiceResponse<GenericResourceInner>, GenericResourceInner>(){

            public GenericResourceInner call(ServiceResponse<GenericResourceInner> response) {
                return (GenericResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GenericResourceInner>> beginUpdateByIdWithServiceResponseAsync(String resourceId, String apiVersion, GenericResourceInner parameters) {
        if (resourceId == null) {
            throw new IllegalArgumentException("Parameter resourceId is required and cannot be null.");
        }
        if (apiVersion == null) {
            throw new IllegalArgumentException("Parameter apiVersion is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        return this.service.beginUpdateById(resourceId, apiVersion, parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<GenericResourceInner>>>(){

            public Observable<ServiceResponse<GenericResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ResourcesInner.this.beginUpdateByIdDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<GenericResourceInner> beginUpdateByIdDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GenericResourceInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public GenericResourceInner getById(String resourceId, String apiVersion) {
        return (GenericResourceInner)((Object)((ServiceResponse)this.getByIdWithServiceResponseAsync(resourceId, apiVersion).toBlocking().single()).body());
    }

    public ServiceFuture<GenericResourceInner> getByIdAsync(String resourceId, String apiVersion, ServiceCallback<GenericResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByIdWithServiceResponseAsync(resourceId, apiVersion), serviceCallback);
    }

    public Observable<GenericResourceInner> getByIdAsync(String resourceId, String apiVersion) {
        return this.getByIdWithServiceResponseAsync(resourceId, apiVersion).map((Func1)new Func1<ServiceResponse<GenericResourceInner>, GenericResourceInner>(){

            public GenericResourceInner call(ServiceResponse<GenericResourceInner> response) {
                return (GenericResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GenericResourceInner>> getByIdWithServiceResponseAsync(String resourceId, String apiVersion) {
        if (resourceId == null) {
            throw new IllegalArgumentException("Parameter resourceId is required and cannot be null.");
        }
        if (apiVersion == null) {
            throw new IllegalArgumentException("Parameter apiVersion is required and cannot be null.");
        }
        return this.service.getById(resourceId, apiVersion, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<GenericResourceInner>>>(){

            public Observable<ServiceResponse<GenericResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ResourcesInner.this.getByIdDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<GenericResourceInner> getByIdDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GenericResourceInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<GenericResourceExpandedInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<GenericResourceExpandedInner>((Page)response.body()){

            public Page<GenericResourceExpandedInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ResourcesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<GenericResourceExpandedInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<GenericResourceExpandedInner>> serviceFuture, ListOperationCallback<GenericResourceExpandedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<GenericResourceExpandedInner>>>>(){

            public Observable<ServiceResponse<Page<GenericResourceExpandedInner>>> call(String nextPageLink) {
                return ResourcesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<GenericResourceExpandedInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<GenericResourceExpandedInner>>, Page<GenericResourceExpandedInner>>(){

            public Page<GenericResourceExpandedInner> call(ServiceResponse<Page<GenericResourceExpandedInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<GenericResourceExpandedInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<GenericResourceExpandedInner>>, Observable<ServiceResponse<Page<GenericResourceExpandedInner>>>>(){

            public Observable<ServiceResponse<Page<GenericResourceExpandedInner>>> call(ServiceResponse<Page<GenericResourceExpandedInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ResourcesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<GenericResourceExpandedInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<GenericResourceExpandedInner>>>>(){

            public Observable<ServiceResponse<Page<GenericResourceExpandedInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ResourcesInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<GenericResourceExpandedInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<GenericResourceExpandedInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<GenericResourceExpandedInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<GenericResourceExpandedInner>((Page)response.body()){

            public Page<GenericResourceExpandedInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ResourcesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<GenericResourceExpandedInner>> listNextAsync(String nextPageLink, ServiceFuture<List<GenericResourceExpandedInner>> serviceFuture, ListOperationCallback<GenericResourceExpandedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<GenericResourceExpandedInner>>>>(){

            public Observable<ServiceResponse<Page<GenericResourceExpandedInner>>> call(String nextPageLink) {
                return ResourcesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<GenericResourceExpandedInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<GenericResourceExpandedInner>>, Page<GenericResourceExpandedInner>>(){

            public Page<GenericResourceExpandedInner> call(ServiceResponse<Page<GenericResourceExpandedInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<GenericResourceExpandedInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<GenericResourceExpandedInner>>, Observable<ServiceResponse<Page<GenericResourceExpandedInner>>>>(){

            public Observable<ServiceResponse<Page<GenericResourceExpandedInner>>> call(ServiceResponse<Page<GenericResourceExpandedInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ResourcesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<GenericResourceExpandedInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<GenericResourceExpandedInner>>>>(){

            public Observable<ServiceResponse<Page<GenericResourceExpandedInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ResourcesInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<GenericResourceExpandedInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<GenericResourceExpandedInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ResourcesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Resources listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/resources")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="$filter") String var3, @Query(value="$expand") String var4, @Query(value="$top") Integer var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Resources moveResources"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{sourceResourceGroupName}/moveResources")
        public Observable<Response<ResponseBody>> moveResources(@Path(value="sourceResourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Body ResourcesMoveInfo var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Resources beginMoveResources"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{sourceResourceGroupName}/moveResources")
        public Observable<Response<ResponseBody>> beginMoveResources(@Path(value="sourceResourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Body ResourcesMoveInfo var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Resources validateMoveResources"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{sourceResourceGroupName}/validateMoveResources")
        public Observable<Response<ResponseBody>> validateMoveResources(@Path(value="sourceResourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Body ResourcesMoveInfo var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Resources beginValidateMoveResources"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{sourceResourceGroupName}/validateMoveResources")
        public Observable<Response<ResponseBody>> beginValidateMoveResources(@Path(value="sourceResourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Body ResourcesMoveInfo var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Resources list"})
        @GET(value="subscriptions/{subscriptionId}/resources")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="$filter") String var2, @Query(value="$expand") String var3, @Query(value="$top") Integer var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Resources checkExistence"})
        @HEAD(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}")
        public Observable<Response<Void>> checkExistence(@Path(value="resourceGroupName") String var1, @Path(value="resourceProviderNamespace") String var2, @Path(value="parentResourcePath", encoded=true) String var3, @Path(value="resourceType", encoded=true) String var4, @Path(value="resourceName") String var5, @Path(value="subscriptionId") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Resources delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="resourceProviderNamespace") String var2, @Path(value="parentResourcePath", encoded=true) String var3, @Path(value="resourceType", encoded=true) String var4, @Path(value="resourceName") String var5, @Path(value="subscriptionId") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Resources beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="resourceProviderNamespace") String var2, @Path(value="parentResourcePath", encoded=true) String var3, @Path(value="resourceType", encoded=true) String var4, @Path(value="resourceName") String var5, @Path(value="subscriptionId") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Resources createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="resourceProviderNamespace") String var2, @Path(value="parentResourcePath", encoded=true) String var3, @Path(value="resourceType", encoded=true) String var4, @Path(value="resourceName") String var5, @Path(value="subscriptionId") String var6, @Query(value="api-version") String var7, @Body GenericResourceInner var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Resources beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="resourceProviderNamespace") String var2, @Path(value="parentResourcePath", encoded=true) String var3, @Path(value="resourceType", encoded=true) String var4, @Path(value="resourceName") String var5, @Path(value="subscriptionId") String var6, @Query(value="api-version") String var7, @Body GenericResourceInner var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Resources update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="resourceProviderNamespace") String var2, @Path(value="parentResourcePath", encoded=true) String var3, @Path(value="resourceType", encoded=true) String var4, @Path(value="resourceName") String var5, @Path(value="subscriptionId") String var6, @Query(value="api-version") String var7, @Body GenericResourceInner var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Resources beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="resourceGroupName") String var1, @Path(value="resourceProviderNamespace") String var2, @Path(value="parentResourcePath", encoded=true) String var3, @Path(value="resourceType", encoded=true) String var4, @Path(value="resourceName") String var5, @Path(value="subscriptionId") String var6, @Query(value="api-version") String var7, @Body GenericResourceInner var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Resources get"})
        @GET(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="resourceProviderNamespace") String var2, @Path(value="parentResourcePath", encoded=true) String var3, @Path(value="resourceType", encoded=true) String var4, @Path(value="resourceName") String var5, @Path(value="subscriptionId") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Resources checkExistenceById"})
        @HEAD(value="{resourceId}")
        public Observable<Response<Void>> checkExistenceById(@Path(value="resourceId", encoded=true) String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Resources deleteById"})
        @HTTP(path="{resourceId}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteById(@Path(value="resourceId", encoded=true) String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Resources beginDeleteById"})
        @HTTP(path="{resourceId}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteById(@Path(value="resourceId", encoded=true) String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Resources createOrUpdateById"})
        @PUT(value="{resourceId}")
        public Observable<Response<ResponseBody>> createOrUpdateById(@Path(value="resourceId", encoded=true) String var1, @Query(value="api-version") String var2, @Body GenericResourceInner var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Resources beginCreateOrUpdateById"})
        @PUT(value="{resourceId}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdateById(@Path(value="resourceId", encoded=true) String var1, @Query(value="api-version") String var2, @Body GenericResourceInner var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Resources updateById"})
        @PATCH(value="{resourceId}")
        public Observable<Response<ResponseBody>> updateById(@Path(value="resourceId", encoded=true) String var1, @Query(value="api-version") String var2, @Body GenericResourceInner var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Resources beginUpdateById"})
        @PATCH(value="{resourceId}")
        public Observable<Response<ResponseBody>> beginUpdateById(@Path(value="resourceId", encoded=true) String var1, @Query(value="api-version") String var2, @Body GenericResourceInner var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Resources getById"})
        @GET(value="{resourceId}")
        public Observable<Response<ResponseBody>> getById(@Path(value="resourceId", encoded=true) String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Resources listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Resources listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

