/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.implementation.DeploymentOperationInner;
import com.microsoft.azure.management.resources.implementation.PageImpl;
import com.microsoft.azure.management.resources.implementation.ResourceManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class DeploymentOperationsInner {
    private DeploymentOperationsService service;
    private ResourceManagementClientImpl client;

    public DeploymentOperationsInner(Retrofit retrofit, ResourceManagementClientImpl client) {
        this.service = (DeploymentOperationsService)retrofit.create(DeploymentOperationsService.class);
        this.client = client;
    }

    public DeploymentOperationInner getAtScope(String scope, String deploymentName, String operationId) {
        return (DeploymentOperationInner)((ServiceResponse)this.getAtScopeWithServiceResponseAsync(scope, deploymentName, operationId).toBlocking().single()).body();
    }

    public ServiceFuture<DeploymentOperationInner> getAtScopeAsync(String scope, String deploymentName, String operationId, ServiceCallback<DeploymentOperationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getAtScopeWithServiceResponseAsync(scope, deploymentName, operationId), serviceCallback);
    }

    public Observable<DeploymentOperationInner> getAtScopeAsync(String scope, String deploymentName, String operationId) {
        return this.getAtScopeWithServiceResponseAsync(scope, deploymentName, operationId).map((Func1)new Func1<ServiceResponse<DeploymentOperationInner>, DeploymentOperationInner>(){

            public DeploymentOperationInner call(ServiceResponse<DeploymentOperationInner> response) {
                return (DeploymentOperationInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DeploymentOperationInner>> getAtScopeWithServiceResponseAsync(String scope, String deploymentName, String operationId) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (operationId == null) {
            throw new IllegalArgumentException("Parameter operationId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getAtScope(scope, deploymentName, operationId, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentOperationInner>>>(){

            public Observable<ServiceResponse<DeploymentOperationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentOperationsInner.this.getAtScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeploymentOperationInner> getAtScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DeploymentOperationInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DeploymentOperationInner> listAtScope(String scope, String deploymentName) {
        ServiceResponse response = (ServiceResponse)this.listAtScopeSinglePageAsync(scope, deploymentName).toBlocking().single();
        return new PagedList<DeploymentOperationInner>((Page)response.body()){

            public Page<DeploymentOperationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DeploymentOperationsInner.this.listAtScopeNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeploymentOperationInner>> listAtScopeAsync(String scope, String deploymentName, ListOperationCallback<DeploymentOperationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAtScopeSinglePageAsync(scope, deploymentName), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(String nextPageLink) {
                return DeploymentOperationsInner.this.listAtScopeNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DeploymentOperationInner>> listAtScopeAsync(String scope, String deploymentName) {
        return this.listAtScopeWithServiceResponseAsync(scope, deploymentName).map((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Page<DeploymentOperationInner>>(){

            public Page<DeploymentOperationInner> call(ServiceResponse<Page<DeploymentOperationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listAtScopeWithServiceResponseAsync(String scope, String deploymentName) {
        return this.listAtScopeSinglePageAsync(scope, deploymentName).concatMap((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(ServiceResponse<Page<DeploymentOperationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DeploymentOperationsInner.this.listAtScopeNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listAtScopeSinglePageAsync(String scope, String deploymentName) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Integer top = null;
        return this.service.listAtScope(scope, deploymentName, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DeploymentOperationsInner.this.listAtScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<DeploymentOperationInner> listAtScope(String scope, String deploymentName, Integer top) {
        ServiceResponse response = (ServiceResponse)this.listAtScopeSinglePageAsync(scope, deploymentName, top).toBlocking().single();
        return new PagedList<DeploymentOperationInner>((Page)response.body()){

            public Page<DeploymentOperationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DeploymentOperationsInner.this.listAtScopeNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeploymentOperationInner>> listAtScopeAsync(String scope, String deploymentName, Integer top, ListOperationCallback<DeploymentOperationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAtScopeSinglePageAsync(scope, deploymentName, top), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(String nextPageLink) {
                return DeploymentOperationsInner.this.listAtScopeNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DeploymentOperationInner>> listAtScopeAsync(String scope, String deploymentName, Integer top) {
        return this.listAtScopeWithServiceResponseAsync(scope, deploymentName, top).map((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Page<DeploymentOperationInner>>(){

            public Page<DeploymentOperationInner> call(ServiceResponse<Page<DeploymentOperationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listAtScopeWithServiceResponseAsync(String scope, String deploymentName, Integer top) {
        return this.listAtScopeSinglePageAsync(scope, deploymentName, top).concatMap((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(ServiceResponse<Page<DeploymentOperationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DeploymentOperationsInner.this.listAtScopeNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listAtScopeSinglePageAsync(String scope, String deploymentName, Integer top) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listAtScope(scope, deploymentName, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DeploymentOperationsInner.this.listAtScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DeploymentOperationInner>> listAtScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DeploymentOperationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DeploymentOperationInner getAtTenantScope(String deploymentName, String operationId) {
        return (DeploymentOperationInner)((ServiceResponse)this.getAtTenantScopeWithServiceResponseAsync(deploymentName, operationId).toBlocking().single()).body();
    }

    public ServiceFuture<DeploymentOperationInner> getAtTenantScopeAsync(String deploymentName, String operationId, ServiceCallback<DeploymentOperationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getAtTenantScopeWithServiceResponseAsync(deploymentName, operationId), serviceCallback);
    }

    public Observable<DeploymentOperationInner> getAtTenantScopeAsync(String deploymentName, String operationId) {
        return this.getAtTenantScopeWithServiceResponseAsync(deploymentName, operationId).map((Func1)new Func1<ServiceResponse<DeploymentOperationInner>, DeploymentOperationInner>(){

            public DeploymentOperationInner call(ServiceResponse<DeploymentOperationInner> response) {
                return (DeploymentOperationInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DeploymentOperationInner>> getAtTenantScopeWithServiceResponseAsync(String deploymentName, String operationId) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (operationId == null) {
            throw new IllegalArgumentException("Parameter operationId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getAtTenantScope(deploymentName, operationId, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentOperationInner>>>(){

            public Observable<ServiceResponse<DeploymentOperationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentOperationsInner.this.getAtTenantScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeploymentOperationInner> getAtTenantScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DeploymentOperationInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DeploymentOperationInner> listAtTenantScope(String deploymentName) {
        ServiceResponse response = (ServiceResponse)this.listAtTenantScopeSinglePageAsync(deploymentName).toBlocking().single();
        return new PagedList<DeploymentOperationInner>((Page)response.body()){

            public Page<DeploymentOperationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DeploymentOperationsInner.this.listAtTenantScopeNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeploymentOperationInner>> listAtTenantScopeAsync(String deploymentName, ListOperationCallback<DeploymentOperationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAtTenantScopeSinglePageAsync(deploymentName), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(String nextPageLink) {
                return DeploymentOperationsInner.this.listAtTenantScopeNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DeploymentOperationInner>> listAtTenantScopeAsync(String deploymentName) {
        return this.listAtTenantScopeWithServiceResponseAsync(deploymentName).map((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Page<DeploymentOperationInner>>(){

            public Page<DeploymentOperationInner> call(ServiceResponse<Page<DeploymentOperationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listAtTenantScopeWithServiceResponseAsync(String deploymentName) {
        return this.listAtTenantScopeSinglePageAsync(deploymentName).concatMap((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(ServiceResponse<Page<DeploymentOperationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DeploymentOperationsInner.this.listAtTenantScopeNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listAtTenantScopeSinglePageAsync(String deploymentName) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Integer top = null;
        return this.service.listAtTenantScope(deploymentName, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DeploymentOperationsInner.this.listAtTenantScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<DeploymentOperationInner> listAtTenantScope(String deploymentName, Integer top) {
        ServiceResponse response = (ServiceResponse)this.listAtTenantScopeSinglePageAsync(deploymentName, top).toBlocking().single();
        return new PagedList<DeploymentOperationInner>((Page)response.body()){

            public Page<DeploymentOperationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DeploymentOperationsInner.this.listAtTenantScopeNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeploymentOperationInner>> listAtTenantScopeAsync(String deploymentName, Integer top, ListOperationCallback<DeploymentOperationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAtTenantScopeSinglePageAsync(deploymentName, top), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(String nextPageLink) {
                return DeploymentOperationsInner.this.listAtTenantScopeNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DeploymentOperationInner>> listAtTenantScopeAsync(String deploymentName, Integer top) {
        return this.listAtTenantScopeWithServiceResponseAsync(deploymentName, top).map((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Page<DeploymentOperationInner>>(){

            public Page<DeploymentOperationInner> call(ServiceResponse<Page<DeploymentOperationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listAtTenantScopeWithServiceResponseAsync(String deploymentName, Integer top) {
        return this.listAtTenantScopeSinglePageAsync(deploymentName, top).concatMap((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(ServiceResponse<Page<DeploymentOperationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DeploymentOperationsInner.this.listAtTenantScopeNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listAtTenantScopeSinglePageAsync(String deploymentName, Integer top) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listAtTenantScope(deploymentName, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DeploymentOperationsInner.this.listAtTenantScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DeploymentOperationInner>> listAtTenantScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DeploymentOperationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DeploymentOperationInner getAtManagementGroupScope(String groupId, String deploymentName, String operationId) {
        return (DeploymentOperationInner)((ServiceResponse)this.getAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, operationId).toBlocking().single()).body();
    }

    public ServiceFuture<DeploymentOperationInner> getAtManagementGroupScopeAsync(String groupId, String deploymentName, String operationId, ServiceCallback<DeploymentOperationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, operationId), serviceCallback);
    }

    public Observable<DeploymentOperationInner> getAtManagementGroupScopeAsync(String groupId, String deploymentName, String operationId) {
        return this.getAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, operationId).map((Func1)new Func1<ServiceResponse<DeploymentOperationInner>, DeploymentOperationInner>(){

            public DeploymentOperationInner call(ServiceResponse<DeploymentOperationInner> response) {
                return (DeploymentOperationInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DeploymentOperationInner>> getAtManagementGroupScopeWithServiceResponseAsync(String groupId, String deploymentName, String operationId) {
        if (groupId == null) {
            throw new IllegalArgumentException("Parameter groupId is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (operationId == null) {
            throw new IllegalArgumentException("Parameter operationId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getAtManagementGroupScope(groupId, deploymentName, operationId, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentOperationInner>>>(){

            public Observable<ServiceResponse<DeploymentOperationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentOperationsInner.this.getAtManagementGroupScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeploymentOperationInner> getAtManagementGroupScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DeploymentOperationInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DeploymentOperationInner> listAtManagementGroupScope(String groupId, String deploymentName) {
        ServiceResponse response = (ServiceResponse)this.listAtManagementGroupScopeSinglePageAsync(groupId, deploymentName).toBlocking().single();
        return new PagedList<DeploymentOperationInner>((Page)response.body()){

            public Page<DeploymentOperationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DeploymentOperationsInner.this.listAtManagementGroupScopeNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeploymentOperationInner>> listAtManagementGroupScopeAsync(String groupId, String deploymentName, ListOperationCallback<DeploymentOperationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAtManagementGroupScopeSinglePageAsync(groupId, deploymentName), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(String nextPageLink) {
                return DeploymentOperationsInner.this.listAtManagementGroupScopeNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DeploymentOperationInner>> listAtManagementGroupScopeAsync(String groupId, String deploymentName) {
        return this.listAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName).map((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Page<DeploymentOperationInner>>(){

            public Page<DeploymentOperationInner> call(ServiceResponse<Page<DeploymentOperationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listAtManagementGroupScopeWithServiceResponseAsync(String groupId, String deploymentName) {
        return this.listAtManagementGroupScopeSinglePageAsync(groupId, deploymentName).concatMap((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(ServiceResponse<Page<DeploymentOperationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DeploymentOperationsInner.this.listAtManagementGroupScopeNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listAtManagementGroupScopeSinglePageAsync(String groupId, String deploymentName) {
        if (groupId == null) {
            throw new IllegalArgumentException("Parameter groupId is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Integer top = null;
        return this.service.listAtManagementGroupScope(groupId, deploymentName, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DeploymentOperationsInner.this.listAtManagementGroupScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<DeploymentOperationInner> listAtManagementGroupScope(String groupId, String deploymentName, Integer top) {
        ServiceResponse response = (ServiceResponse)this.listAtManagementGroupScopeSinglePageAsync(groupId, deploymentName, top).toBlocking().single();
        return new PagedList<DeploymentOperationInner>((Page)response.body()){

            public Page<DeploymentOperationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DeploymentOperationsInner.this.listAtManagementGroupScopeNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeploymentOperationInner>> listAtManagementGroupScopeAsync(String groupId, String deploymentName, Integer top, ListOperationCallback<DeploymentOperationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAtManagementGroupScopeSinglePageAsync(groupId, deploymentName, top), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(String nextPageLink) {
                return DeploymentOperationsInner.this.listAtManagementGroupScopeNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DeploymentOperationInner>> listAtManagementGroupScopeAsync(String groupId, String deploymentName, Integer top) {
        return this.listAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, top).map((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Page<DeploymentOperationInner>>(){

            public Page<DeploymentOperationInner> call(ServiceResponse<Page<DeploymentOperationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listAtManagementGroupScopeWithServiceResponseAsync(String groupId, String deploymentName, Integer top) {
        return this.listAtManagementGroupScopeSinglePageAsync(groupId, deploymentName, top).concatMap((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(ServiceResponse<Page<DeploymentOperationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DeploymentOperationsInner.this.listAtManagementGroupScopeNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listAtManagementGroupScopeSinglePageAsync(String groupId, String deploymentName, Integer top) {
        if (groupId == null) {
            throw new IllegalArgumentException("Parameter groupId is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listAtManagementGroupScope(groupId, deploymentName, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DeploymentOperationsInner.this.listAtManagementGroupScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DeploymentOperationInner>> listAtManagementGroupScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DeploymentOperationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DeploymentOperationInner getAtSubscriptionScope(String deploymentName, String operationId) {
        return (DeploymentOperationInner)((ServiceResponse)this.getAtSubscriptionScopeWithServiceResponseAsync(deploymentName, operationId).toBlocking().single()).body();
    }

    public ServiceFuture<DeploymentOperationInner> getAtSubscriptionScopeAsync(String deploymentName, String operationId, ServiceCallback<DeploymentOperationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getAtSubscriptionScopeWithServiceResponseAsync(deploymentName, operationId), serviceCallback);
    }

    public Observable<DeploymentOperationInner> getAtSubscriptionScopeAsync(String deploymentName, String operationId) {
        return this.getAtSubscriptionScopeWithServiceResponseAsync(deploymentName, operationId).map((Func1)new Func1<ServiceResponse<DeploymentOperationInner>, DeploymentOperationInner>(){

            public DeploymentOperationInner call(ServiceResponse<DeploymentOperationInner> response) {
                return (DeploymentOperationInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DeploymentOperationInner>> getAtSubscriptionScopeWithServiceResponseAsync(String deploymentName, String operationId) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (operationId == null) {
            throw new IllegalArgumentException("Parameter operationId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getAtSubscriptionScope(deploymentName, operationId, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentOperationInner>>>(){

            public Observable<ServiceResponse<DeploymentOperationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentOperationsInner.this.getAtSubscriptionScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeploymentOperationInner> getAtSubscriptionScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DeploymentOperationInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DeploymentOperationInner> listAtSubscriptionScope(String deploymentName) {
        ServiceResponse response = (ServiceResponse)this.listAtSubscriptionScopeSinglePageAsync(deploymentName).toBlocking().single();
        return new PagedList<DeploymentOperationInner>((Page)response.body()){

            public Page<DeploymentOperationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DeploymentOperationsInner.this.listAtSubscriptionScopeNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeploymentOperationInner>> listAtSubscriptionScopeAsync(String deploymentName, ListOperationCallback<DeploymentOperationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAtSubscriptionScopeSinglePageAsync(deploymentName), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(String nextPageLink) {
                return DeploymentOperationsInner.this.listAtSubscriptionScopeNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DeploymentOperationInner>> listAtSubscriptionScopeAsync(String deploymentName) {
        return this.listAtSubscriptionScopeWithServiceResponseAsync(deploymentName).map((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Page<DeploymentOperationInner>>(){

            public Page<DeploymentOperationInner> call(ServiceResponse<Page<DeploymentOperationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listAtSubscriptionScopeWithServiceResponseAsync(String deploymentName) {
        return this.listAtSubscriptionScopeSinglePageAsync(deploymentName).concatMap((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(ServiceResponse<Page<DeploymentOperationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DeploymentOperationsInner.this.listAtSubscriptionScopeNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listAtSubscriptionScopeSinglePageAsync(String deploymentName) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Integer top = null;
        return this.service.listAtSubscriptionScope(deploymentName, this.client.subscriptionId(), top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DeploymentOperationsInner.this.listAtSubscriptionScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<DeploymentOperationInner> listAtSubscriptionScope(String deploymentName, Integer top) {
        ServiceResponse response = (ServiceResponse)this.listAtSubscriptionScopeSinglePageAsync(deploymentName, top).toBlocking().single();
        return new PagedList<DeploymentOperationInner>((Page)response.body()){

            public Page<DeploymentOperationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DeploymentOperationsInner.this.listAtSubscriptionScopeNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeploymentOperationInner>> listAtSubscriptionScopeAsync(String deploymentName, Integer top, ListOperationCallback<DeploymentOperationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAtSubscriptionScopeSinglePageAsync(deploymentName, top), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(String nextPageLink) {
                return DeploymentOperationsInner.this.listAtSubscriptionScopeNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DeploymentOperationInner>> listAtSubscriptionScopeAsync(String deploymentName, Integer top) {
        return this.listAtSubscriptionScopeWithServiceResponseAsync(deploymentName, top).map((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Page<DeploymentOperationInner>>(){

            public Page<DeploymentOperationInner> call(ServiceResponse<Page<DeploymentOperationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listAtSubscriptionScopeWithServiceResponseAsync(String deploymentName, Integer top) {
        return this.listAtSubscriptionScopeSinglePageAsync(deploymentName, top).concatMap((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(ServiceResponse<Page<DeploymentOperationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DeploymentOperationsInner.this.listAtSubscriptionScopeNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listAtSubscriptionScopeSinglePageAsync(String deploymentName, Integer top) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listAtSubscriptionScope(deploymentName, this.client.subscriptionId(), top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DeploymentOperationsInner.this.listAtSubscriptionScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DeploymentOperationInner>> listAtSubscriptionScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DeploymentOperationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DeploymentOperationInner get(String resourceGroupName, String deploymentName, String operationId) {
        return (DeploymentOperationInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, deploymentName, operationId).toBlocking().single()).body();
    }

    public ServiceFuture<DeploymentOperationInner> getAsync(String resourceGroupName, String deploymentName, String operationId, ServiceCallback<DeploymentOperationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, deploymentName, operationId), serviceCallback);
    }

    public Observable<DeploymentOperationInner> getAsync(String resourceGroupName, String deploymentName, String operationId) {
        return this.getWithServiceResponseAsync(resourceGroupName, deploymentName, operationId).map((Func1)new Func1<ServiceResponse<DeploymentOperationInner>, DeploymentOperationInner>(){

            public DeploymentOperationInner call(ServiceResponse<DeploymentOperationInner> response) {
                return (DeploymentOperationInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DeploymentOperationInner>> getWithServiceResponseAsync(String resourceGroupName, String deploymentName, String operationId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (operationId == null) {
            throw new IllegalArgumentException("Parameter operationId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, deploymentName, operationId, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentOperationInner>>>(){

            public Observable<ServiceResponse<DeploymentOperationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentOperationsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeploymentOperationInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DeploymentOperationInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DeploymentOperationInner> listByResourceGroup(String resourceGroupName, String deploymentName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName, deploymentName).toBlocking().single();
        return new PagedList<DeploymentOperationInner>((Page)response.body()){

            public Page<DeploymentOperationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DeploymentOperationsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeploymentOperationInner>> listByResourceGroupAsync(String resourceGroupName, String deploymentName, ListOperationCallback<DeploymentOperationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName, deploymentName), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(String nextPageLink) {
                return DeploymentOperationsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DeploymentOperationInner>> listByResourceGroupAsync(String resourceGroupName, String deploymentName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName, deploymentName).map((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Page<DeploymentOperationInner>>(){

            public Page<DeploymentOperationInner> call(ServiceResponse<Page<DeploymentOperationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName, String deploymentName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName, deploymentName).concatMap((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(ServiceResponse<Page<DeploymentOperationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DeploymentOperationsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName, String deploymentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Integer top = null;
        return this.service.listByResourceGroup(resourceGroupName, deploymentName, this.client.subscriptionId(), top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DeploymentOperationsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<DeploymentOperationInner> listByResourceGroup(String resourceGroupName, String deploymentName, Integer top) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName, deploymentName, top).toBlocking().single();
        return new PagedList<DeploymentOperationInner>((Page)response.body()){

            public Page<DeploymentOperationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DeploymentOperationsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeploymentOperationInner>> listByResourceGroupAsync(String resourceGroupName, String deploymentName, Integer top, ListOperationCallback<DeploymentOperationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName, deploymentName, top), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(String nextPageLink) {
                return DeploymentOperationsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DeploymentOperationInner>> listByResourceGroupAsync(String resourceGroupName, String deploymentName, Integer top) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName, deploymentName, top).map((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Page<DeploymentOperationInner>>(){

            public Page<DeploymentOperationInner> call(ServiceResponse<Page<DeploymentOperationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName, String deploymentName, Integer top) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName, deploymentName, top).concatMap((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(ServiceResponse<Page<DeploymentOperationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DeploymentOperationsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName, String deploymentName, Integer top) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByResourceGroup(resourceGroupName, deploymentName, this.client.subscriptionId(), top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DeploymentOperationsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DeploymentOperationInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DeploymentOperationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DeploymentOperationInner> listAtScopeNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listAtScopeNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DeploymentOperationInner>((Page)response.body()){

            public Page<DeploymentOperationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DeploymentOperationsInner.this.listAtScopeNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeploymentOperationInner>> listAtScopeNextAsync(String nextPageLink, ServiceFuture<List<DeploymentOperationInner>> serviceFuture, ListOperationCallback<DeploymentOperationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAtScopeNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(String nextPageLink) {
                return DeploymentOperationsInner.this.listAtScopeNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DeploymentOperationInner>> listAtScopeNextAsync(String nextPageLink) {
        return this.listAtScopeNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Page<DeploymentOperationInner>>(){

            public Page<DeploymentOperationInner> call(ServiceResponse<Page<DeploymentOperationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listAtScopeNextWithServiceResponseAsync(String nextPageLink) {
        return this.listAtScopeNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(ServiceResponse<Page<DeploymentOperationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DeploymentOperationsInner.this.listAtScopeNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listAtScopeNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listAtScopeNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DeploymentOperationsInner.this.listAtScopeNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DeploymentOperationInner>> listAtScopeNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DeploymentOperationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DeploymentOperationInner> listAtTenantScopeNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listAtTenantScopeNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DeploymentOperationInner>((Page)response.body()){

            public Page<DeploymentOperationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DeploymentOperationsInner.this.listAtTenantScopeNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeploymentOperationInner>> listAtTenantScopeNextAsync(String nextPageLink, ServiceFuture<List<DeploymentOperationInner>> serviceFuture, ListOperationCallback<DeploymentOperationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAtTenantScopeNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(String nextPageLink) {
                return DeploymentOperationsInner.this.listAtTenantScopeNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DeploymentOperationInner>> listAtTenantScopeNextAsync(String nextPageLink) {
        return this.listAtTenantScopeNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Page<DeploymentOperationInner>>(){

            public Page<DeploymentOperationInner> call(ServiceResponse<Page<DeploymentOperationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listAtTenantScopeNextWithServiceResponseAsync(String nextPageLink) {
        return this.listAtTenantScopeNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(ServiceResponse<Page<DeploymentOperationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DeploymentOperationsInner.this.listAtTenantScopeNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listAtTenantScopeNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listAtTenantScopeNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DeploymentOperationsInner.this.listAtTenantScopeNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DeploymentOperationInner>> listAtTenantScopeNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DeploymentOperationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DeploymentOperationInner> listAtManagementGroupScopeNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listAtManagementGroupScopeNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DeploymentOperationInner>((Page)response.body()){

            public Page<DeploymentOperationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DeploymentOperationsInner.this.listAtManagementGroupScopeNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeploymentOperationInner>> listAtManagementGroupScopeNextAsync(String nextPageLink, ServiceFuture<List<DeploymentOperationInner>> serviceFuture, ListOperationCallback<DeploymentOperationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAtManagementGroupScopeNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(String nextPageLink) {
                return DeploymentOperationsInner.this.listAtManagementGroupScopeNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DeploymentOperationInner>> listAtManagementGroupScopeNextAsync(String nextPageLink) {
        return this.listAtManagementGroupScopeNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Page<DeploymentOperationInner>>(){

            public Page<DeploymentOperationInner> call(ServiceResponse<Page<DeploymentOperationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listAtManagementGroupScopeNextWithServiceResponseAsync(String nextPageLink) {
        return this.listAtManagementGroupScopeNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(ServiceResponse<Page<DeploymentOperationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DeploymentOperationsInner.this.listAtManagementGroupScopeNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listAtManagementGroupScopeNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listAtManagementGroupScopeNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DeploymentOperationsInner.this.listAtManagementGroupScopeNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DeploymentOperationInner>> listAtManagementGroupScopeNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DeploymentOperationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DeploymentOperationInner> listAtSubscriptionScopeNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listAtSubscriptionScopeNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DeploymentOperationInner>((Page)response.body()){

            public Page<DeploymentOperationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DeploymentOperationsInner.this.listAtSubscriptionScopeNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeploymentOperationInner>> listAtSubscriptionScopeNextAsync(String nextPageLink, ServiceFuture<List<DeploymentOperationInner>> serviceFuture, ListOperationCallback<DeploymentOperationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAtSubscriptionScopeNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(String nextPageLink) {
                return DeploymentOperationsInner.this.listAtSubscriptionScopeNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DeploymentOperationInner>> listAtSubscriptionScopeNextAsync(String nextPageLink) {
        return this.listAtSubscriptionScopeNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Page<DeploymentOperationInner>>(){

            public Page<DeploymentOperationInner> call(ServiceResponse<Page<DeploymentOperationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listAtSubscriptionScopeNextWithServiceResponseAsync(String nextPageLink) {
        return this.listAtSubscriptionScopeNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(ServiceResponse<Page<DeploymentOperationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DeploymentOperationsInner.this.listAtSubscriptionScopeNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listAtSubscriptionScopeNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listAtSubscriptionScopeNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DeploymentOperationsInner.this.listAtSubscriptionScopeNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DeploymentOperationInner>> listAtSubscriptionScopeNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DeploymentOperationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DeploymentOperationInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DeploymentOperationInner>((Page)response.body()){

            public Page<DeploymentOperationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DeploymentOperationsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeploymentOperationInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<DeploymentOperationInner>> serviceFuture, ListOperationCallback<DeploymentOperationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(String nextPageLink) {
                return DeploymentOperationsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DeploymentOperationInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Page<DeploymentOperationInner>>(){

            public Page<DeploymentOperationInner> call(ServiceResponse<Page<DeploymentOperationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DeploymentOperationInner>>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(ServiceResponse<Page<DeploymentOperationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DeploymentOperationsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentOperationInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentOperationInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentOperationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DeploymentOperationsInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DeploymentOperationInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DeploymentOperationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface DeploymentOperationsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.DeploymentOperations getAtScope"})
        @GET(value="{scope}/providers/Microsoft.Resources/deployments/{deploymentName}/operations/{operationId}")
        public Observable<Response<ResponseBody>> getAtScope(@Path(value="scope", encoded=true) String var1, @Path(value="deploymentName") String var2, @Path(value="operationId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.DeploymentOperations listAtScope"})
        @GET(value="{scope}/providers/Microsoft.Resources/deployments/{deploymentName}/operations")
        public Observable<Response<ResponseBody>> listAtScope(@Path(value="scope", encoded=true) String var1, @Path(value="deploymentName") String var2, @Query(value="$top") Integer var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.DeploymentOperations getAtTenantScope"})
        @GET(value="providers/Microsoft.Resources/deployments/{deploymentName}/operations/{operationId}")
        public Observable<Response<ResponseBody>> getAtTenantScope(@Path(value="deploymentName") String var1, @Path(value="operationId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.DeploymentOperations listAtTenantScope"})
        @GET(value="providers/Microsoft.Resources/deployments/{deploymentName}/operations")
        public Observable<Response<ResponseBody>> listAtTenantScope(@Path(value="deploymentName") String var1, @Query(value="$top") Integer var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.DeploymentOperations getAtManagementGroupScope"})
        @GET(value="providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}/operations/{operationId}")
        public Observable<Response<ResponseBody>> getAtManagementGroupScope(@Path(value="groupId") String var1, @Path(value="deploymentName") String var2, @Path(value="operationId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.DeploymentOperations listAtManagementGroupScope"})
        @GET(value="providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}/operations")
        public Observable<Response<ResponseBody>> listAtManagementGroupScope(@Path(value="groupId") String var1, @Path(value="deploymentName") String var2, @Query(value="$top") Integer var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.DeploymentOperations getAtSubscriptionScope"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/operations/{operationId}")
        public Observable<Response<ResponseBody>> getAtSubscriptionScope(@Path(value="deploymentName") String var1, @Path(value="operationId") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.DeploymentOperations listAtSubscriptionScope"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/operations")
        public Observable<Response<ResponseBody>> listAtSubscriptionScope(@Path(value="deploymentName") String var1, @Path(value="subscriptionId") String var2, @Query(value="$top") Integer var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.DeploymentOperations get"})
        @GET(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/deployments/{deploymentName}/operations/{operationId}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="deploymentName") String var2, @Path(value="operationId") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.DeploymentOperations listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/deployments/{deploymentName}/operations")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="deploymentName") String var2, @Path(value="subscriptionId") String var3, @Query(value="$top") Integer var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.DeploymentOperations listAtScopeNext"})
        @GET
        public Observable<Response<ResponseBody>> listAtScopeNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.DeploymentOperations listAtTenantScopeNext"})
        @GET
        public Observable<Response<ResponseBody>> listAtTenantScopeNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.DeploymentOperations listAtManagementGroupScopeNext"})
        @GET
        public Observable<Response<ResponseBody>> listAtManagementGroupScopeNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.DeploymentOperations listAtSubscriptionScopeNext"})
        @GET
        public Observable<Response<ResponseBody>> listAtSubscriptionScopeNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.DeploymentOperations listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

