/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.LongRunningFinalState;
import com.microsoft.azure.LongRunningOperationOptions;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.DeploymentWhatIf;
import com.microsoft.azure.management.resources.DeploymentsWhatIfAtManagementGroupScopeHeaders;
import com.microsoft.azure.management.resources.DeploymentsWhatIfAtSubscriptionScopeHeaders;
import com.microsoft.azure.management.resources.DeploymentsWhatIfAtTenantScopeHeaders;
import com.microsoft.azure.management.resources.DeploymentsWhatIfHeaders;
import com.microsoft.azure.management.resources.ScopedDeployment;
import com.microsoft.azure.management.resources.ScopedDeploymentWhatIf;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.azure.management.resources.implementation.DeploymentExportResultInner;
import com.microsoft.azure.management.resources.implementation.DeploymentExtendedInner;
import com.microsoft.azure.management.resources.implementation.DeploymentInner;
import com.microsoft.azure.management.resources.implementation.DeploymentValidateResultInner;
import com.microsoft.azure.management.resources.implementation.PageImpl;
import com.microsoft.azure.management.resources.implementation.ResourceManagementClientImpl;
import com.microsoft.azure.management.resources.implementation.TemplateHashResultInner;
import com.microsoft.azure.management.resources.implementation.WhatIfOperationResultInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.ServiceResponseWithHeaders;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HEAD;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class DeploymentsInner
implements InnerSupportsGet<DeploymentExtendedInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<DeploymentExtendedInner> {
    private DeploymentsService service;
    private ResourceManagementClientImpl client;

    public DeploymentsInner(Retrofit retrofit, ResourceManagementClientImpl client) {
        this.service = (DeploymentsService)retrofit.create(DeploymentsService.class);
        this.client = client;
    }

    public void deleteAtScope(String scope, String deploymentName) {
        ((ServiceResponse)this.deleteAtScopeWithServiceResponseAsync(scope, deploymentName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAtScopeAsync(String scope, String deploymentName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteAtScopeWithServiceResponseAsync(scope, deploymentName), serviceCallback);
    }

    public Observable<Void> deleteAtScopeAsync(String scope, String deploymentName) {
        return this.deleteAtScopeWithServiceResponseAsync(scope, deploymentName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteAtScopeWithServiceResponseAsync(String scope, String deploymentName) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.deleteAtScope(scope, deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteAtScope(String scope, String deploymentName) {
        ((ServiceResponse)this.beginDeleteAtScopeWithServiceResponseAsync(scope, deploymentName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAtScopeAsync(String scope, String deploymentName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteAtScopeWithServiceResponseAsync(scope, deploymentName), serviceCallback);
    }

    public Observable<Void> beginDeleteAtScopeAsync(String scope, String deploymentName) {
        return this.beginDeleteAtScopeWithServiceResponseAsync(scope, deploymentName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteAtScopeWithServiceResponseAsync(String scope, String deploymentName) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDeleteAtScope(scope, deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.beginDeleteAtScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteAtScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public boolean checkExistenceAtScope(String scope, String deploymentName) {
        return (Boolean)((ServiceResponse)this.checkExistenceAtScopeWithServiceResponseAsync(scope, deploymentName).toBlocking().single()).body();
    }

    public ServiceFuture<Boolean> checkExistenceAtScopeAsync(String scope, String deploymentName, ServiceCallback<Boolean> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkExistenceAtScopeWithServiceResponseAsync(scope, deploymentName), serviceCallback);
    }

    public Observable<Boolean> checkExistenceAtScopeAsync(String scope, String deploymentName) {
        return this.checkExistenceAtScopeWithServiceResponseAsync(scope, deploymentName).map((Func1)new Func1<ServiceResponse<Boolean>, Boolean>(){

            public Boolean call(ServiceResponse<Boolean> response) {
                return (Boolean)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Boolean>> checkExistenceAtScopeWithServiceResponseAsync(String scope, String deploymentName) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.checkExistenceAtScope(scope, deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<Void>, Observable<ServiceResponse<Boolean>>>(){

            public Observable<ServiceResponse<Boolean>> call(Response<Void> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.checkExistenceAtScopeDelegate((Response<Void>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Boolean> checkExistenceAtScopeDelegate(Response<Void> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).buildEmpty(response);
    }

    public DeploymentExtendedInner createOrUpdateAtScope(String scope, String deploymentName, DeploymentInner parameters) {
        return (DeploymentExtendedInner)((Object)((ServiceResponse)this.createOrUpdateAtScopeWithServiceResponseAsync(scope, deploymentName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<DeploymentExtendedInner> createOrUpdateAtScopeAsync(String scope, String deploymentName, DeploymentInner parameters, ServiceCallback<DeploymentExtendedInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateAtScopeWithServiceResponseAsync(scope, deploymentName, parameters), serviceCallback);
    }

    public Observable<DeploymentExtendedInner> createOrUpdateAtScopeAsync(String scope, String deploymentName, DeploymentInner parameters) {
        return this.createOrUpdateAtScopeWithServiceResponseAsync(scope, deploymentName, parameters).map((Func1)new Func1<ServiceResponse<DeploymentExtendedInner>, DeploymentExtendedInner>(){

            public DeploymentExtendedInner call(ServiceResponse<DeploymentExtendedInner> response) {
                return (DeploymentExtendedInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DeploymentExtendedInner>> createOrUpdateAtScopeWithServiceResponseAsync(String scope, String deploymentName, DeploymentInner parameters) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdateAtScope(scope, deploymentName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DeploymentExtendedInner>(){}.getType());
    }

    public DeploymentExtendedInner beginCreateOrUpdateAtScope(String scope, String deploymentName, DeploymentInner parameters) {
        return (DeploymentExtendedInner)((Object)((ServiceResponse)this.beginCreateOrUpdateAtScopeWithServiceResponseAsync(scope, deploymentName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<DeploymentExtendedInner> beginCreateOrUpdateAtScopeAsync(String scope, String deploymentName, DeploymentInner parameters, ServiceCallback<DeploymentExtendedInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateAtScopeWithServiceResponseAsync(scope, deploymentName, parameters), serviceCallback);
    }

    public Observable<DeploymentExtendedInner> beginCreateOrUpdateAtScopeAsync(String scope, String deploymentName, DeploymentInner parameters) {
        return this.beginCreateOrUpdateAtScopeWithServiceResponseAsync(scope, deploymentName, parameters).map((Func1)new Func1<ServiceResponse<DeploymentExtendedInner>, DeploymentExtendedInner>(){

            public DeploymentExtendedInner call(ServiceResponse<DeploymentExtendedInner> response) {
                return (DeploymentExtendedInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DeploymentExtendedInner>> beginCreateOrUpdateAtScopeWithServiceResponseAsync(String scope, String deploymentName, DeploymentInner parameters) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.beginCreateOrUpdateAtScope(scope, deploymentName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentExtendedInner>>>(){

            public Observable<ServiceResponse<DeploymentExtendedInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.beginCreateOrUpdateAtScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeploymentExtendedInner> beginCreateOrUpdateAtScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DeploymentExtendedInner>(){}.getType()).register(201, new TypeToken<DeploymentExtendedInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DeploymentExtendedInner getAtScope(String scope, String deploymentName) {
        return (DeploymentExtendedInner)((Object)((ServiceResponse)this.getAtScopeWithServiceResponseAsync(scope, deploymentName).toBlocking().single()).body());
    }

    public ServiceFuture<DeploymentExtendedInner> getAtScopeAsync(String scope, String deploymentName, ServiceCallback<DeploymentExtendedInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getAtScopeWithServiceResponseAsync(scope, deploymentName), serviceCallback);
    }

    public Observable<DeploymentExtendedInner> getAtScopeAsync(String scope, String deploymentName) {
        return this.getAtScopeWithServiceResponseAsync(scope, deploymentName).map((Func1)new Func1<ServiceResponse<DeploymentExtendedInner>, DeploymentExtendedInner>(){

            public DeploymentExtendedInner call(ServiceResponse<DeploymentExtendedInner> response) {
                return (DeploymentExtendedInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DeploymentExtendedInner>> getAtScopeWithServiceResponseAsync(String scope, String deploymentName) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getAtScope(scope, deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentExtendedInner>>>(){

            public Observable<ServiceResponse<DeploymentExtendedInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.getAtScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeploymentExtendedInner> getAtScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DeploymentExtendedInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void cancelAtScope(String scope, String deploymentName) {
        ((ServiceResponse)this.cancelAtScopeWithServiceResponseAsync(scope, deploymentName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> cancelAtScopeAsync(String scope, String deploymentName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.cancelAtScopeWithServiceResponseAsync(scope, deploymentName), serviceCallback);
    }

    public Observable<Void> cancelAtScopeAsync(String scope, String deploymentName) {
        return this.cancelAtScopeWithServiceResponseAsync(scope, deploymentName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> cancelAtScopeWithServiceResponseAsync(String scope, String deploymentName) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.cancelAtScope(scope, deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.cancelAtScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> cancelAtScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DeploymentValidateResultInner validateAtScope(String scope, String deploymentName, DeploymentInner parameters) {
        return (DeploymentValidateResultInner)((ServiceResponse)this.validateAtScopeWithServiceResponseAsync(scope, deploymentName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<DeploymentValidateResultInner> validateAtScopeAsync(String scope, String deploymentName, DeploymentInner parameters, ServiceCallback<DeploymentValidateResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.validateAtScopeWithServiceResponseAsync(scope, deploymentName, parameters), serviceCallback);
    }

    public Observable<DeploymentValidateResultInner> validateAtScopeAsync(String scope, String deploymentName, DeploymentInner parameters) {
        return this.validateAtScopeWithServiceResponseAsync(scope, deploymentName, parameters).map((Func1)new Func1<ServiceResponse<DeploymentValidateResultInner>, DeploymentValidateResultInner>(){

            public DeploymentValidateResultInner call(ServiceResponse<DeploymentValidateResultInner> response) {
                return (DeploymentValidateResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DeploymentValidateResultInner>> validateAtScopeWithServiceResponseAsync(String scope, String deploymentName, DeploymentInner parameters) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        Observable<Response<ResponseBody>> observable = this.service.validateAtScope(scope, deploymentName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<DeploymentValidateResultInner>(){}.getType());
    }

    public DeploymentValidateResultInner beginValidateAtScope(String scope, String deploymentName, DeploymentInner parameters) {
        return (DeploymentValidateResultInner)((ServiceResponse)this.beginValidateAtScopeWithServiceResponseAsync(scope, deploymentName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<DeploymentValidateResultInner> beginValidateAtScopeAsync(String scope, String deploymentName, DeploymentInner parameters, ServiceCallback<DeploymentValidateResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginValidateAtScopeWithServiceResponseAsync(scope, deploymentName, parameters), serviceCallback);
    }

    public Observable<DeploymentValidateResultInner> beginValidateAtScopeAsync(String scope, String deploymentName, DeploymentInner parameters) {
        return this.beginValidateAtScopeWithServiceResponseAsync(scope, deploymentName, parameters).map((Func1)new Func1<ServiceResponse<DeploymentValidateResultInner>, DeploymentValidateResultInner>(){

            public DeploymentValidateResultInner call(ServiceResponse<DeploymentValidateResultInner> response) {
                return (DeploymentValidateResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DeploymentValidateResultInner>> beginValidateAtScopeWithServiceResponseAsync(String scope, String deploymentName, DeploymentInner parameters) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.beginValidateAtScope(scope, deploymentName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentValidateResultInner>>>(){

            public Observable<ServiceResponse<DeploymentValidateResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.beginValidateAtScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeploymentValidateResultInner> beginValidateAtScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DeploymentValidateResultInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(400, new TypeToken<DeploymentValidateResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DeploymentExportResultInner exportTemplateAtScope(String scope, String deploymentName) {
        return (DeploymentExportResultInner)((ServiceResponse)this.exportTemplateAtScopeWithServiceResponseAsync(scope, deploymentName).toBlocking().single()).body();
    }

    public ServiceFuture<DeploymentExportResultInner> exportTemplateAtScopeAsync(String scope, String deploymentName, ServiceCallback<DeploymentExportResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.exportTemplateAtScopeWithServiceResponseAsync(scope, deploymentName), serviceCallback);
    }

    public Observable<DeploymentExportResultInner> exportTemplateAtScopeAsync(String scope, String deploymentName) {
        return this.exportTemplateAtScopeWithServiceResponseAsync(scope, deploymentName).map((Func1)new Func1<ServiceResponse<DeploymentExportResultInner>, DeploymentExportResultInner>(){

            public DeploymentExportResultInner call(ServiceResponse<DeploymentExportResultInner> response) {
                return (DeploymentExportResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DeploymentExportResultInner>> exportTemplateAtScopeWithServiceResponseAsync(String scope, String deploymentName) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.exportTemplateAtScope(scope, deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentExportResultInner>>>(){

            public Observable<ServiceResponse<DeploymentExportResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.exportTemplateAtScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeploymentExportResultInner> exportTemplateAtScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DeploymentExportResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DeploymentExtendedInner> listAtScope(String scope) {
        ServiceResponse response = (ServiceResponse)this.listAtScopeSinglePageAsync(scope).toBlocking().single();
        return new PagedList<DeploymentExtendedInner>((Page)response.body()){

            public Page<DeploymentExtendedInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DeploymentsInner.this.listAtScopeNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeploymentExtendedInner>> listAtScopeAsync(String scope, ListOperationCallback<DeploymentExtendedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAtScopeSinglePageAsync(scope), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(String nextPageLink) {
                return DeploymentsInner.this.listAtScopeNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DeploymentExtendedInner>> listAtScopeAsync(String scope) {
        return this.listAtScopeWithServiceResponseAsync(scope).map((Func1)new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Page<DeploymentExtendedInner>>(){

            public Page<DeploymentExtendedInner> call(ServiceResponse<Page<DeploymentExtendedInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtScopeWithServiceResponseAsync(String scope) {
        return this.listAtScopeSinglePageAsync(scope).concatMap((Func1)new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(ServiceResponse<Page<DeploymentExtendedInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DeploymentsInner.this.listAtScopeNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtScopeSinglePageAsync(String scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        Integer top = null;
        return this.service.listAtScope(scope, filter, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DeploymentsInner.this.listAtScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<DeploymentExtendedInner> listAtScope(String scope, String filter, Integer top) {
        ServiceResponse response = (ServiceResponse)this.listAtScopeSinglePageAsync(scope, filter, top).toBlocking().single();
        return new PagedList<DeploymentExtendedInner>((Page)response.body()){

            public Page<DeploymentExtendedInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DeploymentsInner.this.listAtScopeNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeploymentExtendedInner>> listAtScopeAsync(String scope, String filter, Integer top, ListOperationCallback<DeploymentExtendedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAtScopeSinglePageAsync(scope, filter, top), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(String nextPageLink) {
                return DeploymentsInner.this.listAtScopeNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DeploymentExtendedInner>> listAtScopeAsync(String scope, String filter, Integer top) {
        return this.listAtScopeWithServiceResponseAsync(scope, filter, top).map((Func1)new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Page<DeploymentExtendedInner>>(){

            public Page<DeploymentExtendedInner> call(ServiceResponse<Page<DeploymentExtendedInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtScopeWithServiceResponseAsync(String scope, String filter, Integer top) {
        return this.listAtScopeSinglePageAsync(scope, filter, top).concatMap((Func1)new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(ServiceResponse<Page<DeploymentExtendedInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DeploymentsInner.this.listAtScopeNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtScopeSinglePageAsync(String scope, String filter, Integer top) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listAtScope(scope, filter, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DeploymentsInner.this.listAtScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DeploymentExtendedInner>> listAtScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DeploymentExtendedInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteAtTenantScope(String deploymentName) {
        ((ServiceResponse)this.deleteAtTenantScopeWithServiceResponseAsync(deploymentName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAtTenantScopeAsync(String deploymentName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteAtTenantScopeWithServiceResponseAsync(deploymentName), serviceCallback);
    }

    public Observable<Void> deleteAtTenantScopeAsync(String deploymentName) {
        return this.deleteAtTenantScopeWithServiceResponseAsync(deploymentName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteAtTenantScopeWithServiceResponseAsync(String deploymentName) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.deleteAtTenantScope(deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteAtTenantScope(String deploymentName) {
        ((ServiceResponse)this.beginDeleteAtTenantScopeWithServiceResponseAsync(deploymentName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAtTenantScopeAsync(String deploymentName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteAtTenantScopeWithServiceResponseAsync(deploymentName), serviceCallback);
    }

    public Observable<Void> beginDeleteAtTenantScopeAsync(String deploymentName) {
        return this.beginDeleteAtTenantScopeWithServiceResponseAsync(deploymentName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteAtTenantScopeWithServiceResponseAsync(String deploymentName) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDeleteAtTenantScope(deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.beginDeleteAtTenantScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteAtTenantScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public boolean checkExistenceAtTenantScope(String deploymentName) {
        return (Boolean)((ServiceResponse)this.checkExistenceAtTenantScopeWithServiceResponseAsync(deploymentName).toBlocking().single()).body();
    }

    public ServiceFuture<Boolean> checkExistenceAtTenantScopeAsync(String deploymentName, ServiceCallback<Boolean> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkExistenceAtTenantScopeWithServiceResponseAsync(deploymentName), serviceCallback);
    }

    public Observable<Boolean> checkExistenceAtTenantScopeAsync(String deploymentName) {
        return this.checkExistenceAtTenantScopeWithServiceResponseAsync(deploymentName).map((Func1)new Func1<ServiceResponse<Boolean>, Boolean>(){

            public Boolean call(ServiceResponse<Boolean> response) {
                return (Boolean)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Boolean>> checkExistenceAtTenantScopeWithServiceResponseAsync(String deploymentName) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.checkExistenceAtTenantScope(deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<Void>, Observable<ServiceResponse<Boolean>>>(){

            public Observable<ServiceResponse<Boolean>> call(Response<Void> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.checkExistenceAtTenantScopeDelegate((Response<Void>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Boolean> checkExistenceAtTenantScopeDelegate(Response<Void> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).buildEmpty(response);
    }

    public DeploymentExtendedInner createOrUpdateAtTenantScope(String deploymentName, ScopedDeployment parameters) {
        return (DeploymentExtendedInner)((Object)((ServiceResponse)this.createOrUpdateAtTenantScopeWithServiceResponseAsync(deploymentName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<DeploymentExtendedInner> createOrUpdateAtTenantScopeAsync(String deploymentName, ScopedDeployment parameters, ServiceCallback<DeploymentExtendedInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateAtTenantScopeWithServiceResponseAsync(deploymentName, parameters), serviceCallback);
    }

    public Observable<DeploymentExtendedInner> createOrUpdateAtTenantScopeAsync(String deploymentName, ScopedDeployment parameters) {
        return this.createOrUpdateAtTenantScopeWithServiceResponseAsync(deploymentName, parameters).map((Func1)new Func1<ServiceResponse<DeploymentExtendedInner>, DeploymentExtendedInner>(){

            public DeploymentExtendedInner call(ServiceResponse<DeploymentExtendedInner> response) {
                return (DeploymentExtendedInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DeploymentExtendedInner>> createOrUpdateAtTenantScopeWithServiceResponseAsync(String deploymentName, ScopedDeployment parameters) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdateAtTenantScope(deploymentName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DeploymentExtendedInner>(){}.getType());
    }

    public DeploymentExtendedInner beginCreateOrUpdateAtTenantScope(String deploymentName, ScopedDeployment parameters) {
        return (DeploymentExtendedInner)((Object)((ServiceResponse)this.beginCreateOrUpdateAtTenantScopeWithServiceResponseAsync(deploymentName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<DeploymentExtendedInner> beginCreateOrUpdateAtTenantScopeAsync(String deploymentName, ScopedDeployment parameters, ServiceCallback<DeploymentExtendedInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateAtTenantScopeWithServiceResponseAsync(deploymentName, parameters), serviceCallback);
    }

    public Observable<DeploymentExtendedInner> beginCreateOrUpdateAtTenantScopeAsync(String deploymentName, ScopedDeployment parameters) {
        return this.beginCreateOrUpdateAtTenantScopeWithServiceResponseAsync(deploymentName, parameters).map((Func1)new Func1<ServiceResponse<DeploymentExtendedInner>, DeploymentExtendedInner>(){

            public DeploymentExtendedInner call(ServiceResponse<DeploymentExtendedInner> response) {
                return (DeploymentExtendedInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DeploymentExtendedInner>> beginCreateOrUpdateAtTenantScopeWithServiceResponseAsync(String deploymentName, ScopedDeployment parameters) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.beginCreateOrUpdateAtTenantScope(deploymentName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentExtendedInner>>>(){

            public Observable<ServiceResponse<DeploymentExtendedInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.beginCreateOrUpdateAtTenantScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeploymentExtendedInner> beginCreateOrUpdateAtTenantScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DeploymentExtendedInner>(){}.getType()).register(201, new TypeToken<DeploymentExtendedInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DeploymentExtendedInner getAtTenantScope(String deploymentName) {
        return (DeploymentExtendedInner)((Object)((ServiceResponse)this.getAtTenantScopeWithServiceResponseAsync(deploymentName).toBlocking().single()).body());
    }

    public ServiceFuture<DeploymentExtendedInner> getAtTenantScopeAsync(String deploymentName, ServiceCallback<DeploymentExtendedInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getAtTenantScopeWithServiceResponseAsync(deploymentName), serviceCallback);
    }

    public Observable<DeploymentExtendedInner> getAtTenantScopeAsync(String deploymentName) {
        return this.getAtTenantScopeWithServiceResponseAsync(deploymentName).map((Func1)new Func1<ServiceResponse<DeploymentExtendedInner>, DeploymentExtendedInner>(){

            public DeploymentExtendedInner call(ServiceResponse<DeploymentExtendedInner> response) {
                return (DeploymentExtendedInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DeploymentExtendedInner>> getAtTenantScopeWithServiceResponseAsync(String deploymentName) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getAtTenantScope(deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentExtendedInner>>>(){

            public Observable<ServiceResponse<DeploymentExtendedInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.getAtTenantScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeploymentExtendedInner> getAtTenantScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DeploymentExtendedInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void cancelAtTenantScope(String deploymentName) {
        ((ServiceResponse)this.cancelAtTenantScopeWithServiceResponseAsync(deploymentName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> cancelAtTenantScopeAsync(String deploymentName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.cancelAtTenantScopeWithServiceResponseAsync(deploymentName), serviceCallback);
    }

    public Observable<Void> cancelAtTenantScopeAsync(String deploymentName) {
        return this.cancelAtTenantScopeWithServiceResponseAsync(deploymentName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> cancelAtTenantScopeWithServiceResponseAsync(String deploymentName) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.cancelAtTenantScope(deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.cancelAtTenantScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> cancelAtTenantScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DeploymentValidateResultInner validateAtTenantScope(String deploymentName, ScopedDeployment parameters) {
        return (DeploymentValidateResultInner)((ServiceResponse)this.validateAtTenantScopeWithServiceResponseAsync(deploymentName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<DeploymentValidateResultInner> validateAtTenantScopeAsync(String deploymentName, ScopedDeployment parameters, ServiceCallback<DeploymentValidateResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.validateAtTenantScopeWithServiceResponseAsync(deploymentName, parameters), serviceCallback);
    }

    public Observable<DeploymentValidateResultInner> validateAtTenantScopeAsync(String deploymentName, ScopedDeployment parameters) {
        return this.validateAtTenantScopeWithServiceResponseAsync(deploymentName, parameters).map((Func1)new Func1<ServiceResponse<DeploymentValidateResultInner>, DeploymentValidateResultInner>(){

            public DeploymentValidateResultInner call(ServiceResponse<DeploymentValidateResultInner> response) {
                return (DeploymentValidateResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DeploymentValidateResultInner>> validateAtTenantScopeWithServiceResponseAsync(String deploymentName, ScopedDeployment parameters) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        Observable<Response<ResponseBody>> observable = this.service.validateAtTenantScope(deploymentName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<DeploymentValidateResultInner>(){}.getType());
    }

    public DeploymentValidateResultInner beginValidateAtTenantScope(String deploymentName, ScopedDeployment parameters) {
        return (DeploymentValidateResultInner)((ServiceResponse)this.beginValidateAtTenantScopeWithServiceResponseAsync(deploymentName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<DeploymentValidateResultInner> beginValidateAtTenantScopeAsync(String deploymentName, ScopedDeployment parameters, ServiceCallback<DeploymentValidateResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginValidateAtTenantScopeWithServiceResponseAsync(deploymentName, parameters), serviceCallback);
    }

    public Observable<DeploymentValidateResultInner> beginValidateAtTenantScopeAsync(String deploymentName, ScopedDeployment parameters) {
        return this.beginValidateAtTenantScopeWithServiceResponseAsync(deploymentName, parameters).map((Func1)new Func1<ServiceResponse<DeploymentValidateResultInner>, DeploymentValidateResultInner>(){

            public DeploymentValidateResultInner call(ServiceResponse<DeploymentValidateResultInner> response) {
                return (DeploymentValidateResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DeploymentValidateResultInner>> beginValidateAtTenantScopeWithServiceResponseAsync(String deploymentName, ScopedDeployment parameters) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.beginValidateAtTenantScope(deploymentName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentValidateResultInner>>>(){

            public Observable<ServiceResponse<DeploymentValidateResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.beginValidateAtTenantScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeploymentValidateResultInner> beginValidateAtTenantScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DeploymentValidateResultInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(400, new TypeToken<DeploymentValidateResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public WhatIfOperationResultInner whatIfAtTenantScope(String deploymentName, ScopedDeploymentWhatIf parameters) {
        return (WhatIfOperationResultInner)((ServiceResponseWithHeaders)this.whatIfAtTenantScopeWithServiceResponseAsync(deploymentName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<WhatIfOperationResultInner> whatIfAtTenantScopeAsync(String deploymentName, ScopedDeploymentWhatIf parameters, ServiceCallback<WhatIfOperationResultInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.whatIfAtTenantScopeWithServiceResponseAsync(deploymentName, parameters), serviceCallback);
    }

    public Observable<WhatIfOperationResultInner> whatIfAtTenantScopeAsync(String deploymentName, ScopedDeploymentWhatIf parameters) {
        return this.whatIfAtTenantScopeWithServiceResponseAsync(deploymentName, parameters).map((Func1)new Func1<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtTenantScopeHeaders>, WhatIfOperationResultInner>(){

            public WhatIfOperationResultInner call(ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtTenantScopeHeaders> response) {
                return (WhatIfOperationResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtTenantScopeHeaders>> whatIfAtTenantScopeWithServiceResponseAsync(String deploymentName, ScopedDeploymentWhatIf parameters) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        Observable<Response<ResponseBody>> observable = this.service.whatIfAtTenantScope(deploymentName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultWithHeadersAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<WhatIfOperationResultInner>(){}.getType(), DeploymentsWhatIfAtTenantScopeHeaders.class);
    }

    public WhatIfOperationResultInner beginWhatIfAtTenantScope(String deploymentName, ScopedDeploymentWhatIf parameters) {
        return (WhatIfOperationResultInner)((ServiceResponseWithHeaders)this.beginWhatIfAtTenantScopeWithServiceResponseAsync(deploymentName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<WhatIfOperationResultInner> beginWhatIfAtTenantScopeAsync(String deploymentName, ScopedDeploymentWhatIf parameters, ServiceCallback<WhatIfOperationResultInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.beginWhatIfAtTenantScopeWithServiceResponseAsync(deploymentName, parameters), serviceCallback);
    }

    public Observable<WhatIfOperationResultInner> beginWhatIfAtTenantScopeAsync(String deploymentName, ScopedDeploymentWhatIf parameters) {
        return this.beginWhatIfAtTenantScopeWithServiceResponseAsync(deploymentName, parameters).map((Func1)new Func1<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtTenantScopeHeaders>, WhatIfOperationResultInner>(){

            public WhatIfOperationResultInner call(ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtTenantScopeHeaders> response) {
                return (WhatIfOperationResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtTenantScopeHeaders>> beginWhatIfAtTenantScopeWithServiceResponseAsync(String deploymentName, ScopedDeploymentWhatIf parameters) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.beginWhatIfAtTenantScope(deploymentName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtTenantScopeHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtTenantScopeHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = DeploymentsInner.this.beginWhatIfAtTenantScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtTenantScopeHeaders> beginWhatIfAtTenantScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<WhatIfOperationResultInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).buildWithHeaders(response, DeploymentsWhatIfAtTenantScopeHeaders.class);
    }

    public DeploymentExportResultInner exportTemplateAtTenantScope(String deploymentName) {
        return (DeploymentExportResultInner)((ServiceResponse)this.exportTemplateAtTenantScopeWithServiceResponseAsync(deploymentName).toBlocking().single()).body();
    }

    public ServiceFuture<DeploymentExportResultInner> exportTemplateAtTenantScopeAsync(String deploymentName, ServiceCallback<DeploymentExportResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.exportTemplateAtTenantScopeWithServiceResponseAsync(deploymentName), serviceCallback);
    }

    public Observable<DeploymentExportResultInner> exportTemplateAtTenantScopeAsync(String deploymentName) {
        return this.exportTemplateAtTenantScopeWithServiceResponseAsync(deploymentName).map((Func1)new Func1<ServiceResponse<DeploymentExportResultInner>, DeploymentExportResultInner>(){

            public DeploymentExportResultInner call(ServiceResponse<DeploymentExportResultInner> response) {
                return (DeploymentExportResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DeploymentExportResultInner>> exportTemplateAtTenantScopeWithServiceResponseAsync(String deploymentName) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.exportTemplateAtTenantScope(deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentExportResultInner>>>(){

            public Observable<ServiceResponse<DeploymentExportResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.exportTemplateAtTenantScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeploymentExportResultInner> exportTemplateAtTenantScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DeploymentExportResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DeploymentExtendedInner> listAtTenantScope() {
        ServiceResponse response = (ServiceResponse)this.listAtTenantScopeSinglePageAsync().toBlocking().single();
        return new PagedList<DeploymentExtendedInner>((Page)response.body()){

            public Page<DeploymentExtendedInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DeploymentsInner.this.listAtTenantScopeNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeploymentExtendedInner>> listAtTenantScopeAsync(ListOperationCallback<DeploymentExtendedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAtTenantScopeSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(String nextPageLink) {
                return DeploymentsInner.this.listAtTenantScopeNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DeploymentExtendedInner>> listAtTenantScopeAsync() {
        return this.listAtTenantScopeWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Page<DeploymentExtendedInner>>(){

            public Page<DeploymentExtendedInner> call(ServiceResponse<Page<DeploymentExtendedInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtTenantScopeWithServiceResponseAsync() {
        return this.listAtTenantScopeSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(ServiceResponse<Page<DeploymentExtendedInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DeploymentsInner.this.listAtTenantScopeNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtTenantScopeSinglePageAsync() {
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        Integer top = null;
        return this.service.listAtTenantScope(filter, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DeploymentsInner.this.listAtTenantScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<DeploymentExtendedInner> listAtTenantScope(String filter, Integer top) {
        ServiceResponse response = (ServiceResponse)this.listAtTenantScopeSinglePageAsync(filter, top).toBlocking().single();
        return new PagedList<DeploymentExtendedInner>((Page)response.body()){

            public Page<DeploymentExtendedInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DeploymentsInner.this.listAtTenantScopeNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeploymentExtendedInner>> listAtTenantScopeAsync(String filter, Integer top, ListOperationCallback<DeploymentExtendedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAtTenantScopeSinglePageAsync(filter, top), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(String nextPageLink) {
                return DeploymentsInner.this.listAtTenantScopeNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DeploymentExtendedInner>> listAtTenantScopeAsync(String filter, Integer top) {
        return this.listAtTenantScopeWithServiceResponseAsync(filter, top).map((Func1)new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Page<DeploymentExtendedInner>>(){

            public Page<DeploymentExtendedInner> call(ServiceResponse<Page<DeploymentExtendedInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtTenantScopeWithServiceResponseAsync(String filter, Integer top) {
        return this.listAtTenantScopeSinglePageAsync(filter, top).concatMap((Func1)new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(ServiceResponse<Page<DeploymentExtendedInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DeploymentsInner.this.listAtTenantScopeNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtTenantScopeSinglePageAsync(String filter, Integer top) {
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listAtTenantScope(filter, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DeploymentsInner.this.listAtTenantScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DeploymentExtendedInner>> listAtTenantScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DeploymentExtendedInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteAtManagementGroupScope(String groupId, String deploymentName) {
        ((ServiceResponse)this.deleteAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAtManagementGroupScopeAsync(String groupId, String deploymentName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName), serviceCallback);
    }

    public Observable<Void> deleteAtManagementGroupScopeAsync(String groupId, String deploymentName) {
        return this.deleteAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteAtManagementGroupScopeWithServiceResponseAsync(String groupId, String deploymentName) {
        if (groupId == null) {
            throw new IllegalArgumentException("Parameter groupId is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.deleteAtManagementGroupScope(groupId, deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteAtManagementGroupScope(String groupId, String deploymentName) {
        ((ServiceResponse)this.beginDeleteAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAtManagementGroupScopeAsync(String groupId, String deploymentName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName), serviceCallback);
    }

    public Observable<Void> beginDeleteAtManagementGroupScopeAsync(String groupId, String deploymentName) {
        return this.beginDeleteAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteAtManagementGroupScopeWithServiceResponseAsync(String groupId, String deploymentName) {
        if (groupId == null) {
            throw new IllegalArgumentException("Parameter groupId is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDeleteAtManagementGroupScope(groupId, deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.beginDeleteAtManagementGroupScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteAtManagementGroupScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public boolean checkExistenceAtManagementGroupScope(String groupId, String deploymentName) {
        return (Boolean)((ServiceResponse)this.checkExistenceAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName).toBlocking().single()).body();
    }

    public ServiceFuture<Boolean> checkExistenceAtManagementGroupScopeAsync(String groupId, String deploymentName, ServiceCallback<Boolean> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkExistenceAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName), serviceCallback);
    }

    public Observable<Boolean> checkExistenceAtManagementGroupScopeAsync(String groupId, String deploymentName) {
        return this.checkExistenceAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName).map((Func1)new Func1<ServiceResponse<Boolean>, Boolean>(){

            public Boolean call(ServiceResponse<Boolean> response) {
                return (Boolean)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Boolean>> checkExistenceAtManagementGroupScopeWithServiceResponseAsync(String groupId, String deploymentName) {
        if (groupId == null) {
            throw new IllegalArgumentException("Parameter groupId is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.checkExistenceAtManagementGroupScope(groupId, deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<Void>, Observable<ServiceResponse<Boolean>>>(){

            public Observable<ServiceResponse<Boolean>> call(Response<Void> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.checkExistenceAtManagementGroupScopeDelegate((Response<Void>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Boolean> checkExistenceAtManagementGroupScopeDelegate(Response<Void> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).buildEmpty(response);
    }

    public DeploymentExtendedInner createOrUpdateAtManagementGroupScope(String groupId, String deploymentName, ScopedDeployment parameters) {
        return (DeploymentExtendedInner)((Object)((ServiceResponse)this.createOrUpdateAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<DeploymentExtendedInner> createOrUpdateAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeployment parameters, ServiceCallback<DeploymentExtendedInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters), serviceCallback);
    }

    public Observable<DeploymentExtendedInner> createOrUpdateAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeployment parameters) {
        return this.createOrUpdateAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters).map((Func1)new Func1<ServiceResponse<DeploymentExtendedInner>, DeploymentExtendedInner>(){

            public DeploymentExtendedInner call(ServiceResponse<DeploymentExtendedInner> response) {
                return (DeploymentExtendedInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DeploymentExtendedInner>> createOrUpdateAtManagementGroupScopeWithServiceResponseAsync(String groupId, String deploymentName, ScopedDeployment parameters) {
        if (groupId == null) {
            throw new IllegalArgumentException("Parameter groupId is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdateAtManagementGroupScope(groupId, deploymentName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DeploymentExtendedInner>(){}.getType());
    }

    public DeploymentExtendedInner beginCreateOrUpdateAtManagementGroupScope(String groupId, String deploymentName, ScopedDeployment parameters) {
        return (DeploymentExtendedInner)((Object)((ServiceResponse)this.beginCreateOrUpdateAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<DeploymentExtendedInner> beginCreateOrUpdateAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeployment parameters, ServiceCallback<DeploymentExtendedInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters), serviceCallback);
    }

    public Observable<DeploymentExtendedInner> beginCreateOrUpdateAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeployment parameters) {
        return this.beginCreateOrUpdateAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters).map((Func1)new Func1<ServiceResponse<DeploymentExtendedInner>, DeploymentExtendedInner>(){

            public DeploymentExtendedInner call(ServiceResponse<DeploymentExtendedInner> response) {
                return (DeploymentExtendedInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DeploymentExtendedInner>> beginCreateOrUpdateAtManagementGroupScopeWithServiceResponseAsync(String groupId, String deploymentName, ScopedDeployment parameters) {
        if (groupId == null) {
            throw new IllegalArgumentException("Parameter groupId is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.beginCreateOrUpdateAtManagementGroupScope(groupId, deploymentName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentExtendedInner>>>(){

            public Observable<ServiceResponse<DeploymentExtendedInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.beginCreateOrUpdateAtManagementGroupScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeploymentExtendedInner> beginCreateOrUpdateAtManagementGroupScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DeploymentExtendedInner>(){}.getType()).register(201, new TypeToken<DeploymentExtendedInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DeploymentExtendedInner getAtManagementGroupScope(String groupId, String deploymentName) {
        return (DeploymentExtendedInner)((Object)((ServiceResponse)this.getAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName).toBlocking().single()).body());
    }

    public ServiceFuture<DeploymentExtendedInner> getAtManagementGroupScopeAsync(String groupId, String deploymentName, ServiceCallback<DeploymentExtendedInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName), serviceCallback);
    }

    public Observable<DeploymentExtendedInner> getAtManagementGroupScopeAsync(String groupId, String deploymentName) {
        return this.getAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName).map((Func1)new Func1<ServiceResponse<DeploymentExtendedInner>, DeploymentExtendedInner>(){

            public DeploymentExtendedInner call(ServiceResponse<DeploymentExtendedInner> response) {
                return (DeploymentExtendedInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DeploymentExtendedInner>> getAtManagementGroupScopeWithServiceResponseAsync(String groupId, String deploymentName) {
        if (groupId == null) {
            throw new IllegalArgumentException("Parameter groupId is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getAtManagementGroupScope(groupId, deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentExtendedInner>>>(){

            public Observable<ServiceResponse<DeploymentExtendedInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.getAtManagementGroupScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeploymentExtendedInner> getAtManagementGroupScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DeploymentExtendedInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void cancelAtManagementGroupScope(String groupId, String deploymentName) {
        ((ServiceResponse)this.cancelAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> cancelAtManagementGroupScopeAsync(String groupId, String deploymentName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.cancelAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName), serviceCallback);
    }

    public Observable<Void> cancelAtManagementGroupScopeAsync(String groupId, String deploymentName) {
        return this.cancelAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> cancelAtManagementGroupScopeWithServiceResponseAsync(String groupId, String deploymentName) {
        if (groupId == null) {
            throw new IllegalArgumentException("Parameter groupId is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.cancelAtManagementGroupScope(groupId, deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.cancelAtManagementGroupScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> cancelAtManagementGroupScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DeploymentValidateResultInner validateAtManagementGroupScope(String groupId, String deploymentName, ScopedDeployment parameters) {
        return (DeploymentValidateResultInner)((ServiceResponse)this.validateAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<DeploymentValidateResultInner> validateAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeployment parameters, ServiceCallback<DeploymentValidateResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.validateAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters), serviceCallback);
    }

    public Observable<DeploymentValidateResultInner> validateAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeployment parameters) {
        return this.validateAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters).map((Func1)new Func1<ServiceResponse<DeploymentValidateResultInner>, DeploymentValidateResultInner>(){

            public DeploymentValidateResultInner call(ServiceResponse<DeploymentValidateResultInner> response) {
                return (DeploymentValidateResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DeploymentValidateResultInner>> validateAtManagementGroupScopeWithServiceResponseAsync(String groupId, String deploymentName, ScopedDeployment parameters) {
        if (groupId == null) {
            throw new IllegalArgumentException("Parameter groupId is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        Observable<Response<ResponseBody>> observable = this.service.validateAtManagementGroupScope(groupId, deploymentName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<DeploymentValidateResultInner>(){}.getType());
    }

    public DeploymentValidateResultInner beginValidateAtManagementGroupScope(String groupId, String deploymentName, ScopedDeployment parameters) {
        return (DeploymentValidateResultInner)((ServiceResponse)this.beginValidateAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<DeploymentValidateResultInner> beginValidateAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeployment parameters, ServiceCallback<DeploymentValidateResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginValidateAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters), serviceCallback);
    }

    public Observable<DeploymentValidateResultInner> beginValidateAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeployment parameters) {
        return this.beginValidateAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters).map((Func1)new Func1<ServiceResponse<DeploymentValidateResultInner>, DeploymentValidateResultInner>(){

            public DeploymentValidateResultInner call(ServiceResponse<DeploymentValidateResultInner> response) {
                return (DeploymentValidateResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DeploymentValidateResultInner>> beginValidateAtManagementGroupScopeWithServiceResponseAsync(String groupId, String deploymentName, ScopedDeployment parameters) {
        if (groupId == null) {
            throw new IllegalArgumentException("Parameter groupId is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.beginValidateAtManagementGroupScope(groupId, deploymentName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentValidateResultInner>>>(){

            public Observable<ServiceResponse<DeploymentValidateResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.beginValidateAtManagementGroupScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeploymentValidateResultInner> beginValidateAtManagementGroupScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DeploymentValidateResultInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(400, new TypeToken<DeploymentValidateResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public WhatIfOperationResultInner whatIfAtManagementGroupScope(String groupId, String deploymentName, ScopedDeploymentWhatIf parameters) {
        return (WhatIfOperationResultInner)((ServiceResponseWithHeaders)this.whatIfAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<WhatIfOperationResultInner> whatIfAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeploymentWhatIf parameters, ServiceCallback<WhatIfOperationResultInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.whatIfAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters), serviceCallback);
    }

    public Observable<WhatIfOperationResultInner> whatIfAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeploymentWhatIf parameters) {
        return this.whatIfAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters).map((Func1)new Func1<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtManagementGroupScopeHeaders>, WhatIfOperationResultInner>(){

            public WhatIfOperationResultInner call(ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtManagementGroupScopeHeaders> response) {
                return (WhatIfOperationResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtManagementGroupScopeHeaders>> whatIfAtManagementGroupScopeWithServiceResponseAsync(String groupId, String deploymentName, ScopedDeploymentWhatIf parameters) {
        if (groupId == null) {
            throw new IllegalArgumentException("Parameter groupId is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        Observable<Response<ResponseBody>> observable = this.service.whatIfAtManagementGroupScope(groupId, deploymentName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultWithHeadersAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<WhatIfOperationResultInner>(){}.getType(), DeploymentsWhatIfAtManagementGroupScopeHeaders.class);
    }

    public WhatIfOperationResultInner beginWhatIfAtManagementGroupScope(String groupId, String deploymentName, ScopedDeploymentWhatIf parameters) {
        return (WhatIfOperationResultInner)((ServiceResponseWithHeaders)this.beginWhatIfAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<WhatIfOperationResultInner> beginWhatIfAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeploymentWhatIf parameters, ServiceCallback<WhatIfOperationResultInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.beginWhatIfAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters), serviceCallback);
    }

    public Observable<WhatIfOperationResultInner> beginWhatIfAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeploymentWhatIf parameters) {
        return this.beginWhatIfAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName, parameters).map((Func1)new Func1<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtManagementGroupScopeHeaders>, WhatIfOperationResultInner>(){

            public WhatIfOperationResultInner call(ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtManagementGroupScopeHeaders> response) {
                return (WhatIfOperationResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtManagementGroupScopeHeaders>> beginWhatIfAtManagementGroupScopeWithServiceResponseAsync(String groupId, String deploymentName, ScopedDeploymentWhatIf parameters) {
        if (groupId == null) {
            throw new IllegalArgumentException("Parameter groupId is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.beginWhatIfAtManagementGroupScope(groupId, deploymentName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtManagementGroupScopeHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtManagementGroupScopeHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = DeploymentsInner.this.beginWhatIfAtManagementGroupScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtManagementGroupScopeHeaders> beginWhatIfAtManagementGroupScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<WhatIfOperationResultInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).buildWithHeaders(response, DeploymentsWhatIfAtManagementGroupScopeHeaders.class);
    }

    public DeploymentExportResultInner exportTemplateAtManagementGroupScope(String groupId, String deploymentName) {
        return (DeploymentExportResultInner)((ServiceResponse)this.exportTemplateAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName).toBlocking().single()).body();
    }

    public ServiceFuture<DeploymentExportResultInner> exportTemplateAtManagementGroupScopeAsync(String groupId, String deploymentName, ServiceCallback<DeploymentExportResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.exportTemplateAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName), serviceCallback);
    }

    public Observable<DeploymentExportResultInner> exportTemplateAtManagementGroupScopeAsync(String groupId, String deploymentName) {
        return this.exportTemplateAtManagementGroupScopeWithServiceResponseAsync(groupId, deploymentName).map((Func1)new Func1<ServiceResponse<DeploymentExportResultInner>, DeploymentExportResultInner>(){

            public DeploymentExportResultInner call(ServiceResponse<DeploymentExportResultInner> response) {
                return (DeploymentExportResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DeploymentExportResultInner>> exportTemplateAtManagementGroupScopeWithServiceResponseAsync(String groupId, String deploymentName) {
        if (groupId == null) {
            throw new IllegalArgumentException("Parameter groupId is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.exportTemplateAtManagementGroupScope(groupId, deploymentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentExportResultInner>>>(){

            public Observable<ServiceResponse<DeploymentExportResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.exportTemplateAtManagementGroupScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeploymentExportResultInner> exportTemplateAtManagementGroupScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DeploymentExportResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DeploymentExtendedInner> listAtManagementGroupScope(String groupId) {
        ServiceResponse response = (ServiceResponse)this.listAtManagementGroupScopeSinglePageAsync(groupId).toBlocking().single();
        return new PagedList<DeploymentExtendedInner>((Page)response.body()){

            public Page<DeploymentExtendedInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DeploymentsInner.this.listAtManagementGroupScopeNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeploymentExtendedInner>> listAtManagementGroupScopeAsync(String groupId, ListOperationCallback<DeploymentExtendedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAtManagementGroupScopeSinglePageAsync(groupId), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(String nextPageLink) {
                return DeploymentsInner.this.listAtManagementGroupScopeNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DeploymentExtendedInner>> listAtManagementGroupScopeAsync(String groupId) {
        return this.listAtManagementGroupScopeWithServiceResponseAsync(groupId).map((Func1)new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Page<DeploymentExtendedInner>>(){

            public Page<DeploymentExtendedInner> call(ServiceResponse<Page<DeploymentExtendedInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtManagementGroupScopeWithServiceResponseAsync(String groupId) {
        return this.listAtManagementGroupScopeSinglePageAsync(groupId).concatMap((Func1)new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(ServiceResponse<Page<DeploymentExtendedInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DeploymentsInner.this.listAtManagementGroupScopeNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtManagementGroupScopeSinglePageAsync(String groupId) {
        if (groupId == null) {
            throw new IllegalArgumentException("Parameter groupId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        Integer top = null;
        return this.service.listAtManagementGroupScope(groupId, filter, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DeploymentsInner.this.listAtManagementGroupScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<DeploymentExtendedInner> listAtManagementGroupScope(String groupId, String filter, Integer top) {
        ServiceResponse response = (ServiceResponse)this.listAtManagementGroupScopeSinglePageAsync(groupId, filter, top).toBlocking().single();
        return new PagedList<DeploymentExtendedInner>((Page)response.body()){

            public Page<DeploymentExtendedInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DeploymentsInner.this.listAtManagementGroupScopeNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeploymentExtendedInner>> listAtManagementGroupScopeAsync(String groupId, String filter, Integer top, ListOperationCallback<DeploymentExtendedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAtManagementGroupScopeSinglePageAsync(groupId, filter, top), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(String nextPageLink) {
                return DeploymentsInner.this.listAtManagementGroupScopeNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DeploymentExtendedInner>> listAtManagementGroupScopeAsync(String groupId, String filter, Integer top) {
        return this.listAtManagementGroupScopeWithServiceResponseAsync(groupId, filter, top).map((Func1)new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Page<DeploymentExtendedInner>>(){

            public Page<DeploymentExtendedInner> call(ServiceResponse<Page<DeploymentExtendedInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtManagementGroupScopeWithServiceResponseAsync(String groupId, String filter, Integer top) {
        return this.listAtManagementGroupScopeSinglePageAsync(groupId, filter, top).concatMap((Func1)new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(ServiceResponse<Page<DeploymentExtendedInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DeploymentsInner.this.listAtManagementGroupScopeNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtManagementGroupScopeSinglePageAsync(String groupId, String filter, Integer top) {
        if (groupId == null) {
            throw new IllegalArgumentException("Parameter groupId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listAtManagementGroupScope(groupId, filter, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DeploymentsInner.this.listAtManagementGroupScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DeploymentExtendedInner>> listAtManagementGroupScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DeploymentExtendedInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteAtSubscriptionScope(String deploymentName) {
        ((ServiceResponse)this.deleteAtSubscriptionScopeWithServiceResponseAsync(deploymentName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAtSubscriptionScopeAsync(String deploymentName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteAtSubscriptionScopeWithServiceResponseAsync(deploymentName), serviceCallback);
    }

    public Observable<Void> deleteAtSubscriptionScopeAsync(String deploymentName) {
        return this.deleteAtSubscriptionScopeWithServiceResponseAsync(deploymentName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteAtSubscriptionScopeWithServiceResponseAsync(String deploymentName) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.deleteAtSubscriptionScope(deploymentName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteAtSubscriptionScope(String deploymentName) {
        ((ServiceResponse)this.beginDeleteAtSubscriptionScopeWithServiceResponseAsync(deploymentName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAtSubscriptionScopeAsync(String deploymentName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteAtSubscriptionScopeWithServiceResponseAsync(deploymentName), serviceCallback);
    }

    public Observable<Void> beginDeleteAtSubscriptionScopeAsync(String deploymentName) {
        return this.beginDeleteAtSubscriptionScopeWithServiceResponseAsync(deploymentName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteAtSubscriptionScopeWithServiceResponseAsync(String deploymentName) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDeleteAtSubscriptionScope(deploymentName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.beginDeleteAtSubscriptionScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteAtSubscriptionScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public boolean checkExistenceAtSubscriptionScope(String deploymentName) {
        return (Boolean)((ServiceResponse)this.checkExistenceAtSubscriptionScopeWithServiceResponseAsync(deploymentName).toBlocking().single()).body();
    }

    public ServiceFuture<Boolean> checkExistenceAtSubscriptionScopeAsync(String deploymentName, ServiceCallback<Boolean> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkExistenceAtSubscriptionScopeWithServiceResponseAsync(deploymentName), serviceCallback);
    }

    public Observable<Boolean> checkExistenceAtSubscriptionScopeAsync(String deploymentName) {
        return this.checkExistenceAtSubscriptionScopeWithServiceResponseAsync(deploymentName).map((Func1)new Func1<ServiceResponse<Boolean>, Boolean>(){

            public Boolean call(ServiceResponse<Boolean> response) {
                return (Boolean)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Boolean>> checkExistenceAtSubscriptionScopeWithServiceResponseAsync(String deploymentName) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.checkExistenceAtSubscriptionScope(deploymentName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<Void>, Observable<ServiceResponse<Boolean>>>(){

            public Observable<ServiceResponse<Boolean>> call(Response<Void> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.checkExistenceAtSubscriptionScopeDelegate((Response<Void>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Boolean> checkExistenceAtSubscriptionScopeDelegate(Response<Void> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).buildEmpty(response);
    }

    public DeploymentExtendedInner createOrUpdateAtSubscriptionScope(String deploymentName, DeploymentInner parameters) {
        return (DeploymentExtendedInner)((Object)((ServiceResponse)this.createOrUpdateAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<DeploymentExtendedInner> createOrUpdateAtSubscriptionScopeAsync(String deploymentName, DeploymentInner parameters, ServiceCallback<DeploymentExtendedInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters), serviceCallback);
    }

    public Observable<DeploymentExtendedInner> createOrUpdateAtSubscriptionScopeAsync(String deploymentName, DeploymentInner parameters) {
        return this.createOrUpdateAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters).map((Func1)new Func1<ServiceResponse<DeploymentExtendedInner>, DeploymentExtendedInner>(){

            public DeploymentExtendedInner call(ServiceResponse<DeploymentExtendedInner> response) {
                return (DeploymentExtendedInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DeploymentExtendedInner>> createOrUpdateAtSubscriptionScopeWithServiceResponseAsync(String deploymentName, DeploymentInner parameters) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdateAtSubscriptionScope(deploymentName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DeploymentExtendedInner>(){}.getType());
    }

    public DeploymentExtendedInner beginCreateOrUpdateAtSubscriptionScope(String deploymentName, DeploymentInner parameters) {
        return (DeploymentExtendedInner)((Object)((ServiceResponse)this.beginCreateOrUpdateAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<DeploymentExtendedInner> beginCreateOrUpdateAtSubscriptionScopeAsync(String deploymentName, DeploymentInner parameters, ServiceCallback<DeploymentExtendedInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters), serviceCallback);
    }

    public Observable<DeploymentExtendedInner> beginCreateOrUpdateAtSubscriptionScopeAsync(String deploymentName, DeploymentInner parameters) {
        return this.beginCreateOrUpdateAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters).map((Func1)new Func1<ServiceResponse<DeploymentExtendedInner>, DeploymentExtendedInner>(){

            public DeploymentExtendedInner call(ServiceResponse<DeploymentExtendedInner> response) {
                return (DeploymentExtendedInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DeploymentExtendedInner>> beginCreateOrUpdateAtSubscriptionScopeWithServiceResponseAsync(String deploymentName, DeploymentInner parameters) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.beginCreateOrUpdateAtSubscriptionScope(deploymentName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentExtendedInner>>>(){

            public Observable<ServiceResponse<DeploymentExtendedInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.beginCreateOrUpdateAtSubscriptionScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeploymentExtendedInner> beginCreateOrUpdateAtSubscriptionScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DeploymentExtendedInner>(){}.getType()).register(201, new TypeToken<DeploymentExtendedInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DeploymentExtendedInner getAtSubscriptionScope(String deploymentName) {
        return (DeploymentExtendedInner)((Object)((ServiceResponse)this.getAtSubscriptionScopeWithServiceResponseAsync(deploymentName).toBlocking().single()).body());
    }

    public ServiceFuture<DeploymentExtendedInner> getAtSubscriptionScopeAsync(String deploymentName, ServiceCallback<DeploymentExtendedInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getAtSubscriptionScopeWithServiceResponseAsync(deploymentName), serviceCallback);
    }

    public Observable<DeploymentExtendedInner> getAtSubscriptionScopeAsync(String deploymentName) {
        return this.getAtSubscriptionScopeWithServiceResponseAsync(deploymentName).map((Func1)new Func1<ServiceResponse<DeploymentExtendedInner>, DeploymentExtendedInner>(){

            public DeploymentExtendedInner call(ServiceResponse<DeploymentExtendedInner> response) {
                return (DeploymentExtendedInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DeploymentExtendedInner>> getAtSubscriptionScopeWithServiceResponseAsync(String deploymentName) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getAtSubscriptionScope(deploymentName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentExtendedInner>>>(){

            public Observable<ServiceResponse<DeploymentExtendedInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.getAtSubscriptionScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeploymentExtendedInner> getAtSubscriptionScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DeploymentExtendedInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void cancelAtSubscriptionScope(String deploymentName) {
        ((ServiceResponse)this.cancelAtSubscriptionScopeWithServiceResponseAsync(deploymentName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> cancelAtSubscriptionScopeAsync(String deploymentName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.cancelAtSubscriptionScopeWithServiceResponseAsync(deploymentName), serviceCallback);
    }

    public Observable<Void> cancelAtSubscriptionScopeAsync(String deploymentName) {
        return this.cancelAtSubscriptionScopeWithServiceResponseAsync(deploymentName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> cancelAtSubscriptionScopeWithServiceResponseAsync(String deploymentName) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.cancelAtSubscriptionScope(deploymentName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.cancelAtSubscriptionScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> cancelAtSubscriptionScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DeploymentValidateResultInner validateAtSubscriptionScope(String deploymentName, DeploymentInner parameters) {
        return (DeploymentValidateResultInner)((ServiceResponse)this.validateAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<DeploymentValidateResultInner> validateAtSubscriptionScopeAsync(String deploymentName, DeploymentInner parameters, ServiceCallback<DeploymentValidateResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.validateAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters), serviceCallback);
    }

    public Observable<DeploymentValidateResultInner> validateAtSubscriptionScopeAsync(String deploymentName, DeploymentInner parameters) {
        return this.validateAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters).map((Func1)new Func1<ServiceResponse<DeploymentValidateResultInner>, DeploymentValidateResultInner>(){

            public DeploymentValidateResultInner call(ServiceResponse<DeploymentValidateResultInner> response) {
                return (DeploymentValidateResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DeploymentValidateResultInner>> validateAtSubscriptionScopeWithServiceResponseAsync(String deploymentName, DeploymentInner parameters) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        Observable<Response<ResponseBody>> observable = this.service.validateAtSubscriptionScope(deploymentName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<DeploymentValidateResultInner>(){}.getType());
    }

    public DeploymentValidateResultInner beginValidateAtSubscriptionScope(String deploymentName, DeploymentInner parameters) {
        return (DeploymentValidateResultInner)((ServiceResponse)this.beginValidateAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<DeploymentValidateResultInner> beginValidateAtSubscriptionScopeAsync(String deploymentName, DeploymentInner parameters, ServiceCallback<DeploymentValidateResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginValidateAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters), serviceCallback);
    }

    public Observable<DeploymentValidateResultInner> beginValidateAtSubscriptionScopeAsync(String deploymentName, DeploymentInner parameters) {
        return this.beginValidateAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters).map((Func1)new Func1<ServiceResponse<DeploymentValidateResultInner>, DeploymentValidateResultInner>(){

            public DeploymentValidateResultInner call(ServiceResponse<DeploymentValidateResultInner> response) {
                return (DeploymentValidateResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DeploymentValidateResultInner>> beginValidateAtSubscriptionScopeWithServiceResponseAsync(String deploymentName, DeploymentInner parameters) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.beginValidateAtSubscriptionScope(deploymentName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentValidateResultInner>>>(){

            public Observable<ServiceResponse<DeploymentValidateResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.beginValidateAtSubscriptionScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeploymentValidateResultInner> beginValidateAtSubscriptionScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DeploymentValidateResultInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(400, new TypeToken<DeploymentValidateResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public WhatIfOperationResultInner whatIfAtSubscriptionScope(String deploymentName, DeploymentWhatIf parameters) {
        return (WhatIfOperationResultInner)((ServiceResponseWithHeaders)this.whatIfAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<WhatIfOperationResultInner> whatIfAtSubscriptionScopeAsync(String deploymentName, DeploymentWhatIf parameters, ServiceCallback<WhatIfOperationResultInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.whatIfAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters), serviceCallback);
    }

    public Observable<WhatIfOperationResultInner> whatIfAtSubscriptionScopeAsync(String deploymentName, DeploymentWhatIf parameters) {
        return this.whatIfAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters).map((Func1)new Func1<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtSubscriptionScopeHeaders>, WhatIfOperationResultInner>(){

            public WhatIfOperationResultInner call(ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtSubscriptionScopeHeaders> response) {
                return (WhatIfOperationResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtSubscriptionScopeHeaders>> whatIfAtSubscriptionScopeWithServiceResponseAsync(String deploymentName, DeploymentWhatIf parameters) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        Observable<Response<ResponseBody>> observable = this.service.whatIfAtSubscriptionScope(deploymentName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultWithHeadersAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<WhatIfOperationResultInner>(){}.getType(), DeploymentsWhatIfAtSubscriptionScopeHeaders.class);
    }

    public WhatIfOperationResultInner beginWhatIfAtSubscriptionScope(String deploymentName, DeploymentWhatIf parameters) {
        return (WhatIfOperationResultInner)((ServiceResponseWithHeaders)this.beginWhatIfAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<WhatIfOperationResultInner> beginWhatIfAtSubscriptionScopeAsync(String deploymentName, DeploymentWhatIf parameters, ServiceCallback<WhatIfOperationResultInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.beginWhatIfAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters), serviceCallback);
    }

    public Observable<WhatIfOperationResultInner> beginWhatIfAtSubscriptionScopeAsync(String deploymentName, DeploymentWhatIf parameters) {
        return this.beginWhatIfAtSubscriptionScopeWithServiceResponseAsync(deploymentName, parameters).map((Func1)new Func1<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtSubscriptionScopeHeaders>, WhatIfOperationResultInner>(){

            public WhatIfOperationResultInner call(ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtSubscriptionScopeHeaders> response) {
                return (WhatIfOperationResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtSubscriptionScopeHeaders>> beginWhatIfAtSubscriptionScopeWithServiceResponseAsync(String deploymentName, DeploymentWhatIf parameters) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.beginWhatIfAtSubscriptionScope(deploymentName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtSubscriptionScopeHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtSubscriptionScopeHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = DeploymentsInner.this.beginWhatIfAtSubscriptionScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfAtSubscriptionScopeHeaders> beginWhatIfAtSubscriptionScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<WhatIfOperationResultInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).buildWithHeaders(response, DeploymentsWhatIfAtSubscriptionScopeHeaders.class);
    }

    public DeploymentExportResultInner exportTemplateAtSubscriptionScope(String deploymentName) {
        return (DeploymentExportResultInner)((ServiceResponse)this.exportTemplateAtSubscriptionScopeWithServiceResponseAsync(deploymentName).toBlocking().single()).body();
    }

    public ServiceFuture<DeploymentExportResultInner> exportTemplateAtSubscriptionScopeAsync(String deploymentName, ServiceCallback<DeploymentExportResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.exportTemplateAtSubscriptionScopeWithServiceResponseAsync(deploymentName), serviceCallback);
    }

    public Observable<DeploymentExportResultInner> exportTemplateAtSubscriptionScopeAsync(String deploymentName) {
        return this.exportTemplateAtSubscriptionScopeWithServiceResponseAsync(deploymentName).map((Func1)new Func1<ServiceResponse<DeploymentExportResultInner>, DeploymentExportResultInner>(){

            public DeploymentExportResultInner call(ServiceResponse<DeploymentExportResultInner> response) {
                return (DeploymentExportResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DeploymentExportResultInner>> exportTemplateAtSubscriptionScopeWithServiceResponseAsync(String deploymentName) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.exportTemplateAtSubscriptionScope(deploymentName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentExportResultInner>>>(){

            public Observable<ServiceResponse<DeploymentExportResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.exportTemplateAtSubscriptionScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeploymentExportResultInner> exportTemplateAtSubscriptionScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DeploymentExportResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<DeploymentExtendedInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<DeploymentExtendedInner>((Page)response.body()){

            public Page<DeploymentExtendedInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DeploymentsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeploymentExtendedInner>> listAsync(ListOperationCallback<DeploymentExtendedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(String nextPageLink) {
                return DeploymentsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<DeploymentExtendedInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Page<DeploymentExtendedInner>>(){

            public Page<DeploymentExtendedInner> call(ServiceResponse<Page<DeploymentExtendedInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(ServiceResponse<Page<DeploymentExtendedInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DeploymentsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        Integer top = null;
        return this.service.list(this.client.subscriptionId(), filter, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DeploymentsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<DeploymentExtendedInner> list(String filter, Integer top) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(filter, top).toBlocking().single();
        return new PagedList<DeploymentExtendedInner>((Page)response.body()){

            public Page<DeploymentExtendedInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DeploymentsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeploymentExtendedInner>> listAsync(String filter, Integer top, ListOperationCallback<DeploymentExtendedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(filter, top), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(String nextPageLink) {
                return DeploymentsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DeploymentExtendedInner>> listAsync(String filter, Integer top) {
        return this.listWithServiceResponseAsync(filter, top).map((Func1)new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Page<DeploymentExtendedInner>>(){

            public Page<DeploymentExtendedInner> call(ServiceResponse<Page<DeploymentExtendedInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listWithServiceResponseAsync(String filter, Integer top) {
        return this.listSinglePageAsync(filter, top).concatMap((Func1)new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(ServiceResponse<Page<DeploymentExtendedInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DeploymentsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listSinglePageAsync(String filter, Integer top) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), filter, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DeploymentsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DeploymentExtendedInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DeploymentExtendedInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String deploymentName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, deploymentName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String deploymentName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, deploymentName), serviceCallback);
    }

    @Override
    public Observable<Void> deleteAsync(String resourceGroupName, String deploymentName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, deploymentName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String deploymentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, deploymentName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String deploymentName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, deploymentName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String deploymentName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, deploymentName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String deploymentName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, deploymentName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String deploymentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDelete(resourceGroupName, deploymentName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public boolean checkExistence(String resourceGroupName, String deploymentName) {
        return (Boolean)((ServiceResponse)this.checkExistenceWithServiceResponseAsync(resourceGroupName, deploymentName).toBlocking().single()).body();
    }

    public ServiceFuture<Boolean> checkExistenceAsync(String resourceGroupName, String deploymentName, ServiceCallback<Boolean> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkExistenceWithServiceResponseAsync(resourceGroupName, deploymentName), serviceCallback);
    }

    public Observable<Boolean> checkExistenceAsync(String resourceGroupName, String deploymentName) {
        return this.checkExistenceWithServiceResponseAsync(resourceGroupName, deploymentName).map((Func1)new Func1<ServiceResponse<Boolean>, Boolean>(){

            public Boolean call(ServiceResponse<Boolean> response) {
                return (Boolean)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Boolean>> checkExistenceWithServiceResponseAsync(String resourceGroupName, String deploymentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.checkExistence(resourceGroupName, deploymentName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<Void>, Observable<ServiceResponse<Boolean>>>(){

            public Observable<ServiceResponse<Boolean>> call(Response<Void> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.checkExistenceDelegate((Response<Void>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Boolean> checkExistenceDelegate(Response<Void> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).buildEmpty(response);
    }

    public DeploymentExtendedInner createOrUpdate(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        return (DeploymentExtendedInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, deploymentName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<DeploymentExtendedInner> createOrUpdateAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters, ServiceCallback<DeploymentExtendedInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, deploymentName, parameters), serviceCallback);
    }

    public Observable<DeploymentExtendedInner> createOrUpdateAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, deploymentName, parameters).map((Func1)new Func1<ServiceResponse<DeploymentExtendedInner>, DeploymentExtendedInner>(){

            public DeploymentExtendedInner call(ServiceResponse<DeploymentExtendedInner> response) {
                return (DeploymentExtendedInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DeploymentExtendedInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, deploymentName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DeploymentExtendedInner>(){}.getType());
    }

    public DeploymentExtendedInner beginCreateOrUpdate(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        return (DeploymentExtendedInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, deploymentName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<DeploymentExtendedInner> beginCreateOrUpdateAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters, ServiceCallback<DeploymentExtendedInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, deploymentName, parameters), serviceCallback);
    }

    public Observable<DeploymentExtendedInner> beginCreateOrUpdateAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, deploymentName, parameters).map((Func1)new Func1<ServiceResponse<DeploymentExtendedInner>, DeploymentExtendedInner>(){

            public DeploymentExtendedInner call(ServiceResponse<DeploymentExtendedInner> response) {
                return (DeploymentExtendedInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DeploymentExtendedInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.beginCreateOrUpdate(resourceGroupName, deploymentName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentExtendedInner>>>(){

            public Observable<ServiceResponse<DeploymentExtendedInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeploymentExtendedInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DeploymentExtendedInner>(){}.getType()).register(201, new TypeToken<DeploymentExtendedInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public DeploymentExtendedInner getByResourceGroup(String resourceGroupName, String deploymentName) {
        return (DeploymentExtendedInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, deploymentName).toBlocking().single()).body());
    }

    @Override
    public ServiceFuture<DeploymentExtendedInner> getByResourceGroupAsync(String resourceGroupName, String deploymentName, ServiceCallback<DeploymentExtendedInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, deploymentName), serviceCallback);
    }

    @Override
    public Observable<DeploymentExtendedInner> getByResourceGroupAsync(String resourceGroupName, String deploymentName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, deploymentName).map((Func1)new Func1<ServiceResponse<DeploymentExtendedInner>, DeploymentExtendedInner>(){

            public DeploymentExtendedInner call(ServiceResponse<DeploymentExtendedInner> response) {
                return (DeploymentExtendedInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DeploymentExtendedInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String deploymentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getByResourceGroup(resourceGroupName, deploymentName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentExtendedInner>>>(){

            public Observable<ServiceResponse<DeploymentExtendedInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeploymentExtendedInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DeploymentExtendedInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void cancel(String resourceGroupName, String deploymentName) {
        ((ServiceResponse)this.cancelWithServiceResponseAsync(resourceGroupName, deploymentName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> cancelAsync(String resourceGroupName, String deploymentName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.cancelWithServiceResponseAsync(resourceGroupName, deploymentName), serviceCallback);
    }

    public Observable<Void> cancelAsync(String resourceGroupName, String deploymentName) {
        return this.cancelWithServiceResponseAsync(resourceGroupName, deploymentName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> cancelWithServiceResponseAsync(String resourceGroupName, String deploymentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.cancel(resourceGroupName, deploymentName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.cancelDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> cancelDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DeploymentValidateResultInner validate(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        return (DeploymentValidateResultInner)((ServiceResponse)this.validateWithServiceResponseAsync(resourceGroupName, deploymentName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<DeploymentValidateResultInner> validateAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters, ServiceCallback<DeploymentValidateResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.validateWithServiceResponseAsync(resourceGroupName, deploymentName, parameters), serviceCallback);
    }

    public Observable<DeploymentValidateResultInner> validateAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        return this.validateWithServiceResponseAsync(resourceGroupName, deploymentName, parameters).map((Func1)new Func1<ServiceResponse<DeploymentValidateResultInner>, DeploymentValidateResultInner>(){

            public DeploymentValidateResultInner call(ServiceResponse<DeploymentValidateResultInner> response) {
                return (DeploymentValidateResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DeploymentValidateResultInner>> validateWithServiceResponseAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        Observable<Response<ResponseBody>> observable = this.service.validate(resourceGroupName, deploymentName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<DeploymentValidateResultInner>(){}.getType());
    }

    public DeploymentValidateResultInner beginValidate(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        return (DeploymentValidateResultInner)((ServiceResponse)this.beginValidateWithServiceResponseAsync(resourceGroupName, deploymentName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<DeploymentValidateResultInner> beginValidateAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters, ServiceCallback<DeploymentValidateResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginValidateWithServiceResponseAsync(resourceGroupName, deploymentName, parameters), serviceCallback);
    }

    public Observable<DeploymentValidateResultInner> beginValidateAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        return this.beginValidateWithServiceResponseAsync(resourceGroupName, deploymentName, parameters).map((Func1)new Func1<ServiceResponse<DeploymentValidateResultInner>, DeploymentValidateResultInner>(){

            public DeploymentValidateResultInner call(ServiceResponse<DeploymentValidateResultInner> response) {
                return (DeploymentValidateResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DeploymentValidateResultInner>> beginValidateWithServiceResponseAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.beginValidate(resourceGroupName, deploymentName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentValidateResultInner>>>(){

            public Observable<ServiceResponse<DeploymentValidateResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.beginValidateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeploymentValidateResultInner> beginValidateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DeploymentValidateResultInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(400, new TypeToken<DeploymentValidateResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public WhatIfOperationResultInner whatIf(String resourceGroupName, String deploymentName, DeploymentWhatIf parameters) {
        return (WhatIfOperationResultInner)((ServiceResponseWithHeaders)this.whatIfWithServiceResponseAsync(resourceGroupName, deploymentName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<WhatIfOperationResultInner> whatIfAsync(String resourceGroupName, String deploymentName, DeploymentWhatIf parameters, ServiceCallback<WhatIfOperationResultInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.whatIfWithServiceResponseAsync(resourceGroupName, deploymentName, parameters), serviceCallback);
    }

    public Observable<WhatIfOperationResultInner> whatIfAsync(String resourceGroupName, String deploymentName, DeploymentWhatIf parameters) {
        return this.whatIfWithServiceResponseAsync(resourceGroupName, deploymentName, parameters).map((Func1)new Func1<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfHeaders>, WhatIfOperationResultInner>(){

            public WhatIfOperationResultInner call(ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfHeaders> response) {
                return (WhatIfOperationResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfHeaders>> whatIfWithServiceResponseAsync(String resourceGroupName, String deploymentName, DeploymentWhatIf parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        Observable<Response<ResponseBody>> observable = this.service.whatIf(resourceGroupName, deploymentName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultWithHeadersAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<WhatIfOperationResultInner>(){}.getType(), DeploymentsWhatIfHeaders.class);
    }

    public WhatIfOperationResultInner beginWhatIf(String resourceGroupName, String deploymentName, DeploymentWhatIf parameters) {
        return (WhatIfOperationResultInner)((ServiceResponseWithHeaders)this.beginWhatIfWithServiceResponseAsync(resourceGroupName, deploymentName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<WhatIfOperationResultInner> beginWhatIfAsync(String resourceGroupName, String deploymentName, DeploymentWhatIf parameters, ServiceCallback<WhatIfOperationResultInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.beginWhatIfWithServiceResponseAsync(resourceGroupName, deploymentName, parameters), serviceCallback);
    }

    public Observable<WhatIfOperationResultInner> beginWhatIfAsync(String resourceGroupName, String deploymentName, DeploymentWhatIf parameters) {
        return this.beginWhatIfWithServiceResponseAsync(resourceGroupName, deploymentName, parameters).map((Func1)new Func1<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfHeaders>, WhatIfOperationResultInner>(){

            public WhatIfOperationResultInner call(ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfHeaders> response) {
                return (WhatIfOperationResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfHeaders>> beginWhatIfWithServiceResponseAsync(String resourceGroupName, String deploymentName, DeploymentWhatIf parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.beginWhatIf(resourceGroupName, deploymentName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = DeploymentsInner.this.beginWhatIfDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<WhatIfOperationResultInner, DeploymentsWhatIfHeaders> beginWhatIfDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<WhatIfOperationResultInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).buildWithHeaders(response, DeploymentsWhatIfHeaders.class);
    }

    public DeploymentExportResultInner exportTemplate(String resourceGroupName, String deploymentName) {
        return (DeploymentExportResultInner)((ServiceResponse)this.exportTemplateWithServiceResponseAsync(resourceGroupName, deploymentName).toBlocking().single()).body();
    }

    public ServiceFuture<DeploymentExportResultInner> exportTemplateAsync(String resourceGroupName, String deploymentName, ServiceCallback<DeploymentExportResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.exportTemplateWithServiceResponseAsync(resourceGroupName, deploymentName), serviceCallback);
    }

    public Observable<DeploymentExportResultInner> exportTemplateAsync(String resourceGroupName, String deploymentName) {
        return this.exportTemplateWithServiceResponseAsync(resourceGroupName, deploymentName).map((Func1)new Func1<ServiceResponse<DeploymentExportResultInner>, DeploymentExportResultInner>(){

            public DeploymentExportResultInner call(ServiceResponse<DeploymentExportResultInner> response) {
                return (DeploymentExportResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DeploymentExportResultInner>> exportTemplateWithServiceResponseAsync(String resourceGroupName, String deploymentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("Parameter deploymentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.exportTemplate(resourceGroupName, deploymentName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentExportResultInner>>>(){

            public Observable<ServiceResponse<DeploymentExportResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.exportTemplateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeploymentExportResultInner> exportTemplateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DeploymentExportResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<DeploymentExtendedInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<DeploymentExtendedInner>((Page)response.body()){

            public Page<DeploymentExtendedInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DeploymentsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeploymentExtendedInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<DeploymentExtendedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(String nextPageLink) {
                return DeploymentsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<DeploymentExtendedInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Page<DeploymentExtendedInner>>(){

            public Page<DeploymentExtendedInner> call(ServiceResponse<Page<DeploymentExtendedInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(ServiceResponse<Page<DeploymentExtendedInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DeploymentsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        Integer top = null;
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), filter, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DeploymentsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<DeploymentExtendedInner> listByResourceGroup(String resourceGroupName, String filter, Integer top) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName, filter, top).toBlocking().single();
        return new PagedList<DeploymentExtendedInner>((Page)response.body()){

            public Page<DeploymentExtendedInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DeploymentsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeploymentExtendedInner>> listByResourceGroupAsync(String resourceGroupName, String filter, Integer top, ListOperationCallback<DeploymentExtendedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName, filter, top), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(String nextPageLink) {
                return DeploymentsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DeploymentExtendedInner>> listByResourceGroupAsync(String resourceGroupName, String filter, Integer top) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName, filter, top).map((Func1)new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Page<DeploymentExtendedInner>>(){

            public Page<DeploymentExtendedInner> call(ServiceResponse<Page<DeploymentExtendedInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName, String filter, Integer top) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName, filter, top).concatMap((Func1)new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(ServiceResponse<Page<DeploymentExtendedInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DeploymentsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName, String filter, Integer top) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), filter, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DeploymentsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DeploymentExtendedInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DeploymentExtendedInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public TemplateHashResultInner calculateTemplateHash(Object template) {
        return (TemplateHashResultInner)((ServiceResponse)this.calculateTemplateHashWithServiceResponseAsync(template).toBlocking().single()).body();
    }

    public ServiceFuture<TemplateHashResultInner> calculateTemplateHashAsync(Object template, ServiceCallback<TemplateHashResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.calculateTemplateHashWithServiceResponseAsync(template), serviceCallback);
    }

    public Observable<TemplateHashResultInner> calculateTemplateHashAsync(Object template) {
        return this.calculateTemplateHashWithServiceResponseAsync(template).map((Func1)new Func1<ServiceResponse<TemplateHashResultInner>, TemplateHashResultInner>(){

            public TemplateHashResultInner call(ServiceResponse<TemplateHashResultInner> response) {
                return (TemplateHashResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<TemplateHashResultInner>> calculateTemplateHashWithServiceResponseAsync(Object template) {
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (template == null) {
            throw new IllegalArgumentException("Parameter template is required and cannot be null.");
        }
        return this.service.calculateTemplateHash(this.client.apiVersion(), template, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<TemplateHashResultInner>>>(){

            public Observable<ServiceResponse<TemplateHashResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DeploymentsInner.this.calculateTemplateHashDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<TemplateHashResultInner> calculateTemplateHashDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<TemplateHashResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DeploymentExtendedInner> listAtScopeNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listAtScopeNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DeploymentExtendedInner>((Page)response.body()){

            public Page<DeploymentExtendedInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DeploymentsInner.this.listAtScopeNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeploymentExtendedInner>> listAtScopeNextAsync(String nextPageLink, ServiceFuture<List<DeploymentExtendedInner>> serviceFuture, ListOperationCallback<DeploymentExtendedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAtScopeNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(String nextPageLink) {
                return DeploymentsInner.this.listAtScopeNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DeploymentExtendedInner>> listAtScopeNextAsync(String nextPageLink) {
        return this.listAtScopeNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Page<DeploymentExtendedInner>>(){

            public Page<DeploymentExtendedInner> call(ServiceResponse<Page<DeploymentExtendedInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtScopeNextWithServiceResponseAsync(String nextPageLink) {
        return this.listAtScopeNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(ServiceResponse<Page<DeploymentExtendedInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DeploymentsInner.this.listAtScopeNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtScopeNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listAtScopeNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DeploymentsInner.this.listAtScopeNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DeploymentExtendedInner>> listAtScopeNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DeploymentExtendedInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DeploymentExtendedInner> listAtTenantScopeNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listAtTenantScopeNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DeploymentExtendedInner>((Page)response.body()){

            public Page<DeploymentExtendedInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DeploymentsInner.this.listAtTenantScopeNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeploymentExtendedInner>> listAtTenantScopeNextAsync(String nextPageLink, ServiceFuture<List<DeploymentExtendedInner>> serviceFuture, ListOperationCallback<DeploymentExtendedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAtTenantScopeNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(String nextPageLink) {
                return DeploymentsInner.this.listAtTenantScopeNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DeploymentExtendedInner>> listAtTenantScopeNextAsync(String nextPageLink) {
        return this.listAtTenantScopeNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Page<DeploymentExtendedInner>>(){

            public Page<DeploymentExtendedInner> call(ServiceResponse<Page<DeploymentExtendedInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtTenantScopeNextWithServiceResponseAsync(String nextPageLink) {
        return this.listAtTenantScopeNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(ServiceResponse<Page<DeploymentExtendedInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DeploymentsInner.this.listAtTenantScopeNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtTenantScopeNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listAtTenantScopeNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DeploymentsInner.this.listAtTenantScopeNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DeploymentExtendedInner>> listAtTenantScopeNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DeploymentExtendedInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DeploymentExtendedInner> listAtManagementGroupScopeNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listAtManagementGroupScopeNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DeploymentExtendedInner>((Page)response.body()){

            public Page<DeploymentExtendedInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DeploymentsInner.this.listAtManagementGroupScopeNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeploymentExtendedInner>> listAtManagementGroupScopeNextAsync(String nextPageLink, ServiceFuture<List<DeploymentExtendedInner>> serviceFuture, ListOperationCallback<DeploymentExtendedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAtManagementGroupScopeNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(String nextPageLink) {
                return DeploymentsInner.this.listAtManagementGroupScopeNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DeploymentExtendedInner>> listAtManagementGroupScopeNextAsync(String nextPageLink) {
        return this.listAtManagementGroupScopeNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Page<DeploymentExtendedInner>>(){

            public Page<DeploymentExtendedInner> call(ServiceResponse<Page<DeploymentExtendedInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtManagementGroupScopeNextWithServiceResponseAsync(String nextPageLink) {
        return this.listAtManagementGroupScopeNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(ServiceResponse<Page<DeploymentExtendedInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DeploymentsInner.this.listAtManagementGroupScopeNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listAtManagementGroupScopeNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listAtManagementGroupScopeNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DeploymentsInner.this.listAtManagementGroupScopeNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DeploymentExtendedInner>> listAtManagementGroupScopeNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DeploymentExtendedInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DeploymentExtendedInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DeploymentExtendedInner>((Page)response.body()){

            public Page<DeploymentExtendedInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DeploymentsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeploymentExtendedInner>> listNextAsync(String nextPageLink, ServiceFuture<List<DeploymentExtendedInner>> serviceFuture, ListOperationCallback<DeploymentExtendedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(String nextPageLink) {
                return DeploymentsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DeploymentExtendedInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Page<DeploymentExtendedInner>>(){

            public Page<DeploymentExtendedInner> call(ServiceResponse<Page<DeploymentExtendedInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(ServiceResponse<Page<DeploymentExtendedInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DeploymentsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DeploymentsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DeploymentExtendedInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DeploymentExtendedInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DeploymentExtendedInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DeploymentExtendedInner>((Page)response.body()){

            public Page<DeploymentExtendedInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DeploymentsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DeploymentExtendedInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<DeploymentExtendedInner>> serviceFuture, ListOperationCallback<DeploymentExtendedInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(String nextPageLink) {
                return DeploymentsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DeploymentExtendedInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Page<DeploymentExtendedInner>>(){

            public Page<DeploymentExtendedInner> call(ServiceResponse<Page<DeploymentExtendedInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DeploymentExtendedInner>>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(ServiceResponse<Page<DeploymentExtendedInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DeploymentsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentExtendedInner>>>>(){

            public Observable<ServiceResponse<Page<DeploymentExtendedInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DeploymentsInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DeploymentExtendedInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DeploymentExtendedInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface DeploymentsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments deleteAtScope"})
        @HTTP(path="{scope}/providers/Microsoft.Resources/deployments/{deploymentName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteAtScope(@Path(value="scope", encoded=true) String var1, @Path(value="deploymentName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginDeleteAtScope"})
        @HTTP(path="{scope}/providers/Microsoft.Resources/deployments/{deploymentName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteAtScope(@Path(value="scope", encoded=true) String var1, @Path(value="deploymentName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments checkExistenceAtScope"})
        @HEAD(value="{scope}/providers/Microsoft.Resources/deployments/{deploymentName}")
        public Observable<Response<Void>> checkExistenceAtScope(@Path(value="scope", encoded=true) String var1, @Path(value="deploymentName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments createOrUpdateAtScope"})
        @PUT(value="{scope}/providers/Microsoft.Resources/deployments/{deploymentName}")
        public Observable<Response<ResponseBody>> createOrUpdateAtScope(@Path(value="scope", encoded=true) String var1, @Path(value="deploymentName") String var2, @Body DeploymentInner var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginCreateOrUpdateAtScope"})
        @PUT(value="{scope}/providers/Microsoft.Resources/deployments/{deploymentName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdateAtScope(@Path(value="scope", encoded=true) String var1, @Path(value="deploymentName") String var2, @Body DeploymentInner var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments getAtScope"})
        @GET(value="{scope}/providers/Microsoft.Resources/deployments/{deploymentName}")
        public Observable<Response<ResponseBody>> getAtScope(@Path(value="scope", encoded=true) String var1, @Path(value="deploymentName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments cancelAtScope"})
        @POST(value="{scope}/providers/Microsoft.Resources/deployments/{deploymentName}/cancel")
        public Observable<Response<ResponseBody>> cancelAtScope(@Path(value="scope", encoded=true) String var1, @Path(value="deploymentName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments validateAtScope"})
        @POST(value="{scope}/providers/Microsoft.Resources/deployments/{deploymentName}/validate")
        public Observable<Response<ResponseBody>> validateAtScope(@Path(value="scope", encoded=true) String var1, @Path(value="deploymentName") String var2, @Body DeploymentInner var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginValidateAtScope"})
        @POST(value="{scope}/providers/Microsoft.Resources/deployments/{deploymentName}/validate")
        public Observable<Response<ResponseBody>> beginValidateAtScope(@Path(value="scope", encoded=true) String var1, @Path(value="deploymentName") String var2, @Body DeploymentInner var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments exportTemplateAtScope"})
        @POST(value="{scope}/providers/Microsoft.Resources/deployments/{deploymentName}/exportTemplate")
        public Observable<Response<ResponseBody>> exportTemplateAtScope(@Path(value="scope", encoded=true) String var1, @Path(value="deploymentName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments listAtScope"})
        @GET(value="{scope}/providers/Microsoft.Resources/deployments/")
        public Observable<Response<ResponseBody>> listAtScope(@Path(value="scope", encoded=true) String var1, @Query(value="$filter") String var2, @Query(value="$top") Integer var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments deleteAtTenantScope"})
        @HTTP(path="providers/Microsoft.Resources/deployments/{deploymentName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteAtTenantScope(@Path(value="deploymentName") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginDeleteAtTenantScope"})
        @HTTP(path="providers/Microsoft.Resources/deployments/{deploymentName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteAtTenantScope(@Path(value="deploymentName") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments checkExistenceAtTenantScope"})
        @HEAD(value="providers/Microsoft.Resources/deployments/{deploymentName}")
        public Observable<Response<Void>> checkExistenceAtTenantScope(@Path(value="deploymentName") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments createOrUpdateAtTenantScope"})
        @PUT(value="providers/Microsoft.Resources/deployments/{deploymentName}")
        public Observable<Response<ResponseBody>> createOrUpdateAtTenantScope(@Path(value="deploymentName") String var1, @Body ScopedDeployment var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginCreateOrUpdateAtTenantScope"})
        @PUT(value="providers/Microsoft.Resources/deployments/{deploymentName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdateAtTenantScope(@Path(value="deploymentName") String var1, @Body ScopedDeployment var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments getAtTenantScope"})
        @GET(value="providers/Microsoft.Resources/deployments/{deploymentName}")
        public Observable<Response<ResponseBody>> getAtTenantScope(@Path(value="deploymentName") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments cancelAtTenantScope"})
        @POST(value="providers/Microsoft.Resources/deployments/{deploymentName}/cancel")
        public Observable<Response<ResponseBody>> cancelAtTenantScope(@Path(value="deploymentName") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments validateAtTenantScope"})
        @POST(value="providers/Microsoft.Resources/deployments/{deploymentName}/validate")
        public Observable<Response<ResponseBody>> validateAtTenantScope(@Path(value="deploymentName") String var1, @Body ScopedDeployment var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginValidateAtTenantScope"})
        @POST(value="providers/Microsoft.Resources/deployments/{deploymentName}/validate")
        public Observable<Response<ResponseBody>> beginValidateAtTenantScope(@Path(value="deploymentName") String var1, @Body ScopedDeployment var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments whatIfAtTenantScope"})
        @POST(value="providers/Microsoft.Resources/deployments/{deploymentName}/whatIf")
        public Observable<Response<ResponseBody>> whatIfAtTenantScope(@Path(value="deploymentName") String var1, @Body ScopedDeploymentWhatIf var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginWhatIfAtTenantScope"})
        @POST(value="providers/Microsoft.Resources/deployments/{deploymentName}/whatIf")
        public Observable<Response<ResponseBody>> beginWhatIfAtTenantScope(@Path(value="deploymentName") String var1, @Body ScopedDeploymentWhatIf var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments exportTemplateAtTenantScope"})
        @POST(value="providers/Microsoft.Resources/deployments/{deploymentName}/exportTemplate")
        public Observable<Response<ResponseBody>> exportTemplateAtTenantScope(@Path(value="deploymentName") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments listAtTenantScope"})
        @GET(value="providers/Microsoft.Resources/deployments/")
        public Observable<Response<ResponseBody>> listAtTenantScope(@Query(value="$filter") String var1, @Query(value="$top") Integer var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments deleteAtManagementGroupScope"})
        @HTTP(path="providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteAtManagementGroupScope(@Path(value="groupId") String var1, @Path(value="deploymentName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginDeleteAtManagementGroupScope"})
        @HTTP(path="providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteAtManagementGroupScope(@Path(value="groupId") String var1, @Path(value="deploymentName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments checkExistenceAtManagementGroupScope"})
        @HEAD(value="providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}")
        public Observable<Response<Void>> checkExistenceAtManagementGroupScope(@Path(value="groupId") String var1, @Path(value="deploymentName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments createOrUpdateAtManagementGroupScope"})
        @PUT(value="providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}")
        public Observable<Response<ResponseBody>> createOrUpdateAtManagementGroupScope(@Path(value="groupId") String var1, @Path(value="deploymentName") String var2, @Body ScopedDeployment var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginCreateOrUpdateAtManagementGroupScope"})
        @PUT(value="providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdateAtManagementGroupScope(@Path(value="groupId") String var1, @Path(value="deploymentName") String var2, @Body ScopedDeployment var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments getAtManagementGroupScope"})
        @GET(value="providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}")
        public Observable<Response<ResponseBody>> getAtManagementGroupScope(@Path(value="groupId") String var1, @Path(value="deploymentName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments cancelAtManagementGroupScope"})
        @POST(value="providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}/cancel")
        public Observable<Response<ResponseBody>> cancelAtManagementGroupScope(@Path(value="groupId") String var1, @Path(value="deploymentName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments validateAtManagementGroupScope"})
        @POST(value="providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}/validate")
        public Observable<Response<ResponseBody>> validateAtManagementGroupScope(@Path(value="groupId") String var1, @Path(value="deploymentName") String var2, @Body ScopedDeployment var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginValidateAtManagementGroupScope"})
        @POST(value="providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}/validate")
        public Observable<Response<ResponseBody>> beginValidateAtManagementGroupScope(@Path(value="groupId") String var1, @Path(value="deploymentName") String var2, @Body ScopedDeployment var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments whatIfAtManagementGroupScope"})
        @POST(value="providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}/whatIf")
        public Observable<Response<ResponseBody>> whatIfAtManagementGroupScope(@Path(value="groupId") String var1, @Path(value="deploymentName") String var2, @Body ScopedDeploymentWhatIf var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginWhatIfAtManagementGroupScope"})
        @POST(value="providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}/whatIf")
        public Observable<Response<ResponseBody>> beginWhatIfAtManagementGroupScope(@Path(value="groupId") String var1, @Path(value="deploymentName") String var2, @Body ScopedDeploymentWhatIf var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments exportTemplateAtManagementGroupScope"})
        @POST(value="providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}/exportTemplate")
        public Observable<Response<ResponseBody>> exportTemplateAtManagementGroupScope(@Path(value="groupId") String var1, @Path(value="deploymentName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments listAtManagementGroupScope"})
        @GET(value="providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/")
        public Observable<Response<ResponseBody>> listAtManagementGroupScope(@Path(value="groupId") String var1, @Query(value="$filter") String var2, @Query(value="$top") Integer var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments deleteAtSubscriptionScope"})
        @HTTP(path="subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteAtSubscriptionScope(@Path(value="deploymentName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginDeleteAtSubscriptionScope"})
        @HTTP(path="subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteAtSubscriptionScope(@Path(value="deploymentName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments checkExistenceAtSubscriptionScope"})
        @HEAD(value="subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}")
        public Observable<Response<Void>> checkExistenceAtSubscriptionScope(@Path(value="deploymentName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments createOrUpdateAtSubscriptionScope"})
        @PUT(value="subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}")
        public Observable<Response<ResponseBody>> createOrUpdateAtSubscriptionScope(@Path(value="deploymentName") String var1, @Path(value="subscriptionId") String var2, @Body DeploymentInner var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginCreateOrUpdateAtSubscriptionScope"})
        @PUT(value="subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdateAtSubscriptionScope(@Path(value="deploymentName") String var1, @Path(value="subscriptionId") String var2, @Body DeploymentInner var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments getAtSubscriptionScope"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}")
        public Observable<Response<ResponseBody>> getAtSubscriptionScope(@Path(value="deploymentName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments cancelAtSubscriptionScope"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/cancel")
        public Observable<Response<ResponseBody>> cancelAtSubscriptionScope(@Path(value="deploymentName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments validateAtSubscriptionScope"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/validate")
        public Observable<Response<ResponseBody>> validateAtSubscriptionScope(@Path(value="deploymentName") String var1, @Path(value="subscriptionId") String var2, @Body DeploymentInner var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginValidateAtSubscriptionScope"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/validate")
        public Observable<Response<ResponseBody>> beginValidateAtSubscriptionScope(@Path(value="deploymentName") String var1, @Path(value="subscriptionId") String var2, @Body DeploymentInner var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments whatIfAtSubscriptionScope"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/whatIf")
        public Observable<Response<ResponseBody>> whatIfAtSubscriptionScope(@Path(value="deploymentName") String var1, @Path(value="subscriptionId") String var2, @Body DeploymentWhatIf var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginWhatIfAtSubscriptionScope"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/whatIf")
        public Observable<Response<ResponseBody>> beginWhatIfAtSubscriptionScope(@Path(value="deploymentName") String var1, @Path(value="subscriptionId") String var2, @Body DeploymentWhatIf var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments exportTemplateAtSubscriptionScope"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/exportTemplate")
        public Observable<Response<ResponseBody>> exportTemplateAtSubscriptionScope(@Path(value="deploymentName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="$filter") String var2, @Query(value="$top") Integer var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="deploymentName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="deploymentName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments checkExistence"})
        @HEAD(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}")
        public Observable<Response<Void>> checkExistence(@Path(value="resourceGroupName") String var1, @Path(value="deploymentName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="deploymentName") String var2, @Path(value="subscriptionId") String var3, @Body DeploymentInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="deploymentName") String var2, @Path(value="subscriptionId") String var3, @Body DeploymentInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="deploymentName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments cancel"})
        @POST(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/cancel")
        public Observable<Response<ResponseBody>> cancel(@Path(value="resourceGroupName") String var1, @Path(value="deploymentName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments validate"})
        @POST(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/validate")
        public Observable<Response<ResponseBody>> validate(@Path(value="resourceGroupName") String var1, @Path(value="deploymentName") String var2, @Path(value="subscriptionId") String var3, @Body DeploymentInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginValidate"})
        @POST(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/validate")
        public Observable<Response<ResponseBody>> beginValidate(@Path(value="resourceGroupName") String var1, @Path(value="deploymentName") String var2, @Path(value="subscriptionId") String var3, @Body DeploymentInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments whatIf"})
        @POST(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/whatIf")
        public Observable<Response<ResponseBody>> whatIf(@Path(value="resourceGroupName") String var1, @Path(value="deploymentName") String var2, @Path(value="subscriptionId") String var3, @Body DeploymentWhatIf var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments beginWhatIf"})
        @POST(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/whatIf")
        public Observable<Response<ResponseBody>> beginWhatIf(@Path(value="resourceGroupName") String var1, @Path(value="deploymentName") String var2, @Path(value="subscriptionId") String var3, @Body DeploymentWhatIf var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments exportTemplate"})
        @POST(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/exportTemplate")
        public Observable<Response<ResponseBody>> exportTemplate(@Path(value="resourceGroupName") String var1, @Path(value="deploymentName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="$filter") String var3, @Query(value="$top") Integer var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments calculateTemplateHash"})
        @POST(value="providers/Microsoft.Resources/calculateTemplateHash")
        public Observable<Response<ResponseBody>> calculateTemplateHash(@Query(value="api-version") String var1, @Body Object var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments listAtScopeNext"})
        @GET
        public Observable<Response<ResponseBody>> listAtScopeNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments listAtTenantScopeNext"})
        @GET
        public Observable<Response<ResponseBody>> listAtTenantScopeNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments listAtManagementGroupScopeNext"})
        @GET
        public Observable<Response<ResponseBody>> listAtManagementGroupScopeNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Deployments listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

