/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.resources;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Specifies whether template expressions are evaluated within the scope of the
 * parent template or nested template.
 */
public class ExpressionEvaluationOptions {
    /**
     * The scope to be used for evaluation of parameters, variables and
     * functions in a nested template. Possible values include: 'NotSpecified',
     * 'Outer', 'Inner'.
     */
    @JsonProperty(value = "scope")
    private ExpressionEvaluationOptionsScopeType scope;

    /**
     * Get the scope to be used for evaluation of parameters, variables and functions in a nested template. Possible values include: 'NotSpecified', 'Outer', 'Inner'.
     *
     * @return the scope value
     */
    public ExpressionEvaluationOptionsScopeType scope() {
        return this.scope;
    }

    /**
     * Set the scope to be used for evaluation of parameters, variables and functions in a nested template. Possible values include: 'NotSpecified', 'Outer', 'Inner'.
     *
     * @param scope the scope value to set
     * @return the ExpressionEvaluationOptions object itself.
     */
    public ExpressionEvaluationOptions withScope(ExpressionEvaluationOptionsScopeType scope) {
        this.scope = scope;
        return this;
    }

}
