/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.resources;

import java.util.Collection;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.microsoft.rest.ExpandableStringEnum;

/**
 * Defines values for RegionCategory.
 */
public final class RegionCategory extends ExpandableStringEnum<RegionCategory> {
    /** Static value Recommended for RegionCategory. */
    public static final RegionCategory RECOMMENDED = fromString("Recommended");

    /** Static value Other for RegionCategory. */
    public static final RegionCategory OTHER = fromString("Other");

    /**
     * Creates or finds a RegionCategory from its string representation.
     * @param name a name to look for
     * @return the corresponding RegionCategory
     */
    @JsonCreator
    public static RegionCategory fromString(String name) {
        return fromString(name, RegionCategory.class);
    }

    /**
     * @return known RegionCategory values
     */
    public static Collection<RegionCategory> values() {
        return values(RegionCategory.class);
    }
}
