/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.resources.implementation;

import com.microsoft.azure.management.resources.ResourceNameStatus;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Resource Name valid if not a reserved word, does not contain a reserved word
 * and does not start with a reserved word.
 */
public class CheckResourceNameResultInner {
    /**
     * Name of Resource.
     */
    @JsonProperty(value = "name")
    private String name;

    /**
     * Type of Resource.
     */
    @JsonProperty(value = "type")
    private String type;

    /**
     * Is the resource name Allowed or Reserved. Possible values include:
     * 'Allowed', 'Reserved'.
     */
    @JsonProperty(value = "status")
    private ResourceNameStatus status;

    /**
     * Get name of Resource.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Set name of Resource.
     *
     * @param name the name value to set
     * @return the CheckResourceNameResultInner object itself.
     */
    public CheckResourceNameResultInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get type of Resource.
     *
     * @return the type value
     */
    public String type() {
        return this.type;
    }

    /**
     * Set type of Resource.
     *
     * @param type the type value to set
     * @return the CheckResourceNameResultInner object itself.
     */
    public CheckResourceNameResultInner withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get is the resource name Allowed or Reserved. Possible values include: 'Allowed', 'Reserved'.
     *
     * @return the status value
     */
    public ResourceNameStatus status() {
        return this.status;
    }

    /**
     * Set is the resource name Allowed or Reserved. Possible values include: 'Allowed', 'Reserved'.
     *
     * @param status the status value to set
     * @return the CheckResourceNameResultInner object itself.
     */
    public CheckResourceNameResultInner withStatus(ResourceNameStatus status) {
        this.status = status;
        return this;
    }

}
