/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.resources.implementation;

import com.microsoft.azure.management.resources.LocationMetadata;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Location information.
 */
public class LocationInner {
    /**
     * The fully qualified ID of the location. For example,
     * /subscriptions/00000000-0000-0000-0000-000000000000/locations/westus.
     */
    @JsonProperty(value = "id", access = JsonProperty.Access.WRITE_ONLY)
    private String id;

    /**
     * The subscription ID.
     */
    @JsonProperty(value = "subscriptionId", access = JsonProperty.Access.WRITE_ONLY)
    private String subscriptionId;

    /**
     * The location name.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /**
     * The display name of the location.
     */
    @JsonProperty(value = "displayName", access = JsonProperty.Access.WRITE_ONLY)
    private String displayName;

    /**
     * The display name of the location and its region.
     */
    @JsonProperty(value = "regionalDisplayName", access = JsonProperty.Access.WRITE_ONLY)
    private String regionalDisplayName;

    /**
     * Metadata of the location, such as lat/long, paired region, and others.
     */
    @JsonProperty(value = "metadata")
    private LocationMetadata metadata;

    /**
     * Get the fully qualified ID of the location. For example, /subscriptions/00000000-0000-0000-0000-000000000000/locations/westus.
     *
     * @return the id value
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the subscription ID.
     *
     * @return the subscriptionId value
     */
    public String subscriptionId() {
        return this.subscriptionId;
    }

    /**
     * Get the location name.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the display name of the location.
     *
     * @return the displayName value
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Get the display name of the location and its region.
     *
     * @return the regionalDisplayName value
     */
    public String regionalDisplayName() {
        return this.regionalDisplayName;
    }

    /**
     * Get metadata of the location, such as lat/long, paired region, and others.
     *
     * @return the metadata value
     */
    public LocationMetadata metadata() {
        return this.metadata;
    }

    /**
     * Set metadata of the location, such as lat/long, paired region, and others.
     *
     * @param metadata the metadata value to set
     * @return the LocationInner object itself.
     */
    public LocationInner withMetadata(LocationMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

}
