/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.fluentcore.arm.implementation;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.AzureResponseBuilder;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.resources.fluentcore.arm.AzureConfigurable;
import com.microsoft.azure.management.resources.fluentcore.utils.AuxiliaryCredentialsInterceptor;
import com.microsoft.azure.management.resources.fluentcore.utils.ProviderRegistrationInterceptor;
import com.microsoft.azure.management.resources.fluentcore.utils.ResourceManagerThrottlingInterceptor;
import com.microsoft.azure.serializer.AzureJacksonAdapter;
import com.microsoft.rest.LogLevel;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.protocol.Environment;
import com.microsoft.rest.protocol.ResponseBuilder;
import com.microsoft.rest.protocol.SerializerAdapter;
import java.net.Proxy;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.Protocol;

public class AzureConfigurableImpl<T extends AzureConfigurable<T>>
implements AzureConfigurable<T> {
    protected RestClient.Builder restClientBuilder = new RestClient.Builder().withSerializerAdapter((SerializerAdapter)new AzureJacksonAdapter()).withResponseBuilderFactory((ResponseBuilder.Factory)new AzureResponseBuilder.Factory());

    protected AzureConfigurableImpl() {
    }

    @Override
    public T withLogLevel(LogLevel level) {
        this.restClientBuilder = this.restClientBuilder.withLogLevel(level);
        return (T)this;
    }

    @Override
    public T withInterceptor(Interceptor interceptor) {
        this.restClientBuilder = this.restClientBuilder.withInterceptor(interceptor);
        return (T)this;
    }

    @Override
    public T withAuxiliaryCredentials(AzureTokenCredentials ... tokens) {
        if (tokens != null) {
            if (tokens.length > 3) {
                throw new IllegalArgumentException("Only can hold up to three auxiliary tokens.");
            }
            AuxiliaryCredentialsInterceptor interceptor = new AuxiliaryCredentialsInterceptor(tokens);
            this.restClientBuilder = this.restClientBuilder.withInterceptor((Interceptor)interceptor);
        }
        return (T)this;
    }

    @Override
    public T withUserAgent(String userAgent) {
        this.restClientBuilder = this.restClientBuilder.withUserAgent(userAgent);
        return (T)this;
    }

    @Override
    public T withReadTimeout(long timeout, TimeUnit unit) {
        this.restClientBuilder = this.restClientBuilder.withReadTimeout(timeout, unit);
        return (T)this;
    }

    @Override
    public T withConnectionTimeout(long timeout, TimeUnit unit) {
        this.restClientBuilder = this.restClientBuilder.withConnectionTimeout(timeout, unit);
        return (T)this;
    }

    @Override
    public T withMaxIdleConnections(int maxIdleConnections) {
        this.restClientBuilder = this.restClientBuilder.withMaxIdleConnections(maxIdleConnections);
        return (T)this;
    }

    @Override
    public T withConnectionPool(ConnectionPool connectionPool) {
        this.restClientBuilder = this.restClientBuilder.withConnectionPool(connectionPool);
        return (T)this;
    }

    @Override
    public T useHttpClientThreadPool(boolean useHttpClientThreadPool) {
        this.restClientBuilder = this.restClientBuilder.useHttpClientThreadPool(useHttpClientThreadPool);
        return (T)this;
    }

    @Override
    public T withDispatcher(Dispatcher dispatcher) {
        this.restClientBuilder = this.restClientBuilder.withDispatcher(dispatcher);
        return (T)this;
    }

    @Override
    public T withCallbackExecutor(Executor executor) {
        this.restClientBuilder = this.restClientBuilder.withCallbackExecutor(executor);
        return (T)this;
    }

    @Override
    public T withProxy(Proxy proxy) {
        this.restClientBuilder = this.restClientBuilder.withProxy(proxy);
        return (T)this;
    }

    @Override
    public T withProxyAuthenticator(Authenticator proxyAuthenticator) {
        this.restClientBuilder = this.restClientBuilder.withProxyAuthenticator(proxyAuthenticator);
        return (T)this;
    }

    @Override
    public T withProtocols(List<Protocol> protocols) {
        this.restClientBuilder.withProtocols(protocols);
        return (T)this;
    }

    protected RestClient buildRestClient(AzureTokenCredentials credentials, AzureEnvironment.Endpoint endpoint) {
        RestClient client = this.restClientBuilder.withBaseUrl((Environment)credentials.environment(), (Environment.Endpoint)endpoint).withCredentials((ServiceClientCredentials)credentials).withInterceptor((Interceptor)new ProviderRegistrationInterceptor(credentials)).withInterceptor((Interceptor)new ResourceManagerThrottlingInterceptor()).build();
        if (client.httpClient().proxy() != null) {
            credentials.withProxy(client.httpClient().proxy());
        }
        return client;
    }

    protected RestClient buildRestClient(AzureTokenCredentials credentials) {
        return this.buildRestClient(credentials, AzureEnvironment.Endpoint.RESOURCE_MANAGER);
    }
}

