/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.management.resources.ErrorResponseException;
import com.microsoft.azure.management.resources.ResourceName;
import com.microsoft.azure.management.resources.implementation.CheckResourceNameResultInner;
import com.microsoft.azure.management.resources.implementation.SubscriptionsInner;
import com.microsoft.azure.management.resources.implementation.TenantsInner;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.http.Body;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class SubscriptionClientImpl
extends AzureServiceClient {
    private SubscriptionClientService service;
    private AzureClient azureClient;
    private String apiVersion;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private SubscriptionsInner subscriptions;
    private TenantsInner tenants;

    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    public String apiVersion() {
        return this.apiVersion;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public SubscriptionClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    public SubscriptionClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    public SubscriptionClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    public SubscriptionsInner subscriptions() {
        return this.subscriptions;
    }

    public TenantsInner tenants() {
        return this.tenants;
    }

    public SubscriptionClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    public SubscriptionClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public SubscriptionClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.apiVersion = "2020-01-01";
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.subscriptions = new SubscriptionsInner(this.restClient().retrofit(), this);
        this.tenants = new TenantsInner(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
        this.initializeService();
    }

    public String userAgent() {
        return String.format("%s (%s, %s)", super.userAgent(), "SubscriptionClient", "2020-01-01");
    }

    private void initializeService() {
        this.service = (SubscriptionClientService)this.restClient().retrofit().create(SubscriptionClientService.class);
    }

    public CheckResourceNameResultInner checkResourceName() {
        return (CheckResourceNameResultInner)((ServiceResponse)this.checkResourceNameWithServiceResponseAsync().toBlocking().single()).body();
    }

    public ServiceFuture<CheckResourceNameResultInner> checkResourceNameAsync(ServiceCallback<CheckResourceNameResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkResourceNameWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<CheckResourceNameResultInner> checkResourceNameAsync() {
        return this.checkResourceNameWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<CheckResourceNameResultInner>, CheckResourceNameResultInner>(){

            public CheckResourceNameResultInner call(ServiceResponse<CheckResourceNameResultInner> response) {
                return (CheckResourceNameResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<CheckResourceNameResultInner>> checkResourceNameWithServiceResponseAsync() {
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        ResourceName resourceNameDefinition = null;
        return this.service.checkResourceName(resourceNameDefinition, this.apiVersion(), this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CheckResourceNameResultInner>>>(){

            public Observable<ServiceResponse<CheckResourceNameResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SubscriptionClientImpl.this.checkResourceNameDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public CheckResourceNameResultInner checkResourceName(ResourceName resourceNameDefinition) {
        return (CheckResourceNameResultInner)((ServiceResponse)this.checkResourceNameWithServiceResponseAsync(resourceNameDefinition).toBlocking().single()).body();
    }

    public ServiceFuture<CheckResourceNameResultInner> checkResourceNameAsync(ResourceName resourceNameDefinition, ServiceCallback<CheckResourceNameResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkResourceNameWithServiceResponseAsync(resourceNameDefinition), serviceCallback);
    }

    public Observable<CheckResourceNameResultInner> checkResourceNameAsync(ResourceName resourceNameDefinition) {
        return this.checkResourceNameWithServiceResponseAsync(resourceNameDefinition).map((Func1)new Func1<ServiceResponse<CheckResourceNameResultInner>, CheckResourceNameResultInner>(){

            public CheckResourceNameResultInner call(ServiceResponse<CheckResourceNameResultInner> response) {
                return (CheckResourceNameResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<CheckResourceNameResultInner>> checkResourceNameWithServiceResponseAsync(ResourceName resourceNameDefinition) {
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)resourceNameDefinition);
        return this.service.checkResourceName(resourceNameDefinition, this.apiVersion(), this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CheckResourceNameResultInner>>>(){

            public Observable<ServiceResponse<CheckResourceNameResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SubscriptionClientImpl.this.checkResourceNameDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CheckResourceNameResultInner> checkResourceNameDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<CheckResourceNameResultInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface SubscriptionClientService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.SubscriptionClient checkResourceName"})
        @POST(value="providers/Microsoft.Resources/checkResourceName")
        public Observable<Response<ResponseBody>> checkResourceName(@Body ResourceName var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);
    }
}

