/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.Tags;
import com.microsoft.azure.management.resources.TagsPatchResource;
import com.microsoft.azure.management.resources.implementation.PageImpl;
import com.microsoft.azure.management.resources.implementation.ResourceManagementClientImpl;
import com.microsoft.azure.management.resources.implementation.TagDetailsInner;
import com.microsoft.azure.management.resources.implementation.TagValueInner;
import com.microsoft.azure.management.resources.implementation.TagsResourceInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class TagOperationsInner {
    private TagOperationsService service;
    private ResourceManagementClientImpl client;

    public TagOperationsInner(Retrofit retrofit, ResourceManagementClientImpl client) {
        this.service = (TagOperationsService)retrofit.create(TagOperationsService.class);
        this.client = client;
    }

    public void deleteValue(String tagName, String tagValue) {
        ((ServiceResponse)this.deleteValueWithServiceResponseAsync(tagName, tagValue).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteValueAsync(String tagName, String tagValue, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteValueWithServiceResponseAsync(tagName, tagValue), serviceCallback);
    }

    public Observable<Void> deleteValueAsync(String tagName, String tagValue) {
        return this.deleteValueWithServiceResponseAsync(tagName, tagValue).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteValueWithServiceResponseAsync(String tagName, String tagValue) {
        if (tagName == null) {
            throw new IllegalArgumentException("Parameter tagName is required and cannot be null.");
        }
        if (tagValue == null) {
            throw new IllegalArgumentException("Parameter tagValue is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.deleteValue(tagName, tagValue, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TagOperationsInner.this.deleteValueDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteValueDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public TagValueInner createOrUpdateValue(String tagName, String tagValue) {
        return (TagValueInner)((ServiceResponse)this.createOrUpdateValueWithServiceResponseAsync(tagName, tagValue).toBlocking().single()).body();
    }

    public ServiceFuture<TagValueInner> createOrUpdateValueAsync(String tagName, String tagValue, ServiceCallback<TagValueInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateValueWithServiceResponseAsync(tagName, tagValue), serviceCallback);
    }

    public Observable<TagValueInner> createOrUpdateValueAsync(String tagName, String tagValue) {
        return this.createOrUpdateValueWithServiceResponseAsync(tagName, tagValue).map((Func1)new Func1<ServiceResponse<TagValueInner>, TagValueInner>(){

            public TagValueInner call(ServiceResponse<TagValueInner> response) {
                return (TagValueInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<TagValueInner>> createOrUpdateValueWithServiceResponseAsync(String tagName, String tagValue) {
        if (tagName == null) {
            throw new IllegalArgumentException("Parameter tagName is required and cannot be null.");
        }
        if (tagValue == null) {
            throw new IllegalArgumentException("Parameter tagValue is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.createOrUpdateValue(tagName, tagValue, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<TagValueInner>>>(){

            public Observable<ServiceResponse<TagValueInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TagOperationsInner.this.createOrUpdateValueDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<TagValueInner> createOrUpdateValueDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<TagValueInner>(){}.getType()).register(201, new TypeToken<TagValueInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public TagDetailsInner createOrUpdate(String tagName) {
        return (TagDetailsInner)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(tagName).toBlocking().single()).body();
    }

    public ServiceFuture<TagDetailsInner> createOrUpdateAsync(String tagName, ServiceCallback<TagDetailsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(tagName), serviceCallback);
    }

    public Observable<TagDetailsInner> createOrUpdateAsync(String tagName) {
        return this.createOrUpdateWithServiceResponseAsync(tagName).map((Func1)new Func1<ServiceResponse<TagDetailsInner>, TagDetailsInner>(){

            public TagDetailsInner call(ServiceResponse<TagDetailsInner> response) {
                return (TagDetailsInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<TagDetailsInner>> createOrUpdateWithServiceResponseAsync(String tagName) {
        if (tagName == null) {
            throw new IllegalArgumentException("Parameter tagName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.createOrUpdate(tagName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<TagDetailsInner>>>(){

            public Observable<ServiceResponse<TagDetailsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TagOperationsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<TagDetailsInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<TagDetailsInner>(){}.getType()).register(201, new TypeToken<TagDetailsInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String tagName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(tagName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String tagName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(tagName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String tagName) {
        return this.deleteWithServiceResponseAsync(tagName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String tagName) {
        if (tagName == null) {
            throw new IllegalArgumentException("Parameter tagName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(tagName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TagOperationsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<TagDetailsInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<TagDetailsInner>((Page)response.body()){

            public Page<TagDetailsInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)TagOperationsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<TagDetailsInner>> listAsync(ListOperationCallback<TagDetailsInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<TagDetailsInner>>>>(){

            public Observable<ServiceResponse<Page<TagDetailsInner>>> call(String nextPageLink) {
                return TagOperationsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<TagDetailsInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<TagDetailsInner>>, Page<TagDetailsInner>>(){

            public Page<TagDetailsInner> call(ServiceResponse<Page<TagDetailsInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<TagDetailsInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<TagDetailsInner>>, Observable<ServiceResponse<Page<TagDetailsInner>>>>(){

            public Observable<ServiceResponse<Page<TagDetailsInner>>> call(ServiceResponse<Page<TagDetailsInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(TagOperationsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<TagDetailsInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<TagDetailsInner>>>>(){

            public Observable<ServiceResponse<Page<TagDetailsInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = TagOperationsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<TagDetailsInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<TagDetailsInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public TagsResourceInner createOrUpdateAtScope(String scope, Tags properties) {
        return (TagsResourceInner)((Object)((ServiceResponse)this.createOrUpdateAtScopeWithServiceResponseAsync(scope, properties).toBlocking().single()).body());
    }

    public ServiceFuture<TagsResourceInner> createOrUpdateAtScopeAsync(String scope, Tags properties, ServiceCallback<TagsResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateAtScopeWithServiceResponseAsync(scope, properties), serviceCallback);
    }

    public Observable<TagsResourceInner> createOrUpdateAtScopeAsync(String scope, Tags properties) {
        return this.createOrUpdateAtScopeWithServiceResponseAsync(scope, properties).map((Func1)new Func1<ServiceResponse<TagsResourceInner>, TagsResourceInner>(){

            public TagsResourceInner call(ServiceResponse<TagsResourceInner> response) {
                return (TagsResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<TagsResourceInner>> createOrUpdateAtScopeWithServiceResponseAsync(String scope, Tags properties) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (properties == null) {
            throw new IllegalArgumentException("Parameter properties is required and cannot be null.");
        }
        Validator.validate((Object)properties);
        TagsResourceInner parameters = new TagsResourceInner();
        parameters.withProperties(properties);
        return this.service.createOrUpdateAtScope(scope, this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<TagsResourceInner>>>(){

            public Observable<ServiceResponse<TagsResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TagOperationsInner.this.createOrUpdateAtScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<TagsResourceInner> createOrUpdateAtScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<TagsResourceInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public TagsResourceInner updateAtScope(String scope, TagsPatchResource parameters) {
        return (TagsResourceInner)((Object)((ServiceResponse)this.updateAtScopeWithServiceResponseAsync(scope, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<TagsResourceInner> updateAtScopeAsync(String scope, TagsPatchResource parameters, ServiceCallback<TagsResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateAtScopeWithServiceResponseAsync(scope, parameters), serviceCallback);
    }

    public Observable<TagsResourceInner> updateAtScopeAsync(String scope, TagsPatchResource parameters) {
        return this.updateAtScopeWithServiceResponseAsync(scope, parameters).map((Func1)new Func1<ServiceResponse<TagsResourceInner>, TagsResourceInner>(){

            public TagsResourceInner call(ServiceResponse<TagsResourceInner> response) {
                return (TagsResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<TagsResourceInner>> updateAtScopeWithServiceResponseAsync(String scope, TagsPatchResource parameters) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.updateAtScope(scope, this.client.apiVersion(), parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<TagsResourceInner>>>(){

            public Observable<ServiceResponse<TagsResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TagOperationsInner.this.updateAtScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<TagsResourceInner> updateAtScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<TagsResourceInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public TagsResourceInner getAtScope(String scope) {
        return (TagsResourceInner)((Object)((ServiceResponse)this.getAtScopeWithServiceResponseAsync(scope).toBlocking().single()).body());
    }

    public ServiceFuture<TagsResourceInner> getAtScopeAsync(String scope, ServiceCallback<TagsResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getAtScopeWithServiceResponseAsync(scope), serviceCallback);
    }

    public Observable<TagsResourceInner> getAtScopeAsync(String scope) {
        return this.getAtScopeWithServiceResponseAsync(scope).map((Func1)new Func1<ServiceResponse<TagsResourceInner>, TagsResourceInner>(){

            public TagsResourceInner call(ServiceResponse<TagsResourceInner> response) {
                return (TagsResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<TagsResourceInner>> getAtScopeWithServiceResponseAsync(String scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getAtScope(scope, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<TagsResourceInner>>>(){

            public Observable<ServiceResponse<TagsResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TagOperationsInner.this.getAtScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<TagsResourceInner> getAtScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<TagsResourceInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteAtScope(String scope) {
        ((ServiceResponse)this.deleteAtScopeWithServiceResponseAsync(scope).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAtScopeAsync(String scope, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteAtScopeWithServiceResponseAsync(scope), serviceCallback);
    }

    public Observable<Void> deleteAtScopeAsync(String scope) {
        return this.deleteAtScopeWithServiceResponseAsync(scope).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteAtScopeWithServiceResponseAsync(String scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.deleteAtScope(scope, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TagOperationsInner.this.deleteAtScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteAtScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<TagDetailsInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<TagDetailsInner>((Page)response.body()){

            public Page<TagDetailsInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)TagOperationsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<TagDetailsInner>> listNextAsync(String nextPageLink, ServiceFuture<List<TagDetailsInner>> serviceFuture, ListOperationCallback<TagDetailsInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<TagDetailsInner>>>>(){

            public Observable<ServiceResponse<Page<TagDetailsInner>>> call(String nextPageLink) {
                return TagOperationsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<TagDetailsInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<TagDetailsInner>>, Page<TagDetailsInner>>(){

            public Page<TagDetailsInner> call(ServiceResponse<Page<TagDetailsInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<TagDetailsInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<TagDetailsInner>>, Observable<ServiceResponse<Page<TagDetailsInner>>>>(){

            public Observable<ServiceResponse<Page<TagDetailsInner>>> call(ServiceResponse<Page<TagDetailsInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(TagOperationsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<TagDetailsInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<TagDetailsInner>>>>(){

            public Observable<ServiceResponse<Page<TagDetailsInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = TagOperationsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<TagDetailsInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<TagDetailsInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface TagOperationsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.TagOperations deleteValue"})
        @HTTP(path="subscriptions/{subscriptionId}/tagNames/{tagName}/tagValues/{tagValue}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteValue(@Path(value="tagName") String var1, @Path(value="tagValue") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.TagOperations createOrUpdateValue"})
        @PUT(value="subscriptions/{subscriptionId}/tagNames/{tagName}/tagValues/{tagValue}")
        public Observable<Response<ResponseBody>> createOrUpdateValue(@Path(value="tagName") String var1, @Path(value="tagValue") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.TagOperations createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/tagNames/{tagName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="tagName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.TagOperations delete"})
        @HTTP(path="subscriptions/{subscriptionId}/tagNames/{tagName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="tagName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.TagOperations list"})
        @GET(value="subscriptions/{subscriptionId}/tagNames")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.TagOperations createOrUpdateAtScope"})
        @PUT(value="{scope}/providers/Microsoft.Resources/tags/default")
        public Observable<Response<ResponseBody>> createOrUpdateAtScope(@Path(value="scope", encoded=true) String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body TagsResourceInner var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.TagOperations updateAtScope"})
        @PATCH(value="{scope}/providers/Microsoft.Resources/tags/default")
        public Observable<Response<ResponseBody>> updateAtScope(@Path(value="scope", encoded=true) String var1, @Query(value="api-version") String var2, @Body TagsPatchResource var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.TagOperations getAtScope"})
        @GET(value="{scope}/providers/Microsoft.Resources/tags/default")
        public Observable<Response<ResponseBody>> getAtScope(@Path(value="scope", encoded=true) String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.TagOperations deleteAtScope"})
        @HTTP(path="{scope}/providers/Microsoft.Resources/tags/default", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteAtScope(@Path(value="scope", encoded=true) String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.TagOperations listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

