/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.implementation;

import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.management.resources.implementation.DeploymentOperationsInner;
import com.microsoft.azure.management.resources.implementation.DeploymentsInner;
import com.microsoft.azure.management.resources.implementation.OperationsInner;
import com.microsoft.azure.management.resources.implementation.ProvidersInner;
import com.microsoft.azure.management.resources.implementation.ResourceGroupsInner;
import com.microsoft.azure.management.resources.implementation.ResourcesInner;
import com.microsoft.azure.management.resources.implementation.TagOperationsInner;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;

public class ResourceManagementClientImpl
extends AzureServiceClient {
    private AzureClient azureClient;
    private String subscriptionId;
    private String apiVersion;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private OperationsInner operations;
    private DeploymentsInner deployments;
    private ProvidersInner providers;
    private ResourcesInner resources;
    private ResourceGroupsInner resourceGroups;
    private TagOperationsInner tagOperations;
    private DeploymentOperationsInner deploymentOperations;

    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public ResourceManagementClientImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String apiVersion() {
        return this.apiVersion;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public ResourceManagementClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    public ResourceManagementClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    public ResourceManagementClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    public OperationsInner operations() {
        return this.operations;
    }

    public DeploymentsInner deployments() {
        return this.deployments;
    }

    public ProvidersInner providers() {
        return this.providers;
    }

    public ResourcesInner resources() {
        return this.resources;
    }

    public ResourceGroupsInner resourceGroups() {
        return this.resourceGroups;
    }

    public TagOperationsInner tagOperations() {
        return this.tagOperations;
    }

    public DeploymentOperationsInner deploymentOperations() {
        return this.deploymentOperations;
    }

    public ResourceManagementClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    public ResourceManagementClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public ResourceManagementClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.apiVersion = "2020-06-01";
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.operations = new OperationsInner(this.restClient().retrofit(), this);
        this.deployments = new DeploymentsInner(this.restClient().retrofit(), this);
        this.providers = new ProvidersInner(this.restClient().retrofit(), this);
        this.resources = new ResourcesInner(this.restClient().retrofit(), this);
        this.resourceGroups = new ResourceGroupsInner(this.restClient().retrofit(), this);
        this.tagOperations = new TagOperationsInner(this.restClient().retrofit(), this);
        this.deploymentOperations = new DeploymentOperationsInner(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
    }

    public String userAgent() {
        return String.format("%s (%s, %s)", super.userAgent(), "ResourceManagementClient", "2020-06-01");
    }
}

