/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.resources;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The type of the pattern for an alias path.
 */
public class AliasPattern {
    /**
     * The alias pattern phrase.
     */
    @JsonProperty(value = "phrase")
    private String phrase;

    /**
     * The alias pattern variable.
     */
    @JsonProperty(value = "variable")
    private String variable;

    /**
     * The type of alias pattern. Possible values include: 'NotSpecified',
     * 'Extract'.
     */
    @JsonProperty(value = "type")
    private AliasPatternType type;

    /**
     * Get the alias pattern phrase.
     *
     * @return the phrase value
     */
    public String phrase() {
        return this.phrase;
    }

    /**
     * Set the alias pattern phrase.
     *
     * @param phrase the phrase value to set
     * @return the AliasPattern object itself.
     */
    public AliasPattern withPhrase(String phrase) {
        this.phrase = phrase;
        return this;
    }

    /**
     * Get the alias pattern variable.
     *
     * @return the variable value
     */
    public String variable() {
        return this.variable;
    }

    /**
     * Set the alias pattern variable.
     *
     * @param variable the variable value to set
     * @return the AliasPattern object itself.
     */
    public AliasPattern withVariable(String variable) {
        this.variable = variable;
        return this;
    }

    /**
     * Get the type of alias pattern. Possible values include: 'NotSpecified', 'Extract'.
     *
     * @return the type value
     */
    public AliasPatternType type() {
        return this.type;
    }

    /**
     * Set the type of alias pattern. Possible values include: 'NotSpecified', 'Extract'.
     *
     * @param type the type value to set
     * @return the AliasPattern object itself.
     */
    public AliasPattern withType(AliasPatternType type) {
        this.type = type;
        return this;
    }

}
