/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.resources;

import java.util.Collection;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.microsoft.rest.ExpandableStringEnum;

/**
 * Defines values for RegionType.
 */
public final class RegionType extends ExpandableStringEnum<RegionType> {
    /** Static value Physical for RegionType. */
    public static final RegionType PHYSICAL = fromString("Physical");

    /** Static value Logical for RegionType. */
    public static final RegionType LOGICAL = fromString("Logical");

    /**
     * Creates or finds a RegionType from its string representation.
     * @param name a name to look for
     * @return the corresponding RegionType
     */
    @JsonCreator
    public static RegionType fromString(String name) {
        return fromString(name, RegionType.class);
    }

    /**
     * @return known RegionType values
     */
    public static Collection<RegionType> values() {
        return values(RegionType.class);
    }
}
