/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.resources;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for AliasPatternType.
 */
public enum AliasPatternType {
    /** NotSpecified is not allowed. */
    NOT_SPECIFIED("NotSpecified"),

    /** Extract is the only allowed value. */
    EXTRACT("Extract");

    /** The actual serialized value for a AliasPatternType instance. */
    private String value;

    AliasPatternType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a AliasPatternType instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed AliasPatternType object, or null if unable to parse.
     */
    @JsonCreator
    public static AliasPatternType fromString(String value) {
        AliasPatternType[] items = AliasPatternType.values();
        for (AliasPatternType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
