/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.resources;

import java.util.Map;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Deployment operation parameters.
 */
public class ScopedDeployment {
    /**
     * The location to store the deployment data.
     */
    @JsonProperty(value = "location", required = true)
    private String location;

    /**
     * The deployment properties.
     */
    @JsonProperty(value = "properties", required = true)
    private DeploymentProperties properties;

    /**
     * Deployment tags.
     */
    @JsonProperty(value = "tags")
    private Map<String, String> tags;

    /**
     * Get the location to store the deployment data.
     *
     * @return the location value
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location to store the deployment data.
     *
     * @param location the location value to set
     * @return the ScopedDeployment object itself.
     */
    public ScopedDeployment withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the deployment properties.
     *
     * @return the properties value
     */
    public DeploymentProperties properties() {
        return this.properties;
    }

    /**
     * Set the deployment properties.
     *
     * @param properties the properties value to set
     * @return the ScopedDeployment object itself.
     */
    public ScopedDeployment withProperties(DeploymentProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get deployment tags.
     *
     * @return the tags value
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set deployment tags.
     *
     * @param tags the tags value to set
     * @return the ScopedDeployment object itself.
     */
    public ScopedDeployment withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

}
