/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.resources;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Deployment What-if operation parameters.
 */
public class ScopedDeploymentWhatIf {
    /**
     * The location to store the deployment data.
     */
    @JsonProperty(value = "location", required = true)
    private String location;

    /**
     * The deployment properties.
     */
    @JsonProperty(value = "properties", required = true)
    private DeploymentWhatIfProperties properties;

    /**
     * Get the location to store the deployment data.
     *
     * @return the location value
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location to store the deployment data.
     *
     * @param location the location value to set
     * @return the ScopedDeploymentWhatIf object itself.
     */
    public ScopedDeploymentWhatIf withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the deployment properties.
     *
     * @return the properties value
     */
    public DeploymentWhatIfProperties properties() {
        return this.properties;
    }

    /**
     * Set the deployment properties.
     *
     * @param properties the properties value to set
     * @return the ScopedDeploymentWhatIf object itself.
     */
    public ScopedDeploymentWhatIf withProperties(DeploymentWhatIfProperties properties) {
        this.properties = properties;
        return this;
    }

}
