/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.search.implementation;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.AzureResponseBuilder;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.resources.fluentcore.arm.AzureConfigurable;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.Manager;
import com.microsoft.azure.management.resources.fluentcore.utils.ProviderRegistrationInterceptor;
import com.microsoft.azure.management.resources.fluentcore.utils.ResourceManagerThrottlingInterceptor;
import com.microsoft.azure.management.search.SearchServices;
import com.microsoft.azure.management.search.implementation.SearchManagementClientImpl;
import com.microsoft.azure.management.search.implementation.SearchServicesImpl;
import com.microsoft.azure.serializer.AzureJacksonAdapter;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.protocol.Environment;
import com.microsoft.rest.protocol.ResponseBuilder;
import com.microsoft.rest.protocol.SerializerAdapter;
import okhttp3.Interceptor;

@Beta(value=Beta.SinceVersion.V1_2_0)
public final class SearchServiceManager
extends Manager<SearchServiceManager, SearchManagementClientImpl> {
    private SearchServicesImpl searchServices;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static SearchServiceManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
        return new SearchServiceManager(new RestClient.Builder().withBaseUrl((Environment)credentials.environment(), (Environment.Endpoint)AzureEnvironment.Endpoint.RESOURCE_MANAGER).withCredentials((ServiceClientCredentials)credentials).withSerializerAdapter((SerializerAdapter)new AzureJacksonAdapter()).withResponseBuilderFactory((ResponseBuilder.Factory)new AzureResponseBuilder.Factory()).withInterceptor((Interceptor)new ProviderRegistrationInterceptor(credentials)).withInterceptor((Interceptor)new ResourceManagerThrottlingInterceptor()).build(), subscriptionId);
    }

    public static SearchServiceManager authenticate(RestClient restClient, String subscriptionId) {
        return new SearchServiceManager(restClient, subscriptionId);
    }

    private SearchServiceManager(RestClient restClient, String subscriptionId) {
        super(restClient, subscriptionId, (Object)new SearchManagementClientImpl(restClient).withSubscriptionId(subscriptionId));
    }

    public SearchServices searchServices() {
        if (this.searchServices == null) {
            this.searchServices = new SearchServicesImpl(this);
        }
        return this.searchServices;
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public SearchServiceManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
            return SearchServiceManager.authenticate(this.buildRestClient(credentials), subscriptionId);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public SearchServiceManager authenticate(AzureTokenCredentials var1, String var2);
    }
}

