/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.search;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for UnavailableNameReason.
 */
public final class UnavailableNameReason {
    /** Static value Invalid for UnavailableNameReason. */
    public static final UnavailableNameReason INVALID = new UnavailableNameReason("Invalid");

    /** Static value AlreadyExists for UnavailableNameReason. */
    public static final UnavailableNameReason ALREADY_EXISTS = new UnavailableNameReason("AlreadyExists");

    private String value;

    /**
     * Creates a custom value for UnavailableNameReason.
     * @param value the custom value
     */
    public UnavailableNameReason(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof UnavailableNameReason)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        UnavailableNameReason rhs = (UnavailableNameReason) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
