/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.search;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Defines the SKU of an Azure Search Service, which determines price tier and
 * capacity limits.
 */
public class Sku {
    /**
     * The SKU of the Search service. Valid values include: 'free': Shared
     * service. 'basic': Dedicated service with up to 3 replicas. 'standard':
     * Dedicated service with up to 12 partitions and 12 replicas. 'standard2':
     * Similar to standard, but with more capacity per search unit.
     * 'standard3': Offers maximum capacity per search unit with up to 12
     * partitions and 12 replicas (or up to 3 partitions with more indexes if
     * you also set the hostingMode property to 'highDensity'). Possible values
     * include: 'free', 'basic', 'standard', 'standard2', 'standard3'.
     */
    @JsonProperty(value = "name")
    private SkuName name;

    /**
     * Get the name value.
     *
     * @return the name value
     */
    public SkuName name() {
        return this.name;
    }

    /**
     * Set the name value.
     *
     * @param name the name value to set
     * @return the Sku object itself.
     */
    public Sku withName(SkuName name) {
        this.name = name;
        return this;
    }

}
