/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.search.implementation;

import com.microsoft.azure.management.search.HostingMode;
import com.microsoft.azure.management.search.SearchServiceStatus;
import com.microsoft.azure.management.search.ProvisioningState;
import com.microsoft.azure.management.search.Sku;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.Resource;

/**
 * Describes an Azure Search service and its current state.
 */
@JsonFlatten
public class SearchServiceInner extends Resource {
    /**
     * The number of replicas in the Search service. If specified, it must be a
     * value between 1 and 12 inclusive for standard SKUs or between 1 and 3
     * inclusive for basic SKU.
     */
    @JsonProperty(value = "properties.replicaCount")
    private Integer replicaCount;

    /**
     * The number of partitions in the Search service; if specified, it can be
     * 1, 2, 3, 4, 6, or 12. Values greater than 1 are only valid for standard
     * SKUs. For 'standard3' services with hostingMode set to 'highDensity',
     * the allowed values are between 1 and 3.
     */
    @JsonProperty(value = "properties.partitionCount")
    private Integer partitionCount;

    /**
     * Applicable only for the standard3 SKU. You can set this property to
     * enable up to 3 high density partitions that allow up to 1000 indexes,
     * which is much higher than the maximum indexes allowed for any other SKU.
     * For the standard3 SKU, the value is either 'default' or 'highDensity'.
     * For all other SKUs, this value must be 'default'. Possible values
     * include: 'default', 'highDensity'.
     */
    @JsonProperty(value = "properties.hostingMode")
    private HostingMode hostingMode;

    /**
     * The status of the Search service. Possible values include: 'running':
     * The Search service is running and no provisioning operations are
     * underway. 'provisioning': The Search service is being provisioned or
     * scaled up or down. 'deleting': The Search service is being deleted.
     * 'degraded': The Search service is degraded. This can occur when the
     * underlying search units are not healthy. The Search service is most
     * likely operational, but performance might be slow and some requests
     * might be dropped. 'disabled': The Search service is disabled. In this
     * state, the service will reject all API requests. 'error': The Search
     * service is in an error state. If your service is in the degraded,
     * disabled, or error states, it means the Azure Search team is actively
     * investigating the underlying issue. Dedicated services in these states
     * are still chargeable based on the number of search units provisioned.
     * Possible values include: 'running', 'provisioning', 'deleting',
     * 'degraded', 'disabled', 'error'.
     */
    @JsonProperty(value = "properties.status", access = JsonProperty.Access.WRITE_ONLY)
    private SearchServiceStatus status;

    /**
     * The details of the Search service status.
     */
    @JsonProperty(value = "properties.statusDetails", access = JsonProperty.Access.WRITE_ONLY)
    private String statusDetails;

    /**
     * The state of the last provisioning operation performed on the Search
     * service. Provisioning is an intermediate state that occurs while service
     * capacity is being established. After capacity is set up,
     * provisioningState changes to either 'succeeded' or 'failed'. Client
     * applications can poll provisioning status (the recommended polling
     * interval is from 30 seconds to one minute) by using the Get Search
     * Service operation to see when an operation is completed. If you are
     * using the free service, this value tends to come back as 'succeeded'
     * directly in the call to Create Search service. This is because the free
     * service uses capacity that is already set up. Possible values include:
     * 'succeeded', 'provisioning', 'failed'.
     */
    @JsonProperty(value = "properties.provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /**
     * The SKU of the Search Service, which determines price tier and capacity
     * limits.
     */
    @JsonProperty(value = "sku", required = true)
    private Sku sku;

    /**
     * Get the replicaCount value.
     *
     * @return the replicaCount value
     */
    public Integer replicaCount() {
        return this.replicaCount;
    }

    /**
     * Set the replicaCount value.
     *
     * @param replicaCount the replicaCount value to set
     * @return the SearchServiceInner object itself.
     */
    public SearchServiceInner withReplicaCount(Integer replicaCount) {
        this.replicaCount = replicaCount;
        return this;
    }

    /**
     * Get the partitionCount value.
     *
     * @return the partitionCount value
     */
    public Integer partitionCount() {
        return this.partitionCount;
    }

    /**
     * Set the partitionCount value.
     *
     * @param partitionCount the partitionCount value to set
     * @return the SearchServiceInner object itself.
     */
    public SearchServiceInner withPartitionCount(Integer partitionCount) {
        this.partitionCount = partitionCount;
        return this;
    }

    /**
     * Get the hostingMode value.
     *
     * @return the hostingMode value
     */
    public HostingMode hostingMode() {
        return this.hostingMode;
    }

    /**
     * Set the hostingMode value.
     *
     * @param hostingMode the hostingMode value to set
     * @return the SearchServiceInner object itself.
     */
    public SearchServiceInner withHostingMode(HostingMode hostingMode) {
        this.hostingMode = hostingMode;
        return this;
    }

    /**
     * Get the status value.
     *
     * @return the status value
     */
    public SearchServiceStatus status() {
        return this.status;
    }

    /**
     * Get the statusDetails value.
     *
     * @return the statusDetails value
     */
    public String statusDetails() {
        return this.statusDetails;
    }

    /**
     * Get the provisioningState value.
     *
     * @return the provisioningState value
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the sku value.
     *
     * @return the sku value
     */
    public Sku sku() {
        return this.sku;
    }

    /**
     * Set the sku value.
     *
     * @param sku the sku value to set
     * @return the SearchServiceInner object itself.
     */
    public SearchServiceInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

}
