/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.servicebus;

import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.resources.fluentcore.arm.models.IndependentChildResource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import com.microsoft.azure.management.servicebus.EntityStatus;
import com.microsoft.azure.management.servicebus.ServiceBusSubscriptions;
import com.microsoft.azure.management.servicebus.TopicAuthorizationRules;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusManager;
import com.microsoft.azure.management.servicebus.implementation.TopicInner;
import org.joda.time.DateTime;
import org.joda.time.Period;

@Fluent
public interface Topic
extends IndependentChildResource<ServiceBusManager, TopicInner>,
Refreshable<Topic>,
Updatable<Update>,
HasInner<TopicInner> {
    public DateTime createdAt();

    public DateTime accessedAt();

    public DateTime updatedAt();

    public long maxSizeInMB();

    public long currentSizeInBytes();

    public boolean isBatchedOperationsEnabled();

    public boolean isExpressEnabled();

    public boolean isPartitioningEnabled();

    public boolean isDuplicateDetectionEnabled();

    public long deleteOnIdleDurationInMinutes();

    public Period defaultMessageTtlDuration();

    public Period duplicateMessageDetectionHistoryDuration();

    public long activeMessageCount();

    public long deadLetterMessageCount();

    public long scheduledMessageCount();

    public long transferDeadLetterMessageCount();

    public long transferMessageCount();

    public int subscriptionCount();

    public EntityStatus status();

    public ServiceBusSubscriptions subscriptions();

    public TopicAuthorizationRules authorizationRules();

    public static interface UpdateStages {

        public static interface WithAuthorizationRule {
            public Update withNewSendRule(String var1);

            public Update withNewListenRule(String var1);

            public Update withNewManageRule(String var1);

            public Update withoutAuthorizationRule(String var1);
        }

        public static interface WithSubscription {
            public Update withNewSubscription(String var1);

            public Update withoutSubscription(String var1);
        }

        public static interface WithDuplicateMessageDetection {
            public Update withDuplicateMessageDetectionHistoryDuration(Period var1);

            public Update withoutDuplicateMessageDetection();
        }

        public static interface WithMessageBatching {
            public Update withMessageBatching();

            public Update withoutMessageBatching();
        }

        public static interface WithExpressMessage {
            public Update withExpressMessage();

            public Update withoutExpressMessage();
        }

        public static interface WithDefaultMessageTTL {
            public Update withDefaultMessageTTL(Period var1);
        }

        public static interface WithDeleteOnIdle {
            public Update withDeleteOnIdleDurationInMinutes(int var1);
        }

        public static interface WithSize {
            public Update withSizeInMB(long var1);
        }
    }

    public static interface Update
    extends Appliable<Topic>,
    UpdateStages.WithSize,
    UpdateStages.WithDeleteOnIdle,
    UpdateStages.WithDefaultMessageTTL,
    UpdateStages.WithExpressMessage,
    UpdateStages.WithMessageBatching,
    UpdateStages.WithDuplicateMessageDetection,
    UpdateStages.WithSubscription,
    UpdateStages.WithAuthorizationRule {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<Topic>,
        WithSize,
        WithPartitioning,
        WithDeleteOnIdle,
        WithDefaultMessageTTL,
        WithExpressMessage,
        WithMessageBatching,
        WithDuplicateMessageDetection,
        WithSubscription,
        WithAuthorizationRule {
        }

        public static interface WithAuthorizationRule {
            public WithCreate withNewSendRule(String var1);

            public WithCreate withNewListenRule(String var1);

            public WithCreate withNewManageRule(String var1);
        }

        public static interface WithSubscription {
            public WithCreate withNewSubscription(String var1);
        }

        public static interface WithDuplicateMessageDetection {
            public WithCreate withDuplicateMessageDetection(Period var1);
        }

        public static interface WithMessageBatching {
            public WithCreate withoutMessageBatching();
        }

        public static interface WithExpressMessage {
            public WithCreate withExpressMessage();
        }

        public static interface WithDefaultMessageTTL {
            public WithCreate withDefaultMessageTTL(Period var1);
        }

        public static interface WithDeleteOnIdle {
            public WithCreate withDeleteOnIdleDurationInMinutes(int var1);
        }

        public static interface WithPartitioning {
            public WithCreate withPartitioning();

            public WithCreate withoutPartitioning();
        }

        public static interface WithSize {
            public WithCreate withSizeInMB(long var1);
        }

        public static interface Blank
        extends WithCreate {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithCreate {
    }
}

