/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.servicebus.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.servicebus.Queue;
import com.microsoft.azure.management.servicebus.QueueAuthorizationRule;
import com.microsoft.azure.management.servicebus.QueueAuthorizationRules;
import com.microsoft.azure.management.servicebus.implementation.QueueAuthorizationRuleImpl;
import com.microsoft.azure.management.servicebus.implementation.QueuesInner;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusChildResourcesImpl;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusManagementClientImpl;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusManager;
import com.microsoft.azure.management.servicebus.implementation.SharedAccessAuthorizationRuleInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import rx.Completable;
import rx.Observable;

@LangDefinition
class QueueAuthorizationRulesImpl
extends ServiceBusChildResourcesImpl<QueueAuthorizationRule, QueueAuthorizationRuleImpl, SharedAccessAuthorizationRuleInner, QueuesInner, ServiceBusManager, Queue>
implements QueueAuthorizationRules {
    private final String resourceGroupName;
    private final String namespaceName;
    private final String queueName;
    private final Region region;

    QueueAuthorizationRulesImpl(String resourceGroupName, String namespaceName, String queueName, Region region, ServiceBusManager manager) {
        super(((ServiceBusManagementClientImpl)((Object)manager.inner())).queues(), manager);
        this.resourceGroupName = resourceGroupName;
        this.namespaceName = namespaceName;
        this.queueName = queueName;
        this.region = region;
    }

    public QueueAuthorizationRuleImpl define(String name) {
        return this.wrapModel(name);
    }

    public Completable deleteByNameAsync(String name) {
        return ((QueuesInner)this.inner()).deleteAuthorizationRuleAsync(this.resourceGroupName, this.namespaceName, this.queueName, name).toCompletable();
    }

    public ServiceFuture<Void> deleteByNameAsync(String name, ServiceCallback<Void> callback) {
        return ((QueuesInner)this.inner()).deleteAuthorizationRuleAsync(this.resourceGroupName, this.namespaceName, this.queueName, name, callback);
    }

    @Override
    protected Observable<SharedAccessAuthorizationRuleInner> getInnerByNameAsync(String name) {
        return ((QueuesInner)this.inner()).getAuthorizationRuleAsync(this.resourceGroupName, this.namespaceName, this.queueName, name);
    }

    @Override
    protected Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>> listInnerAsync() {
        return ((QueuesInner)this.inner()).listAuthorizationRulesWithServiceResponseAsync(this.resourceGroupName, this.namespaceName, this.queueName);
    }

    @Override
    protected PagedList<SharedAccessAuthorizationRuleInner> listInner() {
        return ((QueuesInner)this.inner()).listAuthorizationRules(this.resourceGroupName, this.namespaceName, this.queueName);
    }

    protected QueueAuthorizationRuleImpl wrapModel(String name) {
        return new QueueAuthorizationRuleImpl(this.resourceGroupName, this.namespaceName, this.queueName, name, this.region, new SharedAccessAuthorizationRuleInner(), (ServiceBusManager)this.manager());
    }

    protected QueueAuthorizationRuleImpl wrapModel(SharedAccessAuthorizationRuleInner inner) {
        return new QueueAuthorizationRuleImpl(this.resourceGroupName, this.namespaceName, this.queueName, inner.name(), this.region, inner, (ServiceBusManager)this.manager());
    }

    public PagedList<QueueAuthorizationRule> listByParent(String resourceGroupName, String parentName) {
        throw new UnsupportedOperationException();
    }

    public Completable deleteByParentAsync(String groupName, String parentName, String name) {
        throw new UnsupportedOperationException();
    }

    public Observable<QueueAuthorizationRule> getByParentAsync(String resourceGroup, String parentName, String name) {
        throw new UnsupportedOperationException();
    }
}

