/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.servicebus.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.servicebus.Topic;
import com.microsoft.azure.management.servicebus.TopicAuthorizationRule;
import com.microsoft.azure.management.servicebus.TopicAuthorizationRules;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusChildResourcesImpl;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusManagementClientImpl;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusManager;
import com.microsoft.azure.management.servicebus.implementation.SharedAccessAuthorizationRuleInner;
import com.microsoft.azure.management.servicebus.implementation.TopicAuthorizationRuleImpl;
import com.microsoft.azure.management.servicebus.implementation.TopicsInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import rx.Completable;
import rx.Observable;

@LangDefinition
class TopicAuthorizationRulesImpl
extends ServiceBusChildResourcesImpl<TopicAuthorizationRule, TopicAuthorizationRuleImpl, SharedAccessAuthorizationRuleInner, TopicsInner, ServiceBusManager, Topic>
implements TopicAuthorizationRules {
    private final String resourceGroupName;
    private final String namespaceName;
    private final String topicName;
    private final Region region;

    TopicAuthorizationRulesImpl(String resourceGroupName, String namespaceName, String topicName, Region region, ServiceBusManager manager) {
        super(((ServiceBusManagementClientImpl)((Object)manager.inner())).topics(), manager);
        this.resourceGroupName = resourceGroupName;
        this.namespaceName = namespaceName;
        this.topicName = topicName;
        this.region = region;
    }

    public TopicAuthorizationRuleImpl define(String name) {
        return this.wrapModel(name);
    }

    public Completable deleteByNameAsync(String name) {
        return ((TopicsInner)this.inner()).deleteAuthorizationRuleAsync(this.resourceGroupName, this.namespaceName, this.topicName, name).toCompletable();
    }

    public ServiceFuture<Void> deleteByNameAsync(String name, ServiceCallback<Void> callback) {
        return ((TopicsInner)this.inner()).deleteAuthorizationRuleAsync(this.resourceGroupName, this.namespaceName, this.topicName, name, callback);
    }

    @Override
    protected Observable<SharedAccessAuthorizationRuleInner> getInnerByNameAsync(String name) {
        return ((TopicsInner)this.inner()).getAuthorizationRuleAsync(this.resourceGroupName, this.namespaceName, this.topicName, name);
    }

    @Override
    protected Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>> listInnerAsync() {
        return ((TopicsInner)this.inner()).listAuthorizationRulesWithServiceResponseAsync(this.resourceGroupName, this.namespaceName, this.topicName);
    }

    @Override
    protected PagedList<SharedAccessAuthorizationRuleInner> listInner() {
        return ((TopicsInner)this.inner()).listAuthorizationRules(this.resourceGroupName, this.namespaceName, this.topicName);
    }

    protected TopicAuthorizationRuleImpl wrapModel(String name) {
        return new TopicAuthorizationRuleImpl(this.resourceGroupName, this.namespaceName, this.topicName, name, this.region, new SharedAccessAuthorizationRuleInner(), (ServiceBusManager)this.manager());
    }

    protected TopicAuthorizationRuleImpl wrapModel(SharedAccessAuthorizationRuleInner inner) {
        return new TopicAuthorizationRuleImpl(this.resourceGroupName, this.namespaceName, this.topicName, inner.name(), this.region, inner, (ServiceBusManager)this.manager());
    }

    public PagedList<TopicAuthorizationRule> listByParent(String resourceGroupName, String parentName) {
        throw new UnsupportedOperationException();
    }

    public Completable deleteByParentAsync(String groupName, String parentName, String name) {
        throw new UnsupportedOperationException();
    }

    public Observable<TopicAuthorizationRule> getByParentAsync(String resourceGroup, String parentName, String name) {
        throw new UnsupportedOperationException();
    }
}

