/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.servicebus.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.servicebus.ServiceBusNamespace;
import com.microsoft.azure.management.servicebus.Topic;
import com.microsoft.azure.management.servicebus.Topics;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusChildResourcesImpl;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusManagementClientImpl;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusManager;
import com.microsoft.azure.management.servicebus.implementation.TopicImpl;
import com.microsoft.azure.management.servicebus.implementation.TopicInner;
import com.microsoft.azure.management.servicebus.implementation.TopicsInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import rx.Completable;
import rx.Observable;

@LangDefinition
class TopicsImpl
extends ServiceBusChildResourcesImpl<Topic, TopicImpl, TopicInner, TopicsInner, ServiceBusManager, ServiceBusNamespace>
implements Topics {
    private final String resourceGroupName;
    private final String namespaceName;
    private final Region region;

    TopicsImpl(String resourceGroupName, String namespaceName, Region region, ServiceBusManager manager) {
        super(((ServiceBusManagementClientImpl)((Object)manager.inner())).topics(), manager);
        this.resourceGroupName = resourceGroupName;
        this.namespaceName = namespaceName;
        this.region = region;
    }

    public TopicImpl define(String name) {
        return this.wrapModel(name);
    }

    public Completable deleteByNameAsync(String name) {
        return ((TopicsInner)this.inner()).deleteAsync(this.resourceGroupName, this.namespaceName, name).toCompletable();
    }

    public ServiceFuture<Void> deleteByNameAsync(String name, ServiceCallback<Void> callback) {
        return ((TopicsInner)this.inner()).deleteAsync(this.resourceGroupName, this.namespaceName, name, callback);
    }

    @Override
    protected Observable<TopicInner> getInnerByNameAsync(String name) {
        return ((TopicsInner)this.inner()).getAsync(this.resourceGroupName, this.namespaceName, name);
    }

    @Override
    protected Observable<ServiceResponse<Page<TopicInner>>> listInnerAsync() {
        return ((TopicsInner)this.inner()).listByNamespaceWithServiceResponseAsync(this.resourceGroupName, this.namespaceName);
    }

    @Override
    protected PagedList<TopicInner> listInner() {
        return ((TopicsInner)this.inner()).listByNamespace(this.resourceGroupName, this.namespaceName);
    }

    protected TopicImpl wrapModel(String name) {
        return new TopicImpl(this.resourceGroupName, this.namespaceName, name, this.region, new TopicInner(), (ServiceBusManager)this.manager());
    }

    protected TopicImpl wrapModel(TopicInner inner) {
        return new TopicImpl(this.resourceGroupName, this.namespaceName, inner.name(), this.region, inner, (ServiceBusManager)this.manager());
    }

    public PagedList<Topic> listByParent(String resourceGroupName, String parentName) {
        throw new UnsupportedOperationException();
    }

    public Completable deleteByParentAsync(String groupName, String parentName, String name) {
        throw new UnsupportedOperationException();
    }

    public Observable<Topic> getByParentAsync(String resourceGroup, String parentName, String name) {
        throw new UnsupportedOperationException();
    }
}

