/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.servicebus.implementation;

import org.joda.time.DateTime;
import com.microsoft.azure.management.servicebus.MessageCountDetails;
import com.microsoft.azure.management.servicebus.EntityStatus;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.Resource;

/**
 * Description of queue Resource.
 */
@JsonFlatten
public class QueueInner extends Resource {
    /**
     * The duration of a peek-lock; that is, the amount of time that the
     * message is locked for other receivers. The maximum value for
     * LockDuration is 5 minutes; the default value is 1 minute. The service
     * accepts a C# Standard TimeSpan Format for loc duration
     * https://msdn.microsoft.com/en-us/library/ee372286(v=vs.110).aspx.
     */
    @JsonProperty(value = "properties.lockDuration")
    private String lockDuration;

    /**
     * Last time a message was sent, or the last time there was a receive
     * request to this queue.
     */
    @JsonProperty(value = "properties.accessedAt", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime accessedAt;

    /**
     * the TimeSpan idle interval after which the queue is automatically
     * deleted. The minimum duration is 5 minutes. The service accepts a C#
     * Standard TimeSpan Format for loc duration
     * https://msdn.microsoft.com/en-us/library/ee372286(v=vs.110).aspx. Format
     * is 'DD.HH:MM:SS' and default value of this property is 10675199 days.
     */
    @JsonProperty(value = "properties.autoDeleteOnIdle")
    private String autoDeleteOnIdle;

    /**
     * The exact time the Queue was created.
     */
    @JsonProperty(value = "properties.createdAt", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime createdAt;

    /**
     * The default message time to live value. This is the duration after which
     * the message expires, starting from when the message is sent to Service
     * Bus. This is the default value used when TimeToLive is not set on a
     * message itself. Format is 'DD.HH:MM:SS' and default value of this
     * property is 10675199 days. The service accepts a C# Standard TimeSpan
     * Format for loc duration
     * https://msdn.microsoft.com/en-us/library/ee372286(v=vs.110).aspx.
     */
    @JsonProperty(value = "properties.defaultMessageTimeToLive")
    private String defaultMessageTimeToLive;

    /**
     * TimeSpan structure that defines the duration of the duplicate detection
     * history. The default value is 10 minutes. The service accepts a C#
     * Standard TimeSpan Format for loc duration
     * https://msdn.microsoft.com/en-us/library/ee372286(v=vs.110).aspx .
     * Format is 'DD.HH:MM:SS' and default value of this property is 10675199
     * days.
     */
    @JsonProperty(value = "properties.duplicateDetectionHistoryTimeWindow")
    private String duplicateDetectionHistoryTimeWindow;

    /**
     * A value that indicates whether server-side batched operations are
     * enabled.
     */
    @JsonProperty(value = "properties.enableBatchedOperations")
    private Boolean enableBatchedOperations;

    /**
     * A value that indicates whether this queue has dead letter support when a
     * message expires.
     */
    @JsonProperty(value = "properties.deadLetteringOnMessageExpiration")
    private Boolean deadLetteringOnMessageExpiration;

    /**
     * A value that indicates whether Express Entities are enabled. An express
     * queue holds a message in memory temporarily before writing it to
     * persistent storage.
     */
    @JsonProperty(value = "properties.enableExpress")
    private Boolean enableExpress;

    /**
     * A value that indicates whether the queue is to be partitioned across
     * multiple message brokers.
     */
    @JsonProperty(value = "properties.enablePartitioning")
    private Boolean enablePartitioning;

    /**
     * The maximum delivery count. A message is automatically deadlettered
     * after this number of deliveries.
     */
    @JsonProperty(value = "properties.maxDeliveryCount")
    private Integer maxDeliveryCount;

    /**
     * The maximum size of the queue in megabytes, which is the size of memory
     * allocated for the queue.
     */
    @JsonProperty(value = "properties.maxSizeInMegabytes")
    private Long maxSizeInMegabytes;

    /**
     * The number of messages in the queue.
     */
    @JsonProperty(value = "properties.messageCount", access = JsonProperty.Access.WRITE_ONLY)
    private Long messageCount;

    /**
     * The countDetails property.
     */
    @JsonProperty(value = "properties.countDetails", access = JsonProperty.Access.WRITE_ONLY)
    private MessageCountDetails countDetails;

    /**
     * A value indicating if this queue requires duplicate detection.
     */
    @JsonProperty(value = "properties.requiresDuplicateDetection")
    private Boolean requiresDuplicateDetection;

    /**
     * A value that indicates whether the queue supports the concept of
     * sessions.
     */
    @JsonProperty(value = "properties.requiresSession")
    private Boolean requiresSession;

    /**
     * The size of the queue, in bytes.
     */
    @JsonProperty(value = "properties.sizeInBytes", access = JsonProperty.Access.WRITE_ONLY)
    private Long sizeInBytes;

    /**
     * Enumerates the possible values for the status of a messaging entity.
     * Possible values include: 'Active', 'Creating', 'Deleting', 'Disabled',
     * 'ReceiveDisabled', 'Renaming', 'Restoring', 'SendDisabled', 'Unknown'.
     */
    @JsonProperty(value = "properties.status", access = JsonProperty.Access.WRITE_ONLY)
    private EntityStatus status;

    /**
     * A value that indicates whether the queue supports ordering.
     */
    @JsonProperty(value = "properties.supportOrdering")
    private Boolean supportOrdering;

    /**
     * The exact time the Queue was updated.
     */
    @JsonProperty(value = "properties.updatedAt", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime updatedAt;

    /**
     * Get the lockDuration value.
     *
     * @return the lockDuration value
     */
    public String lockDuration() {
        return this.lockDuration;
    }

    /**
     * Set the lockDuration value.
     *
     * @param lockDuration the lockDuration value to set
     * @return the QueueInner object itself.
     */
    public QueueInner withLockDuration(String lockDuration) {
        this.lockDuration = lockDuration;
        return this;
    }

    /**
     * Get the accessedAt value.
     *
     * @return the accessedAt value
     */
    public DateTime accessedAt() {
        return this.accessedAt;
    }

    /**
     * Get the autoDeleteOnIdle value.
     *
     * @return the autoDeleteOnIdle value
     */
    public String autoDeleteOnIdle() {
        return this.autoDeleteOnIdle;
    }

    /**
     * Set the autoDeleteOnIdle value.
     *
     * @param autoDeleteOnIdle the autoDeleteOnIdle value to set
     * @return the QueueInner object itself.
     */
    public QueueInner withAutoDeleteOnIdle(String autoDeleteOnIdle) {
        this.autoDeleteOnIdle = autoDeleteOnIdle;
        return this;
    }

    /**
     * Get the createdAt value.
     *
     * @return the createdAt value
     */
    public DateTime createdAt() {
        return this.createdAt;
    }

    /**
     * Get the defaultMessageTimeToLive value.
     *
     * @return the defaultMessageTimeToLive value
     */
    public String defaultMessageTimeToLive() {
        return this.defaultMessageTimeToLive;
    }

    /**
     * Set the defaultMessageTimeToLive value.
     *
     * @param defaultMessageTimeToLive the defaultMessageTimeToLive value to set
     * @return the QueueInner object itself.
     */
    public QueueInner withDefaultMessageTimeToLive(String defaultMessageTimeToLive) {
        this.defaultMessageTimeToLive = defaultMessageTimeToLive;
        return this;
    }

    /**
     * Get the duplicateDetectionHistoryTimeWindow value.
     *
     * @return the duplicateDetectionHistoryTimeWindow value
     */
    public String duplicateDetectionHistoryTimeWindow() {
        return this.duplicateDetectionHistoryTimeWindow;
    }

    /**
     * Set the duplicateDetectionHistoryTimeWindow value.
     *
     * @param duplicateDetectionHistoryTimeWindow the duplicateDetectionHistoryTimeWindow value to set
     * @return the QueueInner object itself.
     */
    public QueueInner withDuplicateDetectionHistoryTimeWindow(String duplicateDetectionHistoryTimeWindow) {
        this.duplicateDetectionHistoryTimeWindow = duplicateDetectionHistoryTimeWindow;
        return this;
    }

    /**
     * Get the enableBatchedOperations value.
     *
     * @return the enableBatchedOperations value
     */
    public Boolean enableBatchedOperations() {
        return this.enableBatchedOperations;
    }

    /**
     * Set the enableBatchedOperations value.
     *
     * @param enableBatchedOperations the enableBatchedOperations value to set
     * @return the QueueInner object itself.
     */
    public QueueInner withEnableBatchedOperations(Boolean enableBatchedOperations) {
        this.enableBatchedOperations = enableBatchedOperations;
        return this;
    }

    /**
     * Get the deadLetteringOnMessageExpiration value.
     *
     * @return the deadLetteringOnMessageExpiration value
     */
    public Boolean deadLetteringOnMessageExpiration() {
        return this.deadLetteringOnMessageExpiration;
    }

    /**
     * Set the deadLetteringOnMessageExpiration value.
     *
     * @param deadLetteringOnMessageExpiration the deadLetteringOnMessageExpiration value to set
     * @return the QueueInner object itself.
     */
    public QueueInner withDeadLetteringOnMessageExpiration(Boolean deadLetteringOnMessageExpiration) {
        this.deadLetteringOnMessageExpiration = deadLetteringOnMessageExpiration;
        return this;
    }

    /**
     * Get the enableExpress value.
     *
     * @return the enableExpress value
     */
    public Boolean enableExpress() {
        return this.enableExpress;
    }

    /**
     * Set the enableExpress value.
     *
     * @param enableExpress the enableExpress value to set
     * @return the QueueInner object itself.
     */
    public QueueInner withEnableExpress(Boolean enableExpress) {
        this.enableExpress = enableExpress;
        return this;
    }

    /**
     * Get the enablePartitioning value.
     *
     * @return the enablePartitioning value
     */
    public Boolean enablePartitioning() {
        return this.enablePartitioning;
    }

    /**
     * Set the enablePartitioning value.
     *
     * @param enablePartitioning the enablePartitioning value to set
     * @return the QueueInner object itself.
     */
    public QueueInner withEnablePartitioning(Boolean enablePartitioning) {
        this.enablePartitioning = enablePartitioning;
        return this;
    }

    /**
     * Get the maxDeliveryCount value.
     *
     * @return the maxDeliveryCount value
     */
    public Integer maxDeliveryCount() {
        return this.maxDeliveryCount;
    }

    /**
     * Set the maxDeliveryCount value.
     *
     * @param maxDeliveryCount the maxDeliveryCount value to set
     * @return the QueueInner object itself.
     */
    public QueueInner withMaxDeliveryCount(Integer maxDeliveryCount) {
        this.maxDeliveryCount = maxDeliveryCount;
        return this;
    }

    /**
     * Get the maxSizeInMegabytes value.
     *
     * @return the maxSizeInMegabytes value
     */
    public Long maxSizeInMegabytes() {
        return this.maxSizeInMegabytes;
    }

    /**
     * Set the maxSizeInMegabytes value.
     *
     * @param maxSizeInMegabytes the maxSizeInMegabytes value to set
     * @return the QueueInner object itself.
     */
    public QueueInner withMaxSizeInMegabytes(Long maxSizeInMegabytes) {
        this.maxSizeInMegabytes = maxSizeInMegabytes;
        return this;
    }

    /**
     * Get the messageCount value.
     *
     * @return the messageCount value
     */
    public Long messageCount() {
        return this.messageCount;
    }

    /**
     * Get the countDetails value.
     *
     * @return the countDetails value
     */
    public MessageCountDetails countDetails() {
        return this.countDetails;
    }

    /**
     * Get the requiresDuplicateDetection value.
     *
     * @return the requiresDuplicateDetection value
     */
    public Boolean requiresDuplicateDetection() {
        return this.requiresDuplicateDetection;
    }

    /**
     * Set the requiresDuplicateDetection value.
     *
     * @param requiresDuplicateDetection the requiresDuplicateDetection value to set
     * @return the QueueInner object itself.
     */
    public QueueInner withRequiresDuplicateDetection(Boolean requiresDuplicateDetection) {
        this.requiresDuplicateDetection = requiresDuplicateDetection;
        return this;
    }

    /**
     * Get the requiresSession value.
     *
     * @return the requiresSession value
     */
    public Boolean requiresSession() {
        return this.requiresSession;
    }

    /**
     * Set the requiresSession value.
     *
     * @param requiresSession the requiresSession value to set
     * @return the QueueInner object itself.
     */
    public QueueInner withRequiresSession(Boolean requiresSession) {
        this.requiresSession = requiresSession;
        return this;
    }

    /**
     * Get the sizeInBytes value.
     *
     * @return the sizeInBytes value
     */
    public Long sizeInBytes() {
        return this.sizeInBytes;
    }

    /**
     * Get the status value.
     *
     * @return the status value
     */
    public EntityStatus status() {
        return this.status;
    }

    /**
     * Get the supportOrdering value.
     *
     * @return the supportOrdering value
     */
    public Boolean supportOrdering() {
        return this.supportOrdering;
    }

    /**
     * Set the supportOrdering value.
     *
     * @param supportOrdering the supportOrdering value to set
     * @return the QueueInner object itself.
     */
    public QueueInner withSupportOrdering(Boolean supportOrdering) {
        this.supportOrdering = supportOrdering;
        return this;
    }

    /**
     * Get the updatedAt value.
     *
     * @return the updatedAt value
     */
    public DateTime updatedAt() {
        return this.updatedAt;
    }

}
