/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.servicebus.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.servicebus.AccessRights;
import com.microsoft.azure.management.servicebus.CheckNameAvailability;
import com.microsoft.azure.management.servicebus.Policykey;
import com.microsoft.azure.management.servicebus.RegenerateKeysParameters;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in Namespaces.
 */
public class NamespacesInner implements InnerSupportsGet<NamespaceInner>, InnerSupportsDelete<Void>, InnerSupportsListing<NamespaceInner> {
    /** The Retrofit service to perform REST calls. */
    private NamespacesService service;
    /** The service client containing this operation class. */
    private ServiceBusManagementClientImpl client;

    /**
     * Initializes an instance of NamespacesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public NamespacesInner(Retrofit retrofit, ServiceBusManagementClientImpl client) {
        this.service = retrofit.create(NamespacesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for Namespaces to be
     * used by Retrofit to perform actually REST calls.
     */
    interface NamespacesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Namespaces checkNameAvailabilityMethod" })
        @POST("subscriptions/{subscriptionId}/providers/Microsoft.ServiceBus/CheckNameAvailability")
        Observable<Response<ResponseBody>> checkNameAvailabilityMethod(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body CheckNameAvailability parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Namespaces list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.ServiceBus/namespaces")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Namespaces listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Namespaces createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("namespaceName") String namespaceName, @Path("subscriptionId") String subscriptionId, @Body NamespaceInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Namespaces beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("namespaceName") String namespaceName, @Path("subscriptionId") String subscriptionId, @Body NamespaceInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Namespaces delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("namespaceName") String namespaceName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Namespaces beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("namespaceName") String namespaceName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Namespaces getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("namespaceName") String namespaceName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Namespaces update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}")
        Observable<Response<ResponseBody>> update(@Path("resourceGroupName") String resourceGroupName, @Path("namespaceName") String namespaceName, @Path("subscriptionId") String subscriptionId, @Body NamespaceUpdateParametersInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Namespaces listAuthorizationRules" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/AuthorizationRules")
        Observable<Response<ResponseBody>> listAuthorizationRules(@Path("resourceGroupName") String resourceGroupName, @Path("namespaceName") String namespaceName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Namespaces createOrUpdateAuthorizationRule" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/AuthorizationRules/{authorizationRuleName}")
        Observable<Response<ResponseBody>> createOrUpdateAuthorizationRule(@Path("resourceGroupName") String resourceGroupName, @Path("namespaceName") String namespaceName, @Path("authorizationRuleName") String authorizationRuleName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body SharedAccessAuthorizationRuleInner parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Namespaces deleteAuthorizationRule" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/AuthorizationRules/{authorizationRuleName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteAuthorizationRule(@Path("resourceGroupName") String resourceGroupName, @Path("namespaceName") String namespaceName, @Path("authorizationRuleName") String authorizationRuleName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Namespaces getAuthorizationRule" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/AuthorizationRules/{authorizationRuleName}")
        Observable<Response<ResponseBody>> getAuthorizationRule(@Path("resourceGroupName") String resourceGroupName, @Path("namespaceName") String namespaceName, @Path("authorizationRuleName") String authorizationRuleName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Namespaces listKeys" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/AuthorizationRules/{authorizationRuleName}/listKeys")
        Observable<Response<ResponseBody>> listKeys(@Path("resourceGroupName") String resourceGroupName, @Path("namespaceName") String namespaceName, @Path("authorizationRuleName") String authorizationRuleName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Namespaces regenerateKeys" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/AuthorizationRules/{authorizationRuleName}/regenerateKeys")
        Observable<Response<ResponseBody>> regenerateKeys(@Path("resourceGroupName") String resourceGroupName, @Path("namespaceName") String namespaceName, @Path("authorizationRuleName") String authorizationRuleName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body RegenerateKeysParameters parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Namespaces listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Namespaces listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Namespaces listAuthorizationRulesNext" })
        @GET
        Observable<Response<ResponseBody>> listAuthorizationRulesNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Check the give namespace name availability.
     *
     * @param name The Name to check the namespce name availability and The namespace name can contain only letters, numbers, and hyphens. The namespace must start with a letter, and it must end with a letter or number.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CheckNameAvailabilityResultInner object if successful.
     */
    public CheckNameAvailabilityResultInner checkNameAvailabilityMethod(String name) {
        return checkNameAvailabilityMethodWithServiceResponseAsync(name).toBlocking().single().body();
    }

    /**
     * Check the give namespace name availability.
     *
     * @param name The Name to check the namespce name availability and The namespace name can contain only letters, numbers, and hyphens. The namespace must start with a letter, and it must end with a letter or number.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<CheckNameAvailabilityResultInner> checkNameAvailabilityMethodAsync(String name, final ServiceCallback<CheckNameAvailabilityResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(checkNameAvailabilityMethodWithServiceResponseAsync(name), serviceCallback);
    }

    /**
     * Check the give namespace name availability.
     *
     * @param name The Name to check the namespce name availability and The namespace name can contain only letters, numbers, and hyphens. The namespace must start with a letter, and it must end with a letter or number.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CheckNameAvailabilityResultInner object
     */
    public Observable<CheckNameAvailabilityResultInner> checkNameAvailabilityMethodAsync(String name) {
        return checkNameAvailabilityMethodWithServiceResponseAsync(name).map(new Func1<ServiceResponse<CheckNameAvailabilityResultInner>, CheckNameAvailabilityResultInner>() {
            @Override
            public CheckNameAvailabilityResultInner call(ServiceResponse<CheckNameAvailabilityResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Check the give namespace name availability.
     *
     * @param name The Name to check the namespce name availability and The namespace name can contain only letters, numbers, and hyphens. The namespace must start with a letter, and it must end with a letter or number.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CheckNameAvailabilityResultInner object
     */
    public Observable<ServiceResponse<CheckNameAvailabilityResultInner>> checkNameAvailabilityMethodWithServiceResponseAsync(String name) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        CheckNameAvailability parameters = new CheckNameAvailability();
        parameters.withName(name);
        return service.checkNameAvailabilityMethod(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<CheckNameAvailabilityResultInner>>>() {
                @Override
                public Observable<ServiceResponse<CheckNameAvailabilityResultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<CheckNameAvailabilityResultInner> clientResponse = checkNameAvailabilityMethodDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<CheckNameAvailabilityResultInner> checkNameAvailabilityMethodDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<CheckNameAvailabilityResultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<CheckNameAvailabilityResultInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all the available namespaces within the subscription, irrespective of the resource groups.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;NamespaceInner&gt; object if successful.
     */
    public PagedList<NamespaceInner> list() {
        ServiceResponse<Page<NamespaceInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<NamespaceInner>(response.body()) {
            @Override
            public Page<NamespaceInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the available namespaces within the subscription, irrespective of the resource groups.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<NamespaceInner>> listAsync(final ListOperationCallback<NamespaceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<NamespaceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<NamespaceInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the available namespaces within the subscription, irrespective of the resource groups.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;NamespaceInner&gt; object
     */
    public Observable<Page<NamespaceInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<NamespaceInner>>, Page<NamespaceInner>>() {
                @Override
                public Page<NamespaceInner> call(ServiceResponse<Page<NamespaceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the available namespaces within the subscription, irrespective of the resource groups.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;NamespaceInner&gt; object
     */
    public Observable<ServiceResponse<Page<NamespaceInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<NamespaceInner>>, Observable<ServiceResponse<Page<NamespaceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<NamespaceInner>>> call(ServiceResponse<Page<NamespaceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the available namespaces within the subscription, irrespective of the resource groups.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;NamespaceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<NamespaceInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<NamespaceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<NamespaceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<NamespaceInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<NamespaceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<NamespaceInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<NamespaceInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<NamespaceInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the available namespaces within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;NamespaceInner&gt; object if successful.
     */
    public PagedList<NamespaceInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<NamespaceInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<NamespaceInner>(response.body()) {
            @Override
            public Page<NamespaceInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets the available namespaces within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<NamespaceInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<NamespaceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<NamespaceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<NamespaceInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets the available namespaces within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;NamespaceInner&gt; object
     */
    public Observable<Page<NamespaceInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<NamespaceInner>>, Page<NamespaceInner>>() {
                @Override
                public Page<NamespaceInner> call(ServiceResponse<Page<NamespaceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets the available namespaces within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;NamespaceInner&gt; object
     */
    public Observable<ServiceResponse<Page<NamespaceInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<NamespaceInner>>, Observable<ServiceResponse<Page<NamespaceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<NamespaceInner>>> call(ServiceResponse<Page<NamespaceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets the available namespaces within a resource group.
     *
    ServiceResponse<PageImpl<NamespaceInner>> * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;NamespaceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<NamespaceInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<NamespaceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<NamespaceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<NamespaceInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<NamespaceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<NamespaceInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<NamespaceInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<NamespaceInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates or updates a service namespace. Once created, this namespace's resource manifest is immutable. This operation is idempotent.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param parameters Parameters supplied to create a namespace resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the NamespaceInner object if successful.
     */
    public NamespaceInner createOrUpdate(String resourceGroupName, String namespaceName, NamespaceInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, parameters).toBlocking().last().body();
    }

    /**
     * Creates or updates a service namespace. Once created, this namespace's resource manifest is immutable. This operation is idempotent.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param parameters Parameters supplied to create a namespace resource.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<NamespaceInner> createOrUpdateAsync(String resourceGroupName, String namespaceName, NamespaceInner parameters, final ServiceCallback<NamespaceInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, parameters), serviceCallback);
    }

    /**
     * Creates or updates a service namespace. Once created, this namespace's resource manifest is immutable. This operation is idempotent.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param parameters Parameters supplied to create a namespace resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<NamespaceInner> createOrUpdateAsync(String resourceGroupName, String namespaceName, NamespaceInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, parameters).map(new Func1<ServiceResponse<NamespaceInner>, NamespaceInner>() {
            @Override
            public NamespaceInner call(ServiceResponse<NamespaceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a service namespace. Once created, this namespace's resource manifest is immutable. This operation is idempotent.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param parameters Parameters supplied to create a namespace resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<NamespaceInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String namespaceName, NamespaceInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(resourceGroupName, namespaceName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<NamespaceInner>() { }.getType());
    }

    /**
     * Creates or updates a service namespace. Once created, this namespace's resource manifest is immutable. This operation is idempotent.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param parameters Parameters supplied to create a namespace resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the NamespaceInner object if successful.
     */
    public NamespaceInner beginCreateOrUpdate(String resourceGroupName, String namespaceName, NamespaceInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, parameters).toBlocking().single().body();
    }

    /**
     * Creates or updates a service namespace. Once created, this namespace's resource manifest is immutable. This operation is idempotent.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param parameters Parameters supplied to create a namespace resource.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<NamespaceInner> beginCreateOrUpdateAsync(String resourceGroupName, String namespaceName, NamespaceInner parameters, final ServiceCallback<NamespaceInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, parameters), serviceCallback);
    }

    /**
     * Creates or updates a service namespace. Once created, this namespace's resource manifest is immutable. This operation is idempotent.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param parameters Parameters supplied to create a namespace resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the NamespaceInner object
     */
    public Observable<NamespaceInner> beginCreateOrUpdateAsync(String resourceGroupName, String namespaceName, NamespaceInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, parameters).map(new Func1<ServiceResponse<NamespaceInner>, NamespaceInner>() {
            @Override
            public NamespaceInner call(ServiceResponse<NamespaceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a service namespace. Once created, this namespace's resource manifest is immutable. This operation is idempotent.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param parameters Parameters supplied to create a namespace resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the NamespaceInner object
     */
    public Observable<ServiceResponse<NamespaceInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String namespaceName, NamespaceInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.beginCreateOrUpdate(resourceGroupName, namespaceName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<NamespaceInner>>>() {
                @Override
                public Observable<ServiceResponse<NamespaceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<NamespaceInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<NamespaceInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<NamespaceInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(201, new TypeToken<NamespaceInner>() { }.getType())
                .register(200, new TypeToken<NamespaceInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes an existing namespace. This operation also removes all associated resources under the namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String namespaceName) {
        deleteWithServiceResponseAsync(resourceGroupName, namespaceName).toBlocking().last().body();
    }

    /**
     * Deletes an existing namespace. This operation also removes all associated resources under the namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String namespaceName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, namespaceName), serviceCallback);
    }

    /**
     * Deletes an existing namespace. This operation also removes all associated resources under the namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String namespaceName) {
        return deleteWithServiceResponseAsync(resourceGroupName, namespaceName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing namespace. This operation also removes all associated resources under the namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String namespaceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, namespaceName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes an existing namespace. This operation also removes all associated resources under the namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String namespaceName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, namespaceName).toBlocking().single().body();
    }

    /**
     * Deletes an existing namespace. This operation also removes all associated resources under the namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String namespaceName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, namespaceName), serviceCallback);
    }

    /**
     * Deletes an existing namespace. This operation also removes all associated resources under the namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String namespaceName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, namespaceName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing namespace. This operation also removes all associated resources under the namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String namespaceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDelete(resourceGroupName, namespaceName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a description for the specified namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the NamespaceInner object if successful.
     */
    public NamespaceInner getByResourceGroup(String resourceGroupName, String namespaceName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, namespaceName).toBlocking().single().body();
    }

    /**
     * Gets a description for the specified namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<NamespaceInner> getByResourceGroupAsync(String resourceGroupName, String namespaceName, final ServiceCallback<NamespaceInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, namespaceName), serviceCallback);
    }

    /**
     * Gets a description for the specified namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the NamespaceInner object
     */
    public Observable<NamespaceInner> getByResourceGroupAsync(String resourceGroupName, String namespaceName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, namespaceName).map(new Func1<ServiceResponse<NamespaceInner>, NamespaceInner>() {
            @Override
            public NamespaceInner call(ServiceResponse<NamespaceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a description for the specified namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the NamespaceInner object
     */
    public Observable<ServiceResponse<NamespaceInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String namespaceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getByResourceGroup(resourceGroupName, namespaceName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<NamespaceInner>>>() {
                @Override
                public Observable<ServiceResponse<NamespaceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<NamespaceInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<NamespaceInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<NamespaceInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<NamespaceInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Updates a service namespace. Once created, this namespace's resource manifest is immutable. This operation is idempotent.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param parameters Parameters supplied to update a namespace resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the NamespaceInner object if successful.
     */
    public NamespaceInner update(String resourceGroupName, String namespaceName, NamespaceUpdateParametersInner parameters) {
        return updateWithServiceResponseAsync(resourceGroupName, namespaceName, parameters).toBlocking().single().body();
    }

    /**
     * Updates a service namespace. Once created, this namespace's resource manifest is immutable. This operation is idempotent.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param parameters Parameters supplied to update a namespace resource.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<NamespaceInner> updateAsync(String resourceGroupName, String namespaceName, NamespaceUpdateParametersInner parameters, final ServiceCallback<NamespaceInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, namespaceName, parameters), serviceCallback);
    }

    /**
     * Updates a service namespace. Once created, this namespace's resource manifest is immutable. This operation is idempotent.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param parameters Parameters supplied to update a namespace resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the NamespaceInner object
     */
    public Observable<NamespaceInner> updateAsync(String resourceGroupName, String namespaceName, NamespaceUpdateParametersInner parameters) {
        return updateWithServiceResponseAsync(resourceGroupName, namespaceName, parameters).map(new Func1<ServiceResponse<NamespaceInner>, NamespaceInner>() {
            @Override
            public NamespaceInner call(ServiceResponse<NamespaceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates a service namespace. Once created, this namespace's resource manifest is immutable. This operation is idempotent.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param parameters Parameters supplied to update a namespace resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the NamespaceInner object
     */
    public Observable<ServiceResponse<NamespaceInner>> updateWithServiceResponseAsync(String resourceGroupName, String namespaceName, NamespaceUpdateParametersInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.update(resourceGroupName, namespaceName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<NamespaceInner>>>() {
                @Override
                public Observable<ServiceResponse<NamespaceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<NamespaceInner> clientResponse = updateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<NamespaceInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<NamespaceInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(201, new TypeToken<NamespaceInner>() { }.getType())
                .register(200, new TypeToken<NamespaceInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the authorization rules for a namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SharedAccessAuthorizationRuleInner&gt; object if successful.
     */
    public PagedList<SharedAccessAuthorizationRuleInner> listAuthorizationRules(final String resourceGroupName, final String namespaceName) {
        ServiceResponse<Page<SharedAccessAuthorizationRuleInner>> response = listAuthorizationRulesSinglePageAsync(resourceGroupName, namespaceName).toBlocking().single();
        return new PagedList<SharedAccessAuthorizationRuleInner>(response.body()) {
            @Override
            public Page<SharedAccessAuthorizationRuleInner> nextPage(String nextPageLink) {
                return listAuthorizationRulesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets the authorization rules for a namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SharedAccessAuthorizationRuleInner>> listAuthorizationRulesAsync(final String resourceGroupName, final String namespaceName, final ListOperationCallback<SharedAccessAuthorizationRuleInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listAuthorizationRulesSinglePageAsync(resourceGroupName, namespaceName),
            new Func1<String, Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>> call(String nextPageLink) {
                    return listAuthorizationRulesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets the authorization rules for a namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SharedAccessAuthorizationRuleInner&gt; object
     */
    public Observable<Page<SharedAccessAuthorizationRuleInner>> listAuthorizationRulesAsync(final String resourceGroupName, final String namespaceName) {
        return listAuthorizationRulesWithServiceResponseAsync(resourceGroupName, namespaceName)
            .map(new Func1<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>, Page<SharedAccessAuthorizationRuleInner>>() {
                @Override
                public Page<SharedAccessAuthorizationRuleInner> call(ServiceResponse<Page<SharedAccessAuthorizationRuleInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets the authorization rules for a namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SharedAccessAuthorizationRuleInner&gt; object
     */
    public Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>> listAuthorizationRulesWithServiceResponseAsync(final String resourceGroupName, final String namespaceName) {
        return listAuthorizationRulesSinglePageAsync(resourceGroupName, namespaceName)
            .concatMap(new Func1<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>, Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>> call(ServiceResponse<Page<SharedAccessAuthorizationRuleInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAuthorizationRulesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets the authorization rules for a namespace.
     *
    ServiceResponse<PageImpl<SharedAccessAuthorizationRuleInner>> * @param resourceGroupName Name of the Resource group within the Azure subscription.
    ServiceResponse<PageImpl<SharedAccessAuthorizationRuleInner>> * @param namespaceName The namespace name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SharedAccessAuthorizationRuleInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>> listAuthorizationRulesSinglePageAsync(final String resourceGroupName, final String namespaceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listAuthorizationRules(resourceGroupName, namespaceName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SharedAccessAuthorizationRuleInner>> result = listAuthorizationRulesDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SharedAccessAuthorizationRuleInner>> listAuthorizationRulesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SharedAccessAuthorizationRuleInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SharedAccessAuthorizationRuleInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates or updates an authorization rule for a namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param authorizationRuleName The authorizationrule name.
     * @param rights The rights associated with the rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SharedAccessAuthorizationRuleInner object if successful.
     */
    public SharedAccessAuthorizationRuleInner createOrUpdateAuthorizationRule(String resourceGroupName, String namespaceName, String authorizationRuleName, List<AccessRights> rights) {
        return createOrUpdateAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, authorizationRuleName, rights).toBlocking().single().body();
    }

    /**
     * Creates or updates an authorization rule for a namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param authorizationRuleName The authorizationrule name.
     * @param rights The rights associated with the rule.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SharedAccessAuthorizationRuleInner> createOrUpdateAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String authorizationRuleName, List<AccessRights> rights, final ServiceCallback<SharedAccessAuthorizationRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, authorizationRuleName, rights), serviceCallback);
    }

    /**
     * Creates or updates an authorization rule for a namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param authorizationRuleName The authorizationrule name.
     * @param rights The rights associated with the rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SharedAccessAuthorizationRuleInner object
     */
    public Observable<SharedAccessAuthorizationRuleInner> createOrUpdateAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String authorizationRuleName, List<AccessRights> rights) {
        return createOrUpdateAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, authorizationRuleName, rights).map(new Func1<ServiceResponse<SharedAccessAuthorizationRuleInner>, SharedAccessAuthorizationRuleInner>() {
            @Override
            public SharedAccessAuthorizationRuleInner call(ServiceResponse<SharedAccessAuthorizationRuleInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates an authorization rule for a namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param authorizationRuleName The authorizationrule name.
     * @param rights The rights associated with the rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SharedAccessAuthorizationRuleInner object
     */
    public Observable<ServiceResponse<SharedAccessAuthorizationRuleInner>> createOrUpdateAuthorizationRuleWithServiceResponseAsync(String resourceGroupName, String namespaceName, String authorizationRuleName, List<AccessRights> rights) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (authorizationRuleName == null) {
            throw new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (rights == null) {
            throw new IllegalArgumentException("Parameter rights is required and cannot be null.");
        }
        Validator.validate(rights);
        SharedAccessAuthorizationRuleInner parameters = new SharedAccessAuthorizationRuleInner();
        parameters.withRights(rights);
        return service.createOrUpdateAuthorizationRule(resourceGroupName, namespaceName, authorizationRuleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SharedAccessAuthorizationRuleInner>>>() {
                @Override
                public Observable<ServiceResponse<SharedAccessAuthorizationRuleInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SharedAccessAuthorizationRuleInner> clientResponse = createOrUpdateAuthorizationRuleDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SharedAccessAuthorizationRuleInner> createOrUpdateAuthorizationRuleDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SharedAccessAuthorizationRuleInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SharedAccessAuthorizationRuleInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a namespace authorization rule.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param authorizationRuleName The authorizationrule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteAuthorizationRule(String resourceGroupName, String namespaceName, String authorizationRuleName) {
        deleteAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, authorizationRuleName).toBlocking().single().body();
    }

    /**
     * Deletes a namespace authorization rule.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param authorizationRuleName The authorizationrule name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String authorizationRuleName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, authorizationRuleName), serviceCallback);
    }

    /**
     * Deletes a namespace authorization rule.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param authorizationRuleName The authorizationrule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String authorizationRuleName) {
        return deleteAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, authorizationRuleName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a namespace authorization rule.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param authorizationRuleName The authorizationrule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteAuthorizationRuleWithServiceResponseAsync(String resourceGroupName, String namespaceName, String authorizationRuleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (authorizationRuleName == null) {
            throw new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.deleteAuthorizationRule(resourceGroupName, namespaceName, authorizationRuleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteAuthorizationRuleDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteAuthorizationRuleDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .register(200, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets an authorization rule for a namespace by rule name.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param authorizationRuleName The authorizationrule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SharedAccessAuthorizationRuleInner object if successful.
     */
    public SharedAccessAuthorizationRuleInner getAuthorizationRule(String resourceGroupName, String namespaceName, String authorizationRuleName) {
        return getAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, authorizationRuleName).toBlocking().single().body();
    }

    /**
     * Gets an authorization rule for a namespace by rule name.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param authorizationRuleName The authorizationrule name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SharedAccessAuthorizationRuleInner> getAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String authorizationRuleName, final ServiceCallback<SharedAccessAuthorizationRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(getAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, authorizationRuleName), serviceCallback);
    }

    /**
     * Gets an authorization rule for a namespace by rule name.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param authorizationRuleName The authorizationrule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SharedAccessAuthorizationRuleInner object
     */
    public Observable<SharedAccessAuthorizationRuleInner> getAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String authorizationRuleName) {
        return getAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, authorizationRuleName).map(new Func1<ServiceResponse<SharedAccessAuthorizationRuleInner>, SharedAccessAuthorizationRuleInner>() {
            @Override
            public SharedAccessAuthorizationRuleInner call(ServiceResponse<SharedAccessAuthorizationRuleInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets an authorization rule for a namespace by rule name.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param authorizationRuleName The authorizationrule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SharedAccessAuthorizationRuleInner object
     */
    public Observable<ServiceResponse<SharedAccessAuthorizationRuleInner>> getAuthorizationRuleWithServiceResponseAsync(String resourceGroupName, String namespaceName, String authorizationRuleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (authorizationRuleName == null) {
            throw new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getAuthorizationRule(resourceGroupName, namespaceName, authorizationRuleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SharedAccessAuthorizationRuleInner>>>() {
                @Override
                public Observable<ServiceResponse<SharedAccessAuthorizationRuleInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SharedAccessAuthorizationRuleInner> clientResponse = getAuthorizationRuleDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SharedAccessAuthorizationRuleInner> getAuthorizationRuleDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SharedAccessAuthorizationRuleInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SharedAccessAuthorizationRuleInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the primary and secondary connection strings for the namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param authorizationRuleName The authorizationrule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ResourceListKeysInner object if successful.
     */
    public ResourceListKeysInner listKeys(String resourceGroupName, String namespaceName, String authorizationRuleName) {
        return listKeysWithServiceResponseAsync(resourceGroupName, namespaceName, authorizationRuleName).toBlocking().single().body();
    }

    /**
     * Gets the primary and secondary connection strings for the namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param authorizationRuleName The authorizationrule name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ResourceListKeysInner> listKeysAsync(String resourceGroupName, String namespaceName, String authorizationRuleName, final ServiceCallback<ResourceListKeysInner> serviceCallback) {
        return ServiceFuture.fromResponse(listKeysWithServiceResponseAsync(resourceGroupName, namespaceName, authorizationRuleName), serviceCallback);
    }

    /**
     * Gets the primary and secondary connection strings for the namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param authorizationRuleName The authorizationrule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ResourceListKeysInner object
     */
    public Observable<ResourceListKeysInner> listKeysAsync(String resourceGroupName, String namespaceName, String authorizationRuleName) {
        return listKeysWithServiceResponseAsync(resourceGroupName, namespaceName, authorizationRuleName).map(new Func1<ServiceResponse<ResourceListKeysInner>, ResourceListKeysInner>() {
            @Override
            public ResourceListKeysInner call(ServiceResponse<ResourceListKeysInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the primary and secondary connection strings for the namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param authorizationRuleName The authorizationrule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ResourceListKeysInner object
     */
    public Observable<ServiceResponse<ResourceListKeysInner>> listKeysWithServiceResponseAsync(String resourceGroupName, String namespaceName, String authorizationRuleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (authorizationRuleName == null) {
            throw new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listKeys(resourceGroupName, namespaceName, authorizationRuleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ResourceListKeysInner>>>() {
                @Override
                public Observable<ServiceResponse<ResourceListKeysInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ResourceListKeysInner> clientResponse = listKeysDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ResourceListKeysInner> listKeysDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ResourceListKeysInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ResourceListKeysInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Regenerates the primary or secondary connection strings for the namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param authorizationRuleName The authorizationrule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ResourceListKeysInner object if successful.
     */
    public ResourceListKeysInner regenerateKeys(String resourceGroupName, String namespaceName, String authorizationRuleName) {
        return regenerateKeysWithServiceResponseAsync(resourceGroupName, namespaceName, authorizationRuleName).toBlocking().single().body();
    }

    /**
     * Regenerates the primary or secondary connection strings for the namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param authorizationRuleName The authorizationrule name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ResourceListKeysInner> regenerateKeysAsync(String resourceGroupName, String namespaceName, String authorizationRuleName, final ServiceCallback<ResourceListKeysInner> serviceCallback) {
        return ServiceFuture.fromResponse(regenerateKeysWithServiceResponseAsync(resourceGroupName, namespaceName, authorizationRuleName), serviceCallback);
    }

    /**
     * Regenerates the primary or secondary connection strings for the namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param authorizationRuleName The authorizationrule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ResourceListKeysInner object
     */
    public Observable<ResourceListKeysInner> regenerateKeysAsync(String resourceGroupName, String namespaceName, String authorizationRuleName) {
        return regenerateKeysWithServiceResponseAsync(resourceGroupName, namespaceName, authorizationRuleName).map(new Func1<ServiceResponse<ResourceListKeysInner>, ResourceListKeysInner>() {
            @Override
            public ResourceListKeysInner call(ServiceResponse<ResourceListKeysInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Regenerates the primary or secondary connection strings for the namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param authorizationRuleName The authorizationrule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ResourceListKeysInner object
     */
    public Observable<ServiceResponse<ResourceListKeysInner>> regenerateKeysWithServiceResponseAsync(String resourceGroupName, String namespaceName, String authorizationRuleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (authorizationRuleName == null) {
            throw new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final Policykey policykey = null;
        RegenerateKeysParameters parameters = new RegenerateKeysParameters();
        parameters.withPolicykey(null);
        return service.regenerateKeys(resourceGroupName, namespaceName, authorizationRuleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ResourceListKeysInner>>>() {
                @Override
                public Observable<ServiceResponse<ResourceListKeysInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ResourceListKeysInner> clientResponse = regenerateKeysDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Regenerates the primary or secondary connection strings for the namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param authorizationRuleName The authorizationrule name.
     * @param policykey Key that needs to be regenerated. Possible values include: 'PrimaryKey', 'SecondaryKey'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ResourceListKeysInner object if successful.
     */
    public ResourceListKeysInner regenerateKeys(String resourceGroupName, String namespaceName, String authorizationRuleName, Policykey policykey) {
        return regenerateKeysWithServiceResponseAsync(resourceGroupName, namespaceName, authorizationRuleName, policykey).toBlocking().single().body();
    }

    /**
     * Regenerates the primary or secondary connection strings for the namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param authorizationRuleName The authorizationrule name.
     * @param policykey Key that needs to be regenerated. Possible values include: 'PrimaryKey', 'SecondaryKey'
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ResourceListKeysInner> regenerateKeysAsync(String resourceGroupName, String namespaceName, String authorizationRuleName, Policykey policykey, final ServiceCallback<ResourceListKeysInner> serviceCallback) {
        return ServiceFuture.fromResponse(regenerateKeysWithServiceResponseAsync(resourceGroupName, namespaceName, authorizationRuleName, policykey), serviceCallback);
    }

    /**
     * Regenerates the primary or secondary connection strings for the namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param authorizationRuleName The authorizationrule name.
     * @param policykey Key that needs to be regenerated. Possible values include: 'PrimaryKey', 'SecondaryKey'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ResourceListKeysInner object
     */
    public Observable<ResourceListKeysInner> regenerateKeysAsync(String resourceGroupName, String namespaceName, String authorizationRuleName, Policykey policykey) {
        return regenerateKeysWithServiceResponseAsync(resourceGroupName, namespaceName, authorizationRuleName, policykey).map(new Func1<ServiceResponse<ResourceListKeysInner>, ResourceListKeysInner>() {
            @Override
            public ResourceListKeysInner call(ServiceResponse<ResourceListKeysInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Regenerates the primary or secondary connection strings for the namespace.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param authorizationRuleName The authorizationrule name.
     * @param policykey Key that needs to be regenerated. Possible values include: 'PrimaryKey', 'SecondaryKey'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ResourceListKeysInner object
     */
    public Observable<ServiceResponse<ResourceListKeysInner>> regenerateKeysWithServiceResponseAsync(String resourceGroupName, String namespaceName, String authorizationRuleName, Policykey policykey) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (authorizationRuleName == null) {
            throw new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        RegenerateKeysParameters parameters = new RegenerateKeysParameters();
        parameters.withPolicykey(policykey);
        return service.regenerateKeys(resourceGroupName, namespaceName, authorizationRuleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ResourceListKeysInner>>>() {
                @Override
                public Observable<ServiceResponse<ResourceListKeysInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ResourceListKeysInner> clientResponse = regenerateKeysDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ResourceListKeysInner> regenerateKeysDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ResourceListKeysInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ResourceListKeysInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all the available namespaces within the subscription, irrespective of the resource groups.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;NamespaceInner&gt; object if successful.
     */
    public PagedList<NamespaceInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<NamespaceInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<NamespaceInner>(response.body()) {
            @Override
            public Page<NamespaceInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the available namespaces within the subscription, irrespective of the resource groups.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<NamespaceInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<NamespaceInner>> serviceFuture, final ListOperationCallback<NamespaceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<NamespaceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<NamespaceInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the available namespaces within the subscription, irrespective of the resource groups.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;NamespaceInner&gt; object
     */
    public Observable<Page<NamespaceInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<NamespaceInner>>, Page<NamespaceInner>>() {
                @Override
                public Page<NamespaceInner> call(ServiceResponse<Page<NamespaceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the available namespaces within the subscription, irrespective of the resource groups.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;NamespaceInner&gt; object
     */
    public Observable<ServiceResponse<Page<NamespaceInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<NamespaceInner>>, Observable<ServiceResponse<Page<NamespaceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<NamespaceInner>>> call(ServiceResponse<Page<NamespaceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the available namespaces within the subscription, irrespective of the resource groups.
     *
    ServiceResponse<PageImpl<NamespaceInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;NamespaceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<NamespaceInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<NamespaceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<NamespaceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<NamespaceInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<NamespaceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<NamespaceInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<NamespaceInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<NamespaceInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the available namespaces within a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;NamespaceInner&gt; object if successful.
     */
    public PagedList<NamespaceInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<NamespaceInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<NamespaceInner>(response.body()) {
            @Override
            public Page<NamespaceInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets the available namespaces within a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<NamespaceInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<NamespaceInner>> serviceFuture, final ListOperationCallback<NamespaceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<NamespaceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<NamespaceInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets the available namespaces within a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;NamespaceInner&gt; object
     */
    public Observable<Page<NamespaceInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<NamespaceInner>>, Page<NamespaceInner>>() {
                @Override
                public Page<NamespaceInner> call(ServiceResponse<Page<NamespaceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets the available namespaces within a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;NamespaceInner&gt; object
     */
    public Observable<ServiceResponse<Page<NamespaceInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<NamespaceInner>>, Observable<ServiceResponse<Page<NamespaceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<NamespaceInner>>> call(ServiceResponse<Page<NamespaceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets the available namespaces within a resource group.
     *
    ServiceResponse<PageImpl<NamespaceInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;NamespaceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<NamespaceInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<NamespaceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<NamespaceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<NamespaceInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<NamespaceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<NamespaceInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<NamespaceInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<NamespaceInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the authorization rules for a namespace.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SharedAccessAuthorizationRuleInner&gt; object if successful.
     */
    public PagedList<SharedAccessAuthorizationRuleInner> listAuthorizationRulesNext(final String nextPageLink) {
        ServiceResponse<Page<SharedAccessAuthorizationRuleInner>> response = listAuthorizationRulesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SharedAccessAuthorizationRuleInner>(response.body()) {
            @Override
            public Page<SharedAccessAuthorizationRuleInner> nextPage(String nextPageLink) {
                return listAuthorizationRulesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets the authorization rules for a namespace.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SharedAccessAuthorizationRuleInner>> listAuthorizationRulesNextAsync(final String nextPageLink, final ServiceFuture<List<SharedAccessAuthorizationRuleInner>> serviceFuture, final ListOperationCallback<SharedAccessAuthorizationRuleInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listAuthorizationRulesNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>> call(String nextPageLink) {
                    return listAuthorizationRulesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets the authorization rules for a namespace.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SharedAccessAuthorizationRuleInner&gt; object
     */
    public Observable<Page<SharedAccessAuthorizationRuleInner>> listAuthorizationRulesNextAsync(final String nextPageLink) {
        return listAuthorizationRulesNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>, Page<SharedAccessAuthorizationRuleInner>>() {
                @Override
                public Page<SharedAccessAuthorizationRuleInner> call(ServiceResponse<Page<SharedAccessAuthorizationRuleInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets the authorization rules for a namespace.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SharedAccessAuthorizationRuleInner&gt; object
     */
    public Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>> listAuthorizationRulesNextWithServiceResponseAsync(final String nextPageLink) {
        return listAuthorizationRulesNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>, Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>> call(ServiceResponse<Page<SharedAccessAuthorizationRuleInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAuthorizationRulesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets the authorization rules for a namespace.
     *
    ServiceResponse<PageImpl<SharedAccessAuthorizationRuleInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SharedAccessAuthorizationRuleInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>> listAuthorizationRulesNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listAuthorizationRulesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SharedAccessAuthorizationRuleInner>> result = listAuthorizationRulesNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SharedAccessAuthorizationRuleInner>> listAuthorizationRulesNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SharedAccessAuthorizationRuleInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SharedAccessAuthorizationRuleInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
