/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.servicebus.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in Subscriptions.
 */
public class SubscriptionsInner {
    /** The Retrofit service to perform REST calls. */
    private SubscriptionsService service;
    /** The service client containing this operation class. */
    private ServiceBusManagementClientImpl client;

    /**
     * Initializes an instance of SubscriptionsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public SubscriptionsInner(Retrofit retrofit, ServiceBusManagementClientImpl client) {
        this.service = retrofit.create(SubscriptionsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for Subscriptions to be
     * used by Retrofit to perform actually REST calls.
     */
    interface SubscriptionsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Subscriptions listByTopic" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/subscriptions")
        Observable<Response<ResponseBody>> listByTopic(@Path("resourceGroupName") String resourceGroupName, @Path("namespaceName") String namespaceName, @Path("topicName") String topicName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Subscriptions createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/subscriptions/{subscriptionName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("namespaceName") String namespaceName, @Path("topicName") String topicName, @Path("subscriptionName") String subscriptionName, @Path("subscriptionId") String subscriptionId, @Body SubscriptionInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Subscriptions delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/subscriptions/{subscriptionName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("namespaceName") String namespaceName, @Path("topicName") String topicName, @Path("subscriptionName") String subscriptionName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Subscriptions get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/subscriptions/{subscriptionName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("namespaceName") String namespaceName, @Path("topicName") String topicName, @Path("subscriptionName") String subscriptionName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.servicebus.Subscriptions listByTopicNext" })
        @GET
        Observable<Response<ResponseBody>> listByTopicNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * List all the subscriptions under a specified topic.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param topicName The topic name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SubscriptionInner&gt; object if successful.
     */
    public PagedList<SubscriptionInner> listByTopic(final String resourceGroupName, final String namespaceName, final String topicName) {
        ServiceResponse<Page<SubscriptionInner>> response = listByTopicSinglePageAsync(resourceGroupName, namespaceName, topicName).toBlocking().single();
        return new PagedList<SubscriptionInner>(response.body()) {
            @Override
            public Page<SubscriptionInner> nextPage(String nextPageLink) {
                return listByTopicNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List all the subscriptions under a specified topic.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param topicName The topic name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SubscriptionInner>> listByTopicAsync(final String resourceGroupName, final String namespaceName, final String topicName, final ListOperationCallback<SubscriptionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByTopicSinglePageAsync(resourceGroupName, namespaceName, topicName),
            new Func1<String, Observable<ServiceResponse<Page<SubscriptionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SubscriptionInner>>> call(String nextPageLink) {
                    return listByTopicNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List all the subscriptions under a specified topic.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param topicName The topic name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SubscriptionInner&gt; object
     */
    public Observable<Page<SubscriptionInner>> listByTopicAsync(final String resourceGroupName, final String namespaceName, final String topicName) {
        return listByTopicWithServiceResponseAsync(resourceGroupName, namespaceName, topicName)
            .map(new Func1<ServiceResponse<Page<SubscriptionInner>>, Page<SubscriptionInner>>() {
                @Override
                public Page<SubscriptionInner> call(ServiceResponse<Page<SubscriptionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List all the subscriptions under a specified topic.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param topicName The topic name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SubscriptionInner&gt; object
     */
    public Observable<ServiceResponse<Page<SubscriptionInner>>> listByTopicWithServiceResponseAsync(final String resourceGroupName, final String namespaceName, final String topicName) {
        return listByTopicSinglePageAsync(resourceGroupName, namespaceName, topicName)
            .concatMap(new Func1<ServiceResponse<Page<SubscriptionInner>>, Observable<ServiceResponse<Page<SubscriptionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SubscriptionInner>>> call(ServiceResponse<Page<SubscriptionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByTopicNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List all the subscriptions under a specified topic.
     *
    ServiceResponse<PageImpl<SubscriptionInner>> * @param resourceGroupName Name of the Resource group within the Azure subscription.
    ServiceResponse<PageImpl<SubscriptionInner>> * @param namespaceName The namespace name
    ServiceResponse<PageImpl<SubscriptionInner>> * @param topicName The topic name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SubscriptionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SubscriptionInner>>> listByTopicSinglePageAsync(final String resourceGroupName, final String namespaceName, final String topicName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (topicName == null) {
            throw new IllegalArgumentException("Parameter topicName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listByTopic(resourceGroupName, namespaceName, topicName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SubscriptionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SubscriptionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SubscriptionInner>> result = listByTopicDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SubscriptionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SubscriptionInner>> listByTopicDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SubscriptionInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SubscriptionInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates a topic subscription.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param topicName The topic name.
     * @param subscriptionName The subscription name.
     * @param parameters Parameters supplied to create a subscription resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SubscriptionInner object if successful.
     */
    public SubscriptionInner createOrUpdate(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, SubscriptionInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, subscriptionName, parameters).toBlocking().single().body();
    }

    /**
     * Creates a topic subscription.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param topicName The topic name.
     * @param subscriptionName The subscription name.
     * @param parameters Parameters supplied to create a subscription resource.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SubscriptionInner> createOrUpdateAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, SubscriptionInner parameters, final ServiceCallback<SubscriptionInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, subscriptionName, parameters), serviceCallback);
    }

    /**
     * Creates a topic subscription.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param topicName The topic name.
     * @param subscriptionName The subscription name.
     * @param parameters Parameters supplied to create a subscription resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SubscriptionInner object
     */
    public Observable<SubscriptionInner> createOrUpdateAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, SubscriptionInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, subscriptionName, parameters).map(new Func1<ServiceResponse<SubscriptionInner>, SubscriptionInner>() {
            @Override
            public SubscriptionInner call(ServiceResponse<SubscriptionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a topic subscription.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param topicName The topic name.
     * @param subscriptionName The subscription name.
     * @param parameters Parameters supplied to create a subscription resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SubscriptionInner object
     */
    public Observable<ServiceResponse<SubscriptionInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, SubscriptionInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (topicName == null) {
            throw new IllegalArgumentException("Parameter topicName is required and cannot be null.");
        }
        if (subscriptionName == null) {
            throw new IllegalArgumentException("Parameter subscriptionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.createOrUpdate(resourceGroupName, namespaceName, topicName, subscriptionName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SubscriptionInner>>>() {
                @Override
                public Observable<ServiceResponse<SubscriptionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SubscriptionInner> clientResponse = createOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SubscriptionInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SubscriptionInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SubscriptionInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a subscription from the specified topic.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param topicName The topic name.
     * @param subscriptionName The subscription name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String namespaceName, String topicName, String subscriptionName) {
        deleteWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, subscriptionName).toBlocking().single().body();
    }

    /**
     * Deletes a subscription from the specified topic.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param topicName The topic name.
     * @param subscriptionName The subscription name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, subscriptionName), serviceCallback);
    }

    /**
     * Deletes a subscription from the specified topic.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param topicName The topic name.
     * @param subscriptionName The subscription name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName) {
        return deleteWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, subscriptionName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a subscription from the specified topic.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param topicName The topic name.
     * @param subscriptionName The subscription name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (topicName == null) {
            throw new IllegalArgumentException("Parameter topicName is required and cannot be null.");
        }
        if (subscriptionName == null) {
            throw new IllegalArgumentException("Parameter subscriptionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.delete(resourceGroupName, namespaceName, topicName, subscriptionName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .register(200, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Returns a subscription description for the specified topic.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param topicName The topic name.
     * @param subscriptionName The subscription name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SubscriptionInner object if successful.
     */
    public SubscriptionInner get(String resourceGroupName, String namespaceName, String topicName, String subscriptionName) {
        return getWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, subscriptionName).toBlocking().single().body();
    }

    /**
     * Returns a subscription description for the specified topic.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param topicName The topic name.
     * @param subscriptionName The subscription name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SubscriptionInner> getAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, final ServiceCallback<SubscriptionInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, subscriptionName), serviceCallback);
    }

    /**
     * Returns a subscription description for the specified topic.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param topicName The topic name.
     * @param subscriptionName The subscription name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SubscriptionInner object
     */
    public Observable<SubscriptionInner> getAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName) {
        return getWithServiceResponseAsync(resourceGroupName, namespaceName, topicName, subscriptionName).map(new Func1<ServiceResponse<SubscriptionInner>, SubscriptionInner>() {
            @Override
            public SubscriptionInner call(ServiceResponse<SubscriptionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Returns a subscription description for the specified topic.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param namespaceName The namespace name
     * @param topicName The topic name.
     * @param subscriptionName The subscription name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SubscriptionInner object
     */
    public Observable<ServiceResponse<SubscriptionInner>> getWithServiceResponseAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (topicName == null) {
            throw new IllegalArgumentException("Parameter topicName is required and cannot be null.");
        }
        if (subscriptionName == null) {
            throw new IllegalArgumentException("Parameter subscriptionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.get(resourceGroupName, namespaceName, topicName, subscriptionName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SubscriptionInner>>>() {
                @Override
                public Observable<ServiceResponse<SubscriptionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SubscriptionInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SubscriptionInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SubscriptionInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SubscriptionInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * List all the subscriptions under a specified topic.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SubscriptionInner&gt; object if successful.
     */
    public PagedList<SubscriptionInner> listByTopicNext(final String nextPageLink) {
        ServiceResponse<Page<SubscriptionInner>> response = listByTopicNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SubscriptionInner>(response.body()) {
            @Override
            public Page<SubscriptionInner> nextPage(String nextPageLink) {
                return listByTopicNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List all the subscriptions under a specified topic.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SubscriptionInner>> listByTopicNextAsync(final String nextPageLink, final ServiceFuture<List<SubscriptionInner>> serviceFuture, final ListOperationCallback<SubscriptionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByTopicNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<SubscriptionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SubscriptionInner>>> call(String nextPageLink) {
                    return listByTopicNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List all the subscriptions under a specified topic.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SubscriptionInner&gt; object
     */
    public Observable<Page<SubscriptionInner>> listByTopicNextAsync(final String nextPageLink) {
        return listByTopicNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<SubscriptionInner>>, Page<SubscriptionInner>>() {
                @Override
                public Page<SubscriptionInner> call(ServiceResponse<Page<SubscriptionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List all the subscriptions under a specified topic.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SubscriptionInner&gt; object
     */
    public Observable<ServiceResponse<Page<SubscriptionInner>>> listByTopicNextWithServiceResponseAsync(final String nextPageLink) {
        return listByTopicNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<SubscriptionInner>>, Observable<ServiceResponse<Page<SubscriptionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SubscriptionInner>>> call(ServiceResponse<Page<SubscriptionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByTopicNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List all the subscriptions under a specified topic.
     *
    ServiceResponse<PageImpl<SubscriptionInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SubscriptionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SubscriptionInner>>> listByTopicNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByTopicNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SubscriptionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SubscriptionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SubscriptionInner>> result = listByTopicNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SubscriptionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SubscriptionInner>> listByTopicNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SubscriptionInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SubscriptionInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
