/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql;

import java.util.Collection;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.microsoft.rest.ExpandableStringEnum;

/**
 * Defines values for DatabaseEdition.
 */
public final class DatabaseEditions extends ExpandableStringEnum<DatabaseEditions> {
    /** Static value Web for DatabaseEdition. */
    public static final DatabaseEditions WEB = fromString("Web");

    /** Static value Business for DatabaseEdition. */
    public static final DatabaseEditions BUSINESS = fromString("Business");

    /** Static value Basic for DatabaseEdition. */
    public static final DatabaseEditions BASIC = fromString("Basic");

    /** Static value Standard for DatabaseEdition. */
    public static final DatabaseEditions STANDARD = fromString("Standard");

    /** Static value Premium for DatabaseEdition. */
    public static final DatabaseEditions PREMIUM = fromString("Premium");

    /** Static value PremiumRS for DatabaseEdition. */
    public static final DatabaseEditions PREMIUM_RS = fromString("PremiumRS");

    /** Static value Free for DatabaseEdition. */
    public static final DatabaseEditions FREE = fromString("Free");

    /** Static value Stretch for DatabaseEdition. */
    public static final DatabaseEditions STRETCH = fromString("Stretch");

    /** Static value DataWarehouse for DatabaseEdition. */
    public static final DatabaseEditions DATA_WAREHOUSE = fromString("DataWarehouse");

    /** Static value System for DatabaseEdition. */
    public static final DatabaseEditions SYSTEM = fromString("System");

    /** Static value System2 for DatabaseEdition. */
    public static final DatabaseEditions SYSTEM2 = fromString("System2");

    /**
     * Creates or finds a DatabaseEdition from its string representation.
     * @param name a name to look for
     * @return the corresponding DatabaseEdition
     */
    @JsonCreator
    public static DatabaseEditions fromString(String name) {
        return fromString(name, DatabaseEditions.class);
    }

    /**
     * @return known DatabaseEdition values
     */
    public static Collection<DatabaseEditions> values() {
        return values(DatabaseEditions.class);
    }
}
