/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql;

import org.joda.time.DateTime;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Scheduling properties of a job.
 */
public class JobSchedule {
    /**
     * Schedule start time.
     */
    @JsonProperty(value = "startTime")
    private DateTime startTime;

    /**
     * Schedule end time.
     */
    @JsonProperty(value = "endTime")
    private DateTime endTime;

    /**
     * Schedule interval type. Possible values include: 'Once', 'Recurring'.
     */
    @JsonProperty(value = "type")
    private JobScheduleType type;

    /**
     * Whether or not the schedule is enabled.
     */
    @JsonProperty(value = "enabled")
    private Boolean enabled;

    /**
     * Value of the schedule's recurring interval, if the scheduletype is
     * recurring. ISO8601 duration format.
     */
    @JsonProperty(value = "interval")
    private String interval;

    /**
     * Get the startTime value.
     *
     * @return the startTime value
     */
    public DateTime startTime() {
        return this.startTime;
    }

    /**
     * Set the startTime value.
     *
     * @param startTime the startTime value to set
     * @return the JobSchedule object itself.
     */
    public JobSchedule withStartTime(DateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the endTime value.
     *
     * @return the endTime value
     */
    public DateTime endTime() {
        return this.endTime;
    }

    /**
     * Set the endTime value.
     *
     * @param endTime the endTime value to set
     * @return the JobSchedule object itself.
     */
    public JobSchedule withEndTime(DateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    /**
     * Get the type value.
     *
     * @return the type value
     */
    public JobScheduleType type() {
        return this.type;
    }

    /**
     * Set the type value.
     *
     * @param type the type value to set
     * @return the JobSchedule object itself.
     */
    public JobSchedule withType(JobScheduleType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the enabled value.
     *
     * @return the enabled value
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled value.
     *
     * @param enabled the enabled value to set
     * @return the JobSchedule object itself.
     */
    public JobSchedule withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the interval value.
     *
     * @return the interval value
     */
    public String interval() {
        return this.interval;
    }

    /**
     * Set the interval value.
     *
     * @param interval the interval value to set
     * @return the JobSchedule object itself.
     */
    public JobSchedule withInterval(String interval) {
        this.interval = interval;
        return this;
    }

}
