/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.sql.AutomaticTuningServerMode;
import java.util.Map;
import com.microsoft.azure.management.sql.AutomaticTuningServerOptions;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * Server-level Automatic Tuning.
 */
@JsonFlatten
public class ServerAutomaticTuningInner extends ProxyResourceInner {
    /**
     * Automatic tuning desired state. Possible values include: 'Custom',
     * 'Auto', 'Unspecified'.
     */
    @JsonProperty(value = "properties.desiredState")
    private AutomaticTuningServerMode desiredState;

    /**
     * Automatic tuning actual state. Possible values include: 'Custom',
     * 'Auto', 'Unspecified'.
     */
    @JsonProperty(value = "properties.actualState", access = JsonProperty.Access.WRITE_ONLY)
    private AutomaticTuningServerMode actualState;

    /**
     * Automatic tuning options definition.
     */
    @JsonProperty(value = "properties.options")
    private Map<String, AutomaticTuningServerOptions> options;

    /**
     * Get the desiredState value.
     *
     * @return the desiredState value
     */
    public AutomaticTuningServerMode desiredState() {
        return this.desiredState;
    }

    /**
     * Set the desiredState value.
     *
     * @param desiredState the desiredState value to set
     * @return the ServerAutomaticTuningInner object itself.
     */
    public ServerAutomaticTuningInner withDesiredState(AutomaticTuningServerMode desiredState) {
        this.desiredState = desiredState;
        return this;
    }

    /**
     * Get the actualState value.
     *
     * @return the actualState value
     */
    public AutomaticTuningServerMode actualState() {
        return this.actualState;
    }

    /**
     * Get the options value.
     *
     * @return the options value
     */
    public Map<String, AutomaticTuningServerOptions> options() {
        return this.options;
    }

    /**
     * Set the options value.
     *
     * @param options the options value to set
     * @return the ServerAutomaticTuningInner object itself.
     */
    public ServerAutomaticTuningInner withOptions(Map<String, AutomaticTuningServerOptions> options) {
        this.options = options;
        return this;
    }

}
