/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.sql.SyncMemberDbType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * An Azure SQL Database sync agent linked database.
 */
@JsonFlatten
public class SyncAgentLinkedDatabaseInner extends ProxyResourceInner {
    /**
     * Type of the sync agent linked database. Possible values include:
     * 'AzureSqlDatabase', 'SqlServerDatabase'.
     */
    @JsonProperty(value = "properties.databaseType", access = JsonProperty.Access.WRITE_ONLY)
    private SyncMemberDbType databaseType;

    /**
     * Id of the sync agent linked database.
     */
    @JsonProperty(value = "properties.databaseId", access = JsonProperty.Access.WRITE_ONLY)
    private String databaseId;

    /**
     * Description of the sync agent linked database.
     */
    @JsonProperty(value = "properties.description", access = JsonProperty.Access.WRITE_ONLY)
    private String description;

    /**
     * Server name of the sync agent linked database.
     */
    @JsonProperty(value = "properties.serverName", access = JsonProperty.Access.WRITE_ONLY)
    private String serverName;

    /**
     * Database name of the sync agent linked database.
     */
    @JsonProperty(value = "properties.databaseName", access = JsonProperty.Access.WRITE_ONLY)
    private String databaseName;

    /**
     * User name of the sync agent linked database.
     */
    @JsonProperty(value = "properties.userName", access = JsonProperty.Access.WRITE_ONLY)
    private String userName;

    /**
     * Get the databaseType value.
     *
     * @return the databaseType value
     */
    public SyncMemberDbType databaseType() {
        return this.databaseType;
    }

    /**
     * Get the databaseId value.
     *
     * @return the databaseId value
     */
    public String databaseId() {
        return this.databaseId;
    }

    /**
     * Get the description value.
     *
     * @return the description value
     */
    public String description() {
        return this.description;
    }

    /**
     * Get the serverName value.
     *
     * @return the serverName value
     */
    public String serverName() {
        return this.serverName;
    }

    /**
     * Get the databaseName value.
     *
     * @return the databaseName value
     */
    public String databaseName() {
        return this.databaseName;
    }

    /**
     * Get the userName value.
     *
     * @return the userName value
     */
    public String userName() {
        return this.userName;
    }

}
