/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.sql.GeoBackupPolicyState;
import com.microsoft.azure.management.sql.implementation.GeoBackupPolicyInner;
import com.microsoft.azure.management.sql.implementation.PageImpl;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class GeoBackupPoliciesInner {
    private GeoBackupPoliciesService service;
    private SqlManagementClientImpl client;

    public GeoBackupPoliciesInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (GeoBackupPoliciesService)retrofit.create(GeoBackupPoliciesService.class);
        this.client = client;
    }

    public GeoBackupPolicyInner createOrUpdate(String resourceGroupName, String serverName, String databaseName, GeoBackupPolicyState state) {
        return (GeoBackupPolicyInner)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, state).toBlocking().single()).body();
    }

    public ServiceFuture<GeoBackupPolicyInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, GeoBackupPolicyState state, ServiceCallback<GeoBackupPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, state), serviceCallback);
    }

    public Observable<GeoBackupPolicyInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, GeoBackupPolicyState state) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, state).map((Func1)new Func1<ServiceResponse<GeoBackupPolicyInner>, GeoBackupPolicyInner>(){

            public GeoBackupPolicyInner call(ServiceResponse<GeoBackupPolicyInner> response) {
                return (GeoBackupPolicyInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<GeoBackupPolicyInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, GeoBackupPolicyState state) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (state == null) {
            throw new IllegalArgumentException("Parameter state is required and cannot be null.");
        }
        String geoBackupPolicyName = "Default";
        String apiVersion = "2014-04-01";
        GeoBackupPolicyInner parameters = new GeoBackupPolicyInner();
        parameters.withState(state);
        return this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, serverName, databaseName, "Default", "2014-04-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<GeoBackupPolicyInner>>>(){

            public Observable<ServiceResponse<GeoBackupPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GeoBackupPoliciesInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<GeoBackupPolicyInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GeoBackupPolicyInner>(){}.getType()).register(201, new TypeToken<GeoBackupPolicyInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public GeoBackupPolicyInner get(String resourceGroupName, String serverName, String databaseName) {
        return (GeoBackupPolicyInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName).toBlocking().single()).body();
    }

    public ServiceFuture<GeoBackupPolicyInner> getAsync(String resourceGroupName, String serverName, String databaseName, ServiceCallback<GeoBackupPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName), serviceCallback);
    }

    public Observable<GeoBackupPolicyInner> getAsync(String resourceGroupName, String serverName, String databaseName) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName).map((Func1)new Func1<ServiceResponse<GeoBackupPolicyInner>, GeoBackupPolicyInner>(){

            public GeoBackupPolicyInner call(ServiceResponse<GeoBackupPolicyInner> response) {
                return (GeoBackupPolicyInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<GeoBackupPolicyInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        String geoBackupPolicyName = "Default";
        String apiVersion = "2014-04-01";
        return this.service.get(this.client.subscriptionId(), resourceGroupName, serverName, databaseName, "Default", "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<GeoBackupPolicyInner>>>(){

            public Observable<ServiceResponse<GeoBackupPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GeoBackupPoliciesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<GeoBackupPolicyInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GeoBackupPolicyInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<GeoBackupPolicyInner> listByDatabase(String resourceGroupName, String serverName, String databaseName) {
        return (List)((ServiceResponse)this.listByDatabaseWithServiceResponseAsync(resourceGroupName, serverName, databaseName).toBlocking().single()).body();
    }

    public ServiceFuture<List<GeoBackupPolicyInner>> listByDatabaseAsync(String resourceGroupName, String serverName, String databaseName, ServiceCallback<List<GeoBackupPolicyInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByDatabaseWithServiceResponseAsync(resourceGroupName, serverName, databaseName), serviceCallback);
    }

    public Observable<List<GeoBackupPolicyInner>> listByDatabaseAsync(String resourceGroupName, String serverName, String databaseName) {
        return this.listByDatabaseWithServiceResponseAsync(resourceGroupName, serverName, databaseName).map((Func1)new Func1<ServiceResponse<List<GeoBackupPolicyInner>>, List<GeoBackupPolicyInner>>(){

            public List<GeoBackupPolicyInner> call(ServiceResponse<List<GeoBackupPolicyInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<GeoBackupPolicyInner>>> listByDatabaseWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        return this.service.listByDatabase(this.client.subscriptionId(), resourceGroupName, serverName, databaseName, "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<GeoBackupPolicyInner>>>>(){

            public Observable<ServiceResponse<List<GeoBackupPolicyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = GeoBackupPoliciesInner.this.listByDatabaseDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<GeoBackupPolicyInner>> listByDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<GeoBackupPolicyInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface GeoBackupPoliciesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.GeoBackupPolicies createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/geoBackupPolicies/{geoBackupPolicyName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="databaseName") String var4, @Path(value="geoBackupPolicyName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Body GeoBackupPolicyInner var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.GeoBackupPolicies get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/geoBackupPolicies/{geoBackupPolicyName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="databaseName") String var4, @Path(value="geoBackupPolicyName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.GeoBackupPolicies listByDatabase"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/geoBackupPolicies")
        public Observable<Response<ResponseBody>> listByDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);
    }
}

