/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.azure.management.sql.SqlSyncGroup;
import com.microsoft.azure.management.sql.SqlSyncGroupOperations;
import com.microsoft.azure.management.sql.implementation.SqlDatabaseImpl;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import com.microsoft.azure.management.sql.implementation.SqlSyncGroupImpl;
import com.microsoft.azure.management.sql.implementation.SyncDatabaseIdPropertiesInner;
import com.microsoft.azure.management.sql.implementation.SyncGroupInner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class SqlSyncGroupOperationsImpl
implements SqlSyncGroupOperations,
SqlSyncGroupOperations.SqlSyncGroupActionsDefinition {
    protected SqlServerManager sqlServerManager;
    protected String resourceGroupName;
    protected String sqlServerName;
    protected String sqlDatabaseName;
    protected SqlDatabaseImpl sqlDatabase;

    SqlSyncGroupOperationsImpl(SqlDatabaseImpl parent, SqlServerManager sqlServerManager) {
        Objects.requireNonNull(parent);
        Objects.requireNonNull(sqlServerManager);
        this.sqlDatabase = parent;
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName;
        this.sqlServerName = parent.sqlServerName;
        this.sqlDatabaseName = parent.name();
    }

    SqlSyncGroupOperationsImpl(SqlServerManager sqlServerManager) {
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
    }

    @Override
    public SqlSyncGroup getBySqlServer(String resourceGroupName, String sqlServerName, String databaseName, String name) {
        SyncGroupInner syncGroupInner = ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncGroups().get(resourceGroupName, sqlServerName, databaseName, name);
        return syncGroupInner != null ? new SqlSyncGroupImpl(resourceGroupName, sqlServerName, databaseName, name, syncGroupInner, this.sqlServerManager) : null;
    }

    @Override
    public Observable<SqlSyncGroup> getBySqlServerAsync(final String resourceGroupName, final String sqlServerName, final String databaseName, final String name) {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncGroups().getAsync(resourceGroupName, sqlServerName, databaseName, name).map((Func1)new Func1<SyncGroupInner, SqlSyncGroup>(){

            public SqlSyncGroup call(SyncGroupInner syncGroupInner) {
                return new SqlSyncGroupImpl(resourceGroupName, sqlServerName, databaseName, name, syncGroupInner, SqlSyncGroupOperationsImpl.this.sqlServerManager);
            }
        });
    }

    @Override
    public PagedList<String> listSyncDatabaseIds(String locationName) {
        SqlSyncGroupOperationsImpl self = this;
        PagedListConverter<SyncDatabaseIdPropertiesInner, String> converter = new PagedListConverter<SyncDatabaseIdPropertiesInner, String>(){

            public Observable<String> typeConvertAsync(SyncDatabaseIdPropertiesInner inner) {
                return Observable.just((Object)inner.id());
            }
        };
        return converter.convert(((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncGroups().listSyncDatabaseIds(locationName));
    }

    @Override
    public Observable<String> listSyncDatabaseIdsAsync(String locationName) {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncGroups().listSyncDatabaseIdsAsync(locationName).flatMap((Func1)new Func1<Page<SyncDatabaseIdPropertiesInner>, Observable<SyncDatabaseIdPropertiesInner>>(){

            public Observable<SyncDatabaseIdPropertiesInner> call(Page<SyncDatabaseIdPropertiesInner> syncDatabaseIdPropertiesInnerPage) {
                return Observable.from((Iterable)syncDatabaseIdPropertiesInnerPage.items());
            }
        }).map((Func1)new Func1<SyncDatabaseIdPropertiesInner, String>(){

            public String call(SyncDatabaseIdPropertiesInner syncDatabaseIdPropertiesInner) {
                return syncDatabaseIdPropertiesInner.id();
            }
        });
    }

    @Override
    public PagedList<String> listSyncDatabaseIds(Region region) {
        return this.listSyncDatabaseIds(region.name());
    }

    @Override
    public Observable<String> listSyncDatabaseIdsAsync(Region region) {
        return this.listSyncDatabaseIdsAsync(region.name());
    }

    @Override
    public SqlSyncGroupImpl define(String name) {
        SqlSyncGroupImpl result = new SqlSyncGroupImpl(name, new SyncGroupInner(), this.sqlServerManager);
        result.setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeCreated);
        return this.sqlDatabase != null ? result.withExistingSqlDatabase(this.sqlDatabase) : result;
    }

    @Override
    public SqlSyncGroup get(String name) {
        if (this.sqlDatabase == null) {
            return null;
        }
        return this.getBySqlServer(this.sqlDatabase.resourceGroupName(), this.sqlDatabase.sqlServerName(), this.sqlDatabase.name(), name);
    }

    @Override
    public Observable<SqlSyncGroup> getAsync(String name) {
        if (this.sqlDatabase == null) {
            return null;
        }
        return this.getBySqlServerAsync(this.sqlDatabase.resourceGroupName(), this.sqlDatabase.sqlServerName(), this.sqlDatabase.name(), name);
    }

    @Override
    public SqlSyncGroup getById(String id) {
        Objects.requireNonNull(id);
        try {
            ResourceId resourceId = ResourceId.fromString((String)id);
            return this.getBySqlServer(resourceId.resourceGroupName(), resourceId.parent().parent().name(), resourceId.parent().name(), resourceId.name());
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    @Override
    public Observable<SqlSyncGroup> getByIdAsync(String id) {
        Objects.requireNonNull(id);
        try {
            ResourceId resourceId = ResourceId.fromString((String)id);
            return this.getBySqlServerAsync(resourceId.resourceGroupName(), resourceId.parent().parent().name(), resourceId.parent().name(), resourceId.name());
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    @Override
    public void delete(String name) {
        if (this.sqlDatabase == null) {
            return;
        }
        ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncGroups().delete(this.sqlDatabase.resourceGroupName(), this.sqlDatabase.sqlServerName(), this.sqlDatabase.name(), name);
    }

    @Override
    public Completable deleteAsync(String name) {
        if (this.sqlDatabase == null) {
            return null;
        }
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncGroups().deleteAsync(this.sqlDatabase.resourceGroupName(), this.sqlDatabase.sqlServerName(), this.sqlDatabase.name(), name).toCompletable();
    }

    @Override
    public void deleteById(String id) {
        Objects.requireNonNull(id);
        try {
            ResourceId resourceId = ResourceId.fromString((String)id);
            ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncGroups().delete(resourceId.resourceGroupName(), resourceId.parent().parent().name(), resourceId.parent().name(), resourceId.name());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public Completable deleteByIdAsync(String id) {
        try {
            ResourceId resourceId = ResourceId.fromString((String)id);
            return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncGroups().deleteAsync(resourceId.resourceGroupName(), resourceId.parent().parent().name(), resourceId.parent().name(), resourceId.name()).toCompletable();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    @Override
    public List<SqlSyncGroup> list() {
        PagedList<SyncGroupInner> syncGroupInners;
        ArrayList<SqlSyncGroupImpl> sqlSyncGroups = new ArrayList<SqlSyncGroupImpl>();
        if (this.sqlDatabase != null && (syncGroupInners = ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncGroups().listByDatabase(this.sqlDatabase.resourceGroupName(), this.sqlDatabase.sqlServerName(), this.sqlDatabase.name())) != null) {
            for (SyncGroupInner groupInner : syncGroupInners) {
                sqlSyncGroups.add(new SqlSyncGroupImpl(groupInner.name(), this.sqlDatabase, groupInner, this.sqlServerManager));
            }
        }
        return Collections.unmodifiableList(sqlSyncGroups);
    }

    @Override
    public Observable<SqlSyncGroup> listAsync() {
        final SqlSyncGroupOperationsImpl self = this;
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncGroups().listByDatabaseAsync(this.sqlDatabase.resourceGroupName(), this.sqlDatabase.sqlServerName(), this.sqlDatabase.name()).flatMap((Func1)new Func1<Page<SyncGroupInner>, Observable<SyncGroupInner>>(){

            public Observable<SyncGroupInner> call(Page<SyncGroupInner> syncGroupInnerPage) {
                return Observable.from((Iterable)syncGroupInnerPage.items());
            }
        }).map((Func1)new Func1<SyncGroupInner, SqlSyncGroup>(){

            public SqlSyncGroup call(SyncGroupInner syncGroupInner) {
                return new SqlSyncGroupImpl(syncGroupInner.name(), self.sqlDatabase, syncGroupInner, self.sqlServerManager);
            }
        });
    }
}

