/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Properties of a Vulnerability Assessment recurring scans.
 */
public class VulnerabilityAssessmentRecurringScansProperties {
    /**
     * Recurring scans state.
     */
    @JsonProperty(value = "isEnabled")
    private Boolean isEnabled;

    /**
     * Specifies that the schedule scan notification will be is sent to the
     * subscription administrators.
     */
    @JsonProperty(value = "emailSubscriptionAdmins")
    private Boolean emailSubscriptionAdmins;

    /**
     * Specifies an array of e-mail addresses to which the scan notification is
     * sent.
     */
    @JsonProperty(value = "emails")
    private List<String> emails;

    /**
     * Get the isEnabled value.
     *
     * @return the isEnabled value
     */
    public Boolean isEnabled() {
        return this.isEnabled;
    }

    /**
     * Set the isEnabled value.
     *
     * @param isEnabled the isEnabled value to set
     * @return the VulnerabilityAssessmentRecurringScansProperties object itself.
     */
    public VulnerabilityAssessmentRecurringScansProperties withIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    /**
     * Get the emailSubscriptionAdmins value.
     *
     * @return the emailSubscriptionAdmins value
     */
    public Boolean emailSubscriptionAdmins() {
        return this.emailSubscriptionAdmins;
    }

    /**
     * Set the emailSubscriptionAdmins value.
     *
     * @param emailSubscriptionAdmins the emailSubscriptionAdmins value to set
     * @return the VulnerabilityAssessmentRecurringScansProperties object itself.
     */
    public VulnerabilityAssessmentRecurringScansProperties withEmailSubscriptionAdmins(Boolean emailSubscriptionAdmins) {
        this.emailSubscriptionAdmins = emailSubscriptionAdmins;
        return this;
    }

    /**
     * Get the emails value.
     *
     * @return the emails value
     */
    public List<String> emails() {
        return this.emails;
    }

    /**
     * Set the emails value.
     *
     * @param emails the emails value to set
     * @return the VulnerabilityAssessmentRecurringScansProperties object itself.
     */
    public VulnerabilityAssessmentRecurringScansProperties withEmails(List<String> emails) {
        this.emails = emails;
        return this;
    }

}
