/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.sql.ManagedDatabaseStatus;
import org.joda.time.DateTime;
import com.microsoft.azure.management.sql.CatalogCollationType;
import com.microsoft.azure.management.sql.ManagedDatabaseCreateMode;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * A managed database resource.
 */
@JsonFlatten
public class ManagedDatabaseInner extends TrackedResourceInner {
    /**
     * Collation of the managed database.
     */
    @JsonProperty(value = "properties.collation")
    private String collation;

    /**
     * Status for the database. Possible values include: 'Online', 'Offline',
     * 'Shutdown', 'Creating', 'Inaccessible'.
     */
    @JsonProperty(value = "properties.status", access = JsonProperty.Access.WRITE_ONLY)
    private ManagedDatabaseStatus status;

    /**
     * Creation date of the database.
     */
    @JsonProperty(value = "properties.creationDate", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime creationDate;

    /**
     * Earliest restore point in time for point in time restore.
     */
    @JsonProperty(value = "properties.earliestRestorePoint", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime earliestRestorePoint;

    /**
     * Conditional. If createMode is PointInTimeRestore, this value is
     * required. Specifies the point in time (ISO8601 format) of the source
     * database that will be restored to create the new database.
     */
    @JsonProperty(value = "properties.restorePointInTime")
    private DateTime restorePointInTime;

    /**
     * Geo paired region.
     */
    @JsonProperty(value = "properties.defaultSecondaryLocation", access = JsonProperty.Access.WRITE_ONLY)
    private String defaultSecondaryLocation;

    /**
     * Collation of the metadata catalog. Possible values include:
     * 'DATABASE_DEFAULT', 'SQL_Latin1_General_CP1_CI_AS'.
     */
    @JsonProperty(value = "properties.catalogCollation")
    private CatalogCollationType catalogCollation;

    /**
     * Managed database create mode. PointInTimeRestore: Create a database by
     * restoring a point in time backup of an existing database.
     * SourceDatabaseName, SourceManagedInstanceName and PointInTime must be
     * specified. RestoreExternalBackup: Create a database by restoring from
     * external backup files. Collation, StorageContainerUri and
     * StorageContainerSasToken must be specified. Possible values include:
     * 'Default', 'RestoreExternalBackup', 'PointInTimeRestore'.
     */
    @JsonProperty(value = "properties.createMode")
    private ManagedDatabaseCreateMode createMode;

    /**
     * Conditional. If createMode is RestoreExternalBackup, this value is
     * required. Specifies the uri of the storage container where backups for
     * this restore are stored.
     */
    @JsonProperty(value = "properties.storageContainerUri")
    private String storageContainerUri;

    /**
     * The resource identifier of the source database associated with create
     * operation of this database.
     */
    @JsonProperty(value = "properties.sourceDatabaseId")
    private String sourceDatabaseId;

    /**
     * Conditional. If createMode is RestoreExternalBackup, this value is
     * required. Specifies the storage container sas token.
     */
    @JsonProperty(value = "properties.storageContainerSasToken")
    private String storageContainerSasToken;

    /**
     * Instance Failover Group resource identifier that this managed database
     * belongs to.
     */
    @JsonProperty(value = "properties.failoverGroupId", access = JsonProperty.Access.WRITE_ONLY)
    private String failoverGroupId;

    /**
     * Get the collation value.
     *
     * @return the collation value
     */
    public String collation() {
        return this.collation;
    }

    /**
     * Set the collation value.
     *
     * @param collation the collation value to set
     * @return the ManagedDatabaseInner object itself.
     */
    public ManagedDatabaseInner withCollation(String collation) {
        this.collation = collation;
        return this;
    }

    /**
     * Get the status value.
     *
     * @return the status value
     */
    public ManagedDatabaseStatus status() {
        return this.status;
    }

    /**
     * Get the creationDate value.
     *
     * @return the creationDate value
     */
    public DateTime creationDate() {
        return this.creationDate;
    }

    /**
     * Get the earliestRestorePoint value.
     *
     * @return the earliestRestorePoint value
     */
    public DateTime earliestRestorePoint() {
        return this.earliestRestorePoint;
    }

    /**
     * Get the restorePointInTime value.
     *
     * @return the restorePointInTime value
     */
    public DateTime restorePointInTime() {
        return this.restorePointInTime;
    }

    /**
     * Set the restorePointInTime value.
     *
     * @param restorePointInTime the restorePointInTime value to set
     * @return the ManagedDatabaseInner object itself.
     */
    public ManagedDatabaseInner withRestorePointInTime(DateTime restorePointInTime) {
        this.restorePointInTime = restorePointInTime;
        return this;
    }

    /**
     * Get the defaultSecondaryLocation value.
     *
     * @return the defaultSecondaryLocation value
     */
    public String defaultSecondaryLocation() {
        return this.defaultSecondaryLocation;
    }

    /**
     * Get the catalogCollation value.
     *
     * @return the catalogCollation value
     */
    public CatalogCollationType catalogCollation() {
        return this.catalogCollation;
    }

    /**
     * Set the catalogCollation value.
     *
     * @param catalogCollation the catalogCollation value to set
     * @return the ManagedDatabaseInner object itself.
     */
    public ManagedDatabaseInner withCatalogCollation(CatalogCollationType catalogCollation) {
        this.catalogCollation = catalogCollation;
        return this;
    }

    /**
     * Get the createMode value.
     *
     * @return the createMode value
     */
    public ManagedDatabaseCreateMode createMode() {
        return this.createMode;
    }

    /**
     * Set the createMode value.
     *
     * @param createMode the createMode value to set
     * @return the ManagedDatabaseInner object itself.
     */
    public ManagedDatabaseInner withCreateMode(ManagedDatabaseCreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    /**
     * Get the storageContainerUri value.
     *
     * @return the storageContainerUri value
     */
    public String storageContainerUri() {
        return this.storageContainerUri;
    }

    /**
     * Set the storageContainerUri value.
     *
     * @param storageContainerUri the storageContainerUri value to set
     * @return the ManagedDatabaseInner object itself.
     */
    public ManagedDatabaseInner withStorageContainerUri(String storageContainerUri) {
        this.storageContainerUri = storageContainerUri;
        return this;
    }

    /**
     * Get the sourceDatabaseId value.
     *
     * @return the sourceDatabaseId value
     */
    public String sourceDatabaseId() {
        return this.sourceDatabaseId;
    }

    /**
     * Set the sourceDatabaseId value.
     *
     * @param sourceDatabaseId the sourceDatabaseId value to set
     * @return the ManagedDatabaseInner object itself.
     */
    public ManagedDatabaseInner withSourceDatabaseId(String sourceDatabaseId) {
        this.sourceDatabaseId = sourceDatabaseId;
        return this;
    }

    /**
     * Get the storageContainerSasToken value.
     *
     * @return the storageContainerSasToken value
     */
    public String storageContainerSasToken() {
        return this.storageContainerSasToken;
    }

    /**
     * Set the storageContainerSasToken value.
     *
     * @param storageContainerSasToken the storageContainerSasToken value to set
     * @return the ManagedDatabaseInner object itself.
     */
    public ManagedDatabaseInner withStorageContainerSasToken(String storageContainerSasToken) {
        this.storageContainerSasToken = storageContainerSasToken;
        return this;
    }

    /**
     * Get the failoverGroupId value.
     *
     * @return the failoverGroupId value
     */
    public String failoverGroupId() {
        return this.failoverGroupId;
    }

}
