/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.sql.implementation.LocationCapabilitiesInner;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class CapabilitiesInner {
    private CapabilitiesService service;
    private SqlManagementClientImpl client;

    public CapabilitiesInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (CapabilitiesService)retrofit.create(CapabilitiesService.class);
        this.client = client;
    }

    public LocationCapabilitiesInner listByLocation(String locationId) {
        return (LocationCapabilitiesInner)((ServiceResponse)this.listByLocationWithServiceResponseAsync(locationId).toBlocking().single()).body();
    }

    public ServiceFuture<LocationCapabilitiesInner> listByLocationAsync(String locationId, ServiceCallback<LocationCapabilitiesInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByLocationWithServiceResponseAsync(locationId), serviceCallback);
    }

    public Observable<LocationCapabilitiesInner> listByLocationAsync(String locationId) {
        return this.listByLocationWithServiceResponseAsync(locationId).map((Func1)new Func1<ServiceResponse<LocationCapabilitiesInner>, LocationCapabilitiesInner>(){

            public LocationCapabilitiesInner call(ServiceResponse<LocationCapabilitiesInner> response) {
                return (LocationCapabilitiesInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<LocationCapabilitiesInner>> listByLocationWithServiceResponseAsync(String locationId) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (locationId == null) {
            throw new IllegalArgumentException("Parameter locationId is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        return this.service.listByLocation(this.client.subscriptionId(), locationId, "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<LocationCapabilitiesInner>>>(){

            public Observable<ServiceResponse<LocationCapabilitiesInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CapabilitiesInner.this.listByLocationDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<LocationCapabilitiesInner> listByLocationDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<LocationCapabilitiesInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface CapabilitiesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.Capabilities listByLocation"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationId}/capabilities")
        public Observable<Response<ResponseBody>> listByLocation(@Path(value="subscriptionId") String var1, @Path(value="locationId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);
    }
}

