/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.sql.DatabaseEditions;
import com.microsoft.azure.management.sql.ServiceObjectiveName;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Import database parameters.
 */
public class ImportRequestInner extends ExportRequestInner {
    /**
     * The name of the database to import.
     */
    @JsonProperty(value = "databaseName", required = true)
    private String databaseName;

    /**
     * The edition for the database being created. Possible values include:
     * 'Web', 'Business', 'Basic', 'Standard', 'Premium', 'PremiumRS', 'Free',
     * 'Stretch', 'DataWarehouse', 'System', 'System2'.
     */
    @JsonProperty(value = "edition", required = true)
    private DatabaseEditions edition;

    /**
     * The name of the service objective to assign to the database. Possible
     * values include: 'System', 'System0', 'System1', 'System2', 'System3',
     * 'System4', 'System2L', 'System3L', 'System4L', 'Free', 'Basic', 'S0',
     * 'S1', 'S2', 'S3', 'S4', 'S6', 'S7', 'S9', 'S12', 'P1', 'P2', 'P3', 'P4',
     * 'P6', 'P11', 'P15', 'PRS1', 'PRS2', 'PRS4', 'PRS6', 'DW100', 'DW200',
     * 'DW300', 'DW400', 'DW500', 'DW600', 'DW1000', 'DW1200', 'DW1000c',
     * 'DW1500', 'DW1500c', 'DW2000', 'DW2000c', 'DW3000', 'DW2500c',
     * 'DW3000c', 'DW6000', 'DW5000c', 'DW6000c', 'DW7500c', 'DW10000c',
     * 'DW15000c', 'DW30000c', 'DS100', 'DS200', 'DS300', 'DS400', 'DS500',
     * 'DS600', 'DS1000', 'DS1200', 'DS1500', 'DS2000', 'ElasticPool'.
     */
    @JsonProperty(value = "serviceObjectiveName", required = true)
    private ServiceObjectiveName serviceObjectiveName;

    /**
     * The maximum size for the newly imported database.
     */
    @JsonProperty(value = "maxSizeBytes", required = true)
    private String maxSizeBytes;

    /**
     * Get the databaseName value.
     *
     * @return the databaseName value
     */
    public String databaseName() {
        return this.databaseName;
    }

    /**
     * Set the databaseName value.
     *
     * @param databaseName the databaseName value to set
     * @return the ImportRequestInner object itself.
     */
    public ImportRequestInner withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    /**
     * Get the edition value.
     *
     * @return the edition value
     */
    public DatabaseEditions edition() {
        return this.edition;
    }

    /**
     * Set the edition value.
     *
     * @param edition the edition value to set
     * @return the ImportRequestInner object itself.
     */
    public ImportRequestInner withEdition(DatabaseEditions edition) {
        this.edition = edition;
        return this;
    }

    /**
     * Get the serviceObjectiveName value.
     *
     * @return the serviceObjectiveName value
     */
    public ServiceObjectiveName serviceObjectiveName() {
        return this.serviceObjectiveName;
    }

    /**
     * Set the serviceObjectiveName value.
     *
     * @param serviceObjectiveName the serviceObjectiveName value to set
     * @return the ImportRequestInner object itself.
     */
    public ImportRequestInner withServiceObjectiveName(ServiceObjectiveName serviceObjectiveName) {
        this.serviceObjectiveName = serviceObjectiveName;
        return this;
    }

    /**
     * Get the maxSizeBytes value.
     *
     * @return the maxSizeBytes value
     */
    public String maxSizeBytes() {
        return this.maxSizeBytes;
    }

    /**
     * Set the maxSizeBytes value.
     *
     * @param maxSizeBytes the maxSizeBytes value to set
     * @return the ImportRequestInner object itself.
     */
    public ImportRequestInner withMaxSizeBytes(String maxSizeBytes) {
        this.maxSizeBytes = maxSizeBytes;
        return this;
    }

}
