/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.sql.InstanceFailoverGroupReadWriteEndpoint;
import com.microsoft.azure.management.sql.InstanceFailoverGroupReadOnlyEndpoint;
import com.microsoft.azure.management.sql.InstanceFailoverGroupReplicationRole;
import java.util.List;
import com.microsoft.azure.management.sql.PartnerRegionInfo;
import com.microsoft.azure.management.sql.ManagedInstancePairInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * An instance failover group.
 */
@JsonFlatten
public class InstanceFailoverGroupInner extends ProxyResourceInner {
    /**
     * Read-write endpoint of the failover group instance.
     */
    @JsonProperty(value = "properties.readWriteEndpoint", required = true)
    private InstanceFailoverGroupReadWriteEndpoint readWriteEndpoint;

    /**
     * Read-only endpoint of the failover group instance.
     */
    @JsonProperty(value = "properties.readOnlyEndpoint")
    private InstanceFailoverGroupReadOnlyEndpoint readOnlyEndpoint;

    /**
     * Local replication role of the failover group instance. Possible values
     * include: 'Primary', 'Secondary'.
     */
    @JsonProperty(value = "properties.replicationRole", access = JsonProperty.Access.WRITE_ONLY)
    private InstanceFailoverGroupReplicationRole replicationRole;

    /**
     * Replication state of the failover group instance.
     */
    @JsonProperty(value = "properties.replicationState", access = JsonProperty.Access.WRITE_ONLY)
    private String replicationState;

    /**
     * Partner region information for the failover group.
     */
    @JsonProperty(value = "properties.partnerRegions", required = true)
    private List<PartnerRegionInfo> partnerRegions;

    /**
     * List of managed instance pairs in the failover group.
     */
    @JsonProperty(value = "properties.managedInstancePairs", required = true)
    private List<ManagedInstancePairInfo> managedInstancePairs;

    /**
     * Get the readWriteEndpoint value.
     *
     * @return the readWriteEndpoint value
     */
    public InstanceFailoverGroupReadWriteEndpoint readWriteEndpoint() {
        return this.readWriteEndpoint;
    }

    /**
     * Set the readWriteEndpoint value.
     *
     * @param readWriteEndpoint the readWriteEndpoint value to set
     * @return the InstanceFailoverGroupInner object itself.
     */
    public InstanceFailoverGroupInner withReadWriteEndpoint(InstanceFailoverGroupReadWriteEndpoint readWriteEndpoint) {
        this.readWriteEndpoint = readWriteEndpoint;
        return this;
    }

    /**
     * Get the readOnlyEndpoint value.
     *
     * @return the readOnlyEndpoint value
     */
    public InstanceFailoverGroupReadOnlyEndpoint readOnlyEndpoint() {
        return this.readOnlyEndpoint;
    }

    /**
     * Set the readOnlyEndpoint value.
     *
     * @param readOnlyEndpoint the readOnlyEndpoint value to set
     * @return the InstanceFailoverGroupInner object itself.
     */
    public InstanceFailoverGroupInner withReadOnlyEndpoint(InstanceFailoverGroupReadOnlyEndpoint readOnlyEndpoint) {
        this.readOnlyEndpoint = readOnlyEndpoint;
        return this;
    }

    /**
     * Get the replicationRole value.
     *
     * @return the replicationRole value
     */
    public InstanceFailoverGroupReplicationRole replicationRole() {
        return this.replicationRole;
    }

    /**
     * Get the replicationState value.
     *
     * @return the replicationState value
     */
    public String replicationState() {
        return this.replicationState;
    }

    /**
     * Get the partnerRegions value.
     *
     * @return the partnerRegions value
     */
    public List<PartnerRegionInfo> partnerRegions() {
        return this.partnerRegions;
    }

    /**
     * Set the partnerRegions value.
     *
     * @param partnerRegions the partnerRegions value to set
     * @return the InstanceFailoverGroupInner object itself.
     */
    public InstanceFailoverGroupInner withPartnerRegions(List<PartnerRegionInfo> partnerRegions) {
        this.partnerRegions = partnerRegions;
        return this;
    }

    /**
     * Get the managedInstancePairs value.
     *
     * @return the managedInstancePairs value
     */
    public List<ManagedInstancePairInfo> managedInstancePairs() {
        return this.managedInstancePairs;
    }

    /**
     * Set the managedInstancePairs value.
     *
     * @param managedInstancePairs the managedInstancePairs value to set
     * @return the InstanceFailoverGroupInner object itself.
     */
    public InstanceFailoverGroupInner withManagedInstancePairs(List<ManagedInstancePairInfo> managedInstancePairs) {
        this.managedInstancePairs = managedInstancePairs;
        return this;
    }

}
