/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in JobCredentials.
 */
public class JobCredentialsInner {
    /** The Retrofit service to perform REST calls. */
    private JobCredentialsService service;
    /** The service client containing this operation class. */
    private SqlManagementClientImpl client;

    /**
     * Initializes an instance of JobCredentialsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public JobCredentialsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = retrofit.create(JobCredentialsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for JobCredentials to be
     * used by Retrofit to perform actually REST calls.
     */
    interface JobCredentialsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobCredentials listByAgent" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/credentials")
        Observable<Response<ResponseBody>> listByAgent(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("jobAgentName") String jobAgentName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobCredentials get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/credentials/{credentialName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("jobAgentName") String jobAgentName, @Path("credentialName") String credentialName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobCredentials createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/credentials/{credentialName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("jobAgentName") String jobAgentName, @Path("credentialName") String credentialName, @Path("subscriptionId") String subscriptionId, @Body JobCredentialInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobCredentials delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/credentials/{credentialName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("jobAgentName") String jobAgentName, @Path("credentialName") String credentialName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobCredentials listByAgentNext" })
        @GET
        Observable<Response<ResponseBody>> listByAgentNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Gets a list of jobs credentials.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;JobCredentialInner&gt; object if successful.
     */
    public PagedList<JobCredentialInner> listByAgent(final String resourceGroupName, final String serverName, final String jobAgentName) {
        ServiceResponse<Page<JobCredentialInner>> response = listByAgentSinglePageAsync(resourceGroupName, serverName, jobAgentName).toBlocking().single();
        return new PagedList<JobCredentialInner>(response.body()) {
            @Override
            public Page<JobCredentialInner> nextPage(String nextPageLink) {
                return listByAgentNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of jobs credentials.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<JobCredentialInner>> listByAgentAsync(final String resourceGroupName, final String serverName, final String jobAgentName, final ListOperationCallback<JobCredentialInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByAgentSinglePageAsync(resourceGroupName, serverName, jobAgentName),
            new Func1<String, Observable<ServiceResponse<Page<JobCredentialInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobCredentialInner>>> call(String nextPageLink) {
                    return listByAgentNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of jobs credentials.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobCredentialInner&gt; object
     */
    public Observable<Page<JobCredentialInner>> listByAgentAsync(final String resourceGroupName, final String serverName, final String jobAgentName) {
        return listByAgentWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName)
            .map(new Func1<ServiceResponse<Page<JobCredentialInner>>, Page<JobCredentialInner>>() {
                @Override
                public Page<JobCredentialInner> call(ServiceResponse<Page<JobCredentialInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of jobs credentials.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobCredentialInner&gt; object
     */
    public Observable<ServiceResponse<Page<JobCredentialInner>>> listByAgentWithServiceResponseAsync(final String resourceGroupName, final String serverName, final String jobAgentName) {
        return listByAgentSinglePageAsync(resourceGroupName, serverName, jobAgentName)
            .concatMap(new Func1<ServiceResponse<Page<JobCredentialInner>>, Observable<ServiceResponse<Page<JobCredentialInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobCredentialInner>>> call(ServiceResponse<Page<JobCredentialInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByAgentNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a list of jobs credentials.
     *
    ServiceResponse<PageImpl1<JobCredentialInner>> * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
    ServiceResponse<PageImpl1<JobCredentialInner>> * @param serverName The name of the server.
    ServiceResponse<PageImpl1<JobCredentialInner>> * @param jobAgentName The name of the job agent.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;JobCredentialInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<JobCredentialInner>>> listByAgentSinglePageAsync(final String resourceGroupName, final String serverName, final String jobAgentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-03-01-preview";
        return service.listByAgent(resourceGroupName, serverName, jobAgentName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobCredentialInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobCredentialInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<JobCredentialInner>> result = listByAgentDelegate(response);
                        return Observable.just(new ServiceResponse<Page<JobCredentialInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<JobCredentialInner>> listByAgentDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<JobCredentialInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<JobCredentialInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a jobs credential.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param credentialName The name of the credential.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the JobCredentialInner object if successful.
     */
    public JobCredentialInner get(String resourceGroupName, String serverName, String jobAgentName, String credentialName) {
        return getWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, credentialName).toBlocking().single().body();
    }

    /**
     * Gets a jobs credential.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param credentialName The name of the credential.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<JobCredentialInner> getAsync(String resourceGroupName, String serverName, String jobAgentName, String credentialName, final ServiceCallback<JobCredentialInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, credentialName), serviceCallback);
    }

    /**
     * Gets a jobs credential.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param credentialName The name of the credential.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobCredentialInner object
     */
    public Observable<JobCredentialInner> getAsync(String resourceGroupName, String serverName, String jobAgentName, String credentialName) {
        return getWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, credentialName).map(new Func1<ServiceResponse<JobCredentialInner>, JobCredentialInner>() {
            @Override
            public JobCredentialInner call(ServiceResponse<JobCredentialInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a jobs credential.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param credentialName The name of the credential.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobCredentialInner object
     */
    public Observable<ServiceResponse<JobCredentialInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String credentialName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (credentialName == null) {
            throw new IllegalArgumentException("Parameter credentialName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-03-01-preview";
        return service.get(resourceGroupName, serverName, jobAgentName, credentialName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobCredentialInner>>>() {
                @Override
                public Observable<ServiceResponse<JobCredentialInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<JobCredentialInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<JobCredentialInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<JobCredentialInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<JobCredentialInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates or updates a job credential.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param credentialName The name of the credential.
     * @param parameters The requested job credential state.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the JobCredentialInner object if successful.
     */
    public JobCredentialInner createOrUpdate(String resourceGroupName, String serverName, String jobAgentName, String credentialName, JobCredentialInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, credentialName, parameters).toBlocking().single().body();
    }

    /**
     * Creates or updates a job credential.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param credentialName The name of the credential.
     * @param parameters The requested job credential state.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<JobCredentialInner> createOrUpdateAsync(String resourceGroupName, String serverName, String jobAgentName, String credentialName, JobCredentialInner parameters, final ServiceCallback<JobCredentialInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, credentialName, parameters), serviceCallback);
    }

    /**
     * Creates or updates a job credential.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param credentialName The name of the credential.
     * @param parameters The requested job credential state.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobCredentialInner object
     */
    public Observable<JobCredentialInner> createOrUpdateAsync(String resourceGroupName, String serverName, String jobAgentName, String credentialName, JobCredentialInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, credentialName, parameters).map(new Func1<ServiceResponse<JobCredentialInner>, JobCredentialInner>() {
            @Override
            public JobCredentialInner call(ServiceResponse<JobCredentialInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a job credential.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param credentialName The name of the credential.
     * @param parameters The requested job credential state.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobCredentialInner object
     */
    public Observable<ServiceResponse<JobCredentialInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String credentialName, JobCredentialInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (credentialName == null) {
            throw new IllegalArgumentException("Parameter credentialName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2017-03-01-preview";
        return service.createOrUpdate(resourceGroupName, serverName, jobAgentName, credentialName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobCredentialInner>>>() {
                @Override
                public Observable<ServiceResponse<JobCredentialInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<JobCredentialInner> clientResponse = createOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<JobCredentialInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<JobCredentialInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<JobCredentialInner>() { }.getType())
                .register(201, new TypeToken<JobCredentialInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a job credential.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param credentialName The name of the credential.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String serverName, String jobAgentName, String credentialName) {
        deleteWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, credentialName).toBlocking().single().body();
    }

    /**
     * Deletes a job credential.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param credentialName The name of the credential.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String serverName, String jobAgentName, String credentialName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, credentialName), serviceCallback);
    }

    /**
     * Deletes a job credential.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param credentialName The name of the credential.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String serverName, String jobAgentName, String credentialName) {
        return deleteWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, credentialName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a job credential.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param jobAgentName The name of the job agent.
     * @param credentialName The name of the credential.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String credentialName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (credentialName == null) {
            throw new IllegalArgumentException("Parameter credentialName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-03-01-preview";
        return service.delete(resourceGroupName, serverName, jobAgentName, credentialName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a list of jobs credentials.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;JobCredentialInner&gt; object if successful.
     */
    public PagedList<JobCredentialInner> listByAgentNext(final String nextPageLink) {
        ServiceResponse<Page<JobCredentialInner>> response = listByAgentNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<JobCredentialInner>(response.body()) {
            @Override
            public Page<JobCredentialInner> nextPage(String nextPageLink) {
                return listByAgentNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of jobs credentials.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<JobCredentialInner>> listByAgentNextAsync(final String nextPageLink, final ServiceFuture<List<JobCredentialInner>> serviceFuture, final ListOperationCallback<JobCredentialInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByAgentNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<JobCredentialInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobCredentialInner>>> call(String nextPageLink) {
                    return listByAgentNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of jobs credentials.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobCredentialInner&gt; object
     */
    public Observable<Page<JobCredentialInner>> listByAgentNextAsync(final String nextPageLink) {
        return listByAgentNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<JobCredentialInner>>, Page<JobCredentialInner>>() {
                @Override
                public Page<JobCredentialInner> call(ServiceResponse<Page<JobCredentialInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of jobs credentials.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobCredentialInner&gt; object
     */
    public Observable<ServiceResponse<Page<JobCredentialInner>>> listByAgentNextWithServiceResponseAsync(final String nextPageLink) {
        return listByAgentNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<JobCredentialInner>>, Observable<ServiceResponse<Page<JobCredentialInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobCredentialInner>>> call(ServiceResponse<Page<JobCredentialInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByAgentNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a list of jobs credentials.
     *
    ServiceResponse<PageImpl1<JobCredentialInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;JobCredentialInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<JobCredentialInner>>> listByAgentNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByAgentNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobCredentialInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobCredentialInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<JobCredentialInner>> result = listByAgentNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<JobCredentialInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<JobCredentialInner>> listByAgentNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<JobCredentialInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<JobCredentialInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
