/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.microsoft.azure.management.sql.FailoverGroupReadOnlyEndpoint;
import com.microsoft.azure.management.sql.FailoverGroupReadWriteEndpoint;
import com.microsoft.azure.management.sql.FailoverGroupReplicationRole;
import com.microsoft.azure.management.sql.PartnerInfo;
import com.microsoft.azure.management.sql.ReadOnlyEndpointFailoverPolicy;
import com.microsoft.azure.management.sql.ReadWriteEndpointFailoverPolicy;
import com.microsoft.azure.management.sql.SqlFailoverGroup;
import com.microsoft.azure.management.sql.SqlFailoverGroupOperations;
import com.microsoft.azure.management.sql.SqlServer;
import com.microsoft.azure.management.sql.implementation.FailoverGroupInner;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class SqlFailoverGroupImpl
extends ExternalChildResourceImpl<SqlFailoverGroup, FailoverGroupInner, SqlServerImpl, SqlServer>
implements SqlFailoverGroup,
SqlFailoverGroup.Update,
SqlFailoverGroupOperations.SqlFailoverGroupOperationsDefinition {
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;
    protected String sqlServerLocation;

    SqlFailoverGroupImpl(String name, SqlServerImpl parent, FailoverGroupInner innerObject, SqlServerManager sqlServerManager) {
        super(name, (Object)parent, (Object)innerObject);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName();
        this.sqlServerName = parent.name();
        this.sqlServerLocation = parent.regionName();
    }

    SqlFailoverGroupImpl(String resourceGroupName, String sqlServerName, String sqlServerLocation, String name, FailoverGroupInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.sqlServerLocation = sqlServerLocation;
    }

    SqlFailoverGroupImpl(String name, FailoverGroupInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        if (innerObject != null && innerObject.id() != null) {
            try {
                ResourceId resourceId = ResourceId.fromString((String)innerObject.id());
                this.resourceGroupName = resourceId.resourceGroupName();
                this.sqlServerName = resourceId.parent().name();
                this.sqlServerLocation = innerObject.location();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    public String id() {
        return ((FailoverGroupInner)((Object)this.inner())).id();
    }

    @Override
    public String sqlServerName() {
        return this.sqlServerName;
    }

    @Override
    public String parentId() {
        return ResourceUtils.parentResourceIdFromResourceId((String)((FailoverGroupInner)((Object)this.inner())).id());
    }

    @Override
    public ReadWriteEndpointFailoverPolicy readWriteEndpointPolicy() {
        return ((FailoverGroupInner)((Object)this.inner())).readWriteEndpoint() != null ? ((FailoverGroupInner)((Object)this.inner())).readWriteEndpoint().failoverPolicy() : null;
    }

    @Override
    public int readWriteEndpointDataLossGracePeriodMinutes() {
        return ((FailoverGroupInner)((Object)this.inner())).readWriteEndpoint() != null && ((FailoverGroupInner)((Object)this.inner())).readWriteEndpoint().failoverWithDataLossGracePeriodMinutes() != null ? ((FailoverGroupInner)((Object)this.inner())).readWriteEndpoint().failoverWithDataLossGracePeriodMinutes() : 0;
    }

    @Override
    public ReadOnlyEndpointFailoverPolicy readOnlyEndpointPolicy() {
        return ((FailoverGroupInner)((Object)this.inner())).readOnlyEndpoint() != null ? ((FailoverGroupInner)((Object)this.inner())).readOnlyEndpoint().failoverPolicy() : null;
    }

    @Override
    public FailoverGroupReplicationRole replicationRole() {
        return ((FailoverGroupInner)((Object)this.inner())).replicationRole();
    }

    @Override
    public String replicationState() {
        return ((FailoverGroupInner)((Object)this.inner())).replicationState();
    }

    @Override
    public List<PartnerInfo> partnerServers() {
        return Collections.unmodifiableList(((FailoverGroupInner)((Object)this.inner())).partnerServers() != null ? ((FailoverGroupInner)((Object)this.inner())).partnerServers() : new ArrayList());
    }

    @Override
    public List<String> databases() {
        return Collections.unmodifiableList(((FailoverGroupInner)((Object)this.inner())).databases() != null ? ((FailoverGroupInner)((Object)this.inner())).databases() : new ArrayList());
    }

    @Override
    public void delete() {
        ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).failoverGroups().delete(this.resourceGroupName, this.sqlServerName, this.name());
    }

    @Override
    public Completable deleteAsync() {
        return this.deleteResourceAsync().toCompletable();
    }

    @Override
    public SqlFailoverGroupImpl withExistingSqlServer(String resourceGroupName, String sqlServerName, String sqlServerLocation) {
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.sqlServerLocation = sqlServerLocation;
        return this;
    }

    @Override
    public SqlFailoverGroupImpl withExistingSqlServer(SqlServer sqlServer) {
        Objects.requireNonNull(sqlServer);
        this.resourceGroupName = sqlServer.resourceGroupName();
        this.sqlServerName = sqlServer.name();
        this.sqlServerLocation = sqlServer.regionName();
        return this;
    }

    public SqlFailoverGroupImpl update() {
        super.prepareUpdate();
        return this;
    }

    public Observable<SqlFailoverGroup> createResourceAsync() {
        final SqlFailoverGroupImpl self = this;
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).failoverGroups().createOrUpdateAsync(self.resourceGroupName, self.sqlServerName, self.name(), (FailoverGroupInner)((Object)self.inner())).map((Func1)new Func1<FailoverGroupInner, SqlFailoverGroup>(){

            public SqlFailoverGroup call(FailoverGroupInner failoverGroupInner) {
                self.setInner((Object)failoverGroupInner);
                return self;
            }
        });
    }

    public Observable<SqlFailoverGroup> updateResourceAsync() {
        return this.createResourceAsync();
    }

    public Observable<Void> deleteResourceAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).failoverGroups().deleteAsync(this.resourceGroupName, this.sqlServerName, this.name());
    }

    protected Observable<FailoverGroupInner> getInnerAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).failoverGroups().getAsync(this.resourceGroupName, this.sqlServerName, this.name());
    }

    public String type() {
        return ((FailoverGroupInner)((Object)this.inner())).type();
    }

    public String regionName() {
        return ((FailoverGroupInner)((Object)this.inner())).location();
    }

    public Region region() {
        return Region.fromName((String)((FailoverGroupInner)((Object)this.inner())).location());
    }

    public Map<String, String> tags() {
        return ((FailoverGroupInner)((Object)this.inner())).tags();
    }

    public SqlFailoverGroupImpl withTags(Map<String, String> tags) {
        ((FailoverGroupInner)((Object)this.inner())).withTags(new HashMap<String, String>(tags));
        return this;
    }

    public SqlFailoverGroupImpl withTag(String key, String value) {
        if (((FailoverGroupInner)((Object)this.inner())).tags() == null) {
            ((FailoverGroupInner)((Object)this.inner())).withTags(new HashMap<String, String>());
        }
        ((FailoverGroupInner)((Object)this.inner())).tags().put(key, value);
        return this;
    }

    public SqlFailoverGroupImpl withoutTag(String key) {
        if (((FailoverGroupInner)((Object)this.inner())).tags() != null) {
            ((FailoverGroupInner)((Object)this.inner())).tags().remove(key);
        }
        return this;
    }

    @Override
    public SqlFailoverGroupImpl withAutomaticReadWriteEndpointPolicyAndDataLossGracePeriod(int gracePeriodInMinutes) {
        if (((FailoverGroupInner)((Object)this.inner())).readWriteEndpoint() == null) {
            ((FailoverGroupInner)((Object)this.inner())).withReadWriteEndpoint(new FailoverGroupReadWriteEndpoint());
        }
        ((FailoverGroupInner)((Object)this.inner())).readWriteEndpoint().withFailoverPolicy(ReadWriteEndpointFailoverPolicy.AUTOMATIC);
        ((FailoverGroupInner)((Object)this.inner())).readWriteEndpoint().withFailoverWithDataLossGracePeriodMinutes(gracePeriodInMinutes);
        return this;
    }

    @Override
    public SqlFailoverGroupImpl withManualReadWriteEndpointPolicy() {
        if (((FailoverGroupInner)((Object)this.inner())).readWriteEndpoint() == null) {
            ((FailoverGroupInner)((Object)this.inner())).withReadWriteEndpoint(new FailoverGroupReadWriteEndpoint());
        }
        ((FailoverGroupInner)((Object)this.inner())).readWriteEndpoint().withFailoverPolicy(ReadWriteEndpointFailoverPolicy.MANUAL);
        ((FailoverGroupInner)((Object)this.inner())).readWriteEndpoint().withFailoverWithDataLossGracePeriodMinutes(null);
        return this;
    }

    @Override
    public SqlFailoverGroupImpl withReadOnlyEndpointPolicyEnabled() {
        if (((FailoverGroupInner)((Object)this.inner())).readOnlyEndpoint() == null) {
            ((FailoverGroupInner)((Object)this.inner())).withReadOnlyEndpoint(new FailoverGroupReadOnlyEndpoint());
        }
        ((FailoverGroupInner)((Object)this.inner())).readOnlyEndpoint().withFailoverPolicy(ReadOnlyEndpointFailoverPolicy.ENABLED);
        return this;
    }

    @Override
    public SqlFailoverGroupImpl withReadOnlyEndpointPolicyDisabled() {
        if (((FailoverGroupInner)((Object)this.inner())).readOnlyEndpoint() == null) {
            ((FailoverGroupInner)((Object)this.inner())).withReadOnlyEndpoint(new FailoverGroupReadOnlyEndpoint());
        }
        ((FailoverGroupInner)((Object)this.inner())).readOnlyEndpoint().withFailoverPolicy(ReadOnlyEndpointFailoverPolicy.DISABLED);
        return this;
    }

    @Override
    public SqlFailoverGroupImpl withPartnerServerId(String id) {
        ((FailoverGroupInner)((Object)this.inner())).withPartnerServers(new ArrayList<PartnerInfo>());
        ((FailoverGroupInner)((Object)this.inner())).partnerServers().add(new PartnerInfo().withId(id));
        return this;
    }

    @Override
    public SqlFailoverGroupImpl withDatabaseId(String id) {
        if (((FailoverGroupInner)((Object)this.inner())).databases() == null) {
            ((FailoverGroupInner)((Object)this.inner())).withDatabases(new ArrayList<String>());
        }
        ((FailoverGroupInner)((Object)this.inner())).databases().add(id);
        return this;
    }

    @Override
    public SqlFailoverGroupImpl withNewDatabaseId(String id) {
        return this.withDatabaseId(id);
    }

    @Override
    public SqlFailoverGroupImpl withDatabaseIds(String ... ids) {
        ((FailoverGroupInner)((Object)this.inner())).withDatabases(new ArrayList<String>());
        for (String id : ids) {
            ((FailoverGroupInner)((Object)this.inner())).databases().add(id);
        }
        return this;
    }

    @Override
    public SqlFailoverGroupImpl withoutDatabaseId(String id) {
        if (((FailoverGroupInner)((Object)this.inner())).databases() != null) {
            ((FailoverGroupInner)((Object)this.inner())).databases().remove(this.key);
        }
        return this;
    }
}

