/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for ElasticPoolEditions.
 */
public final class ElasticPoolEditions {
    /** Static value Basic for ElasticPoolEditions. */
    public static final ElasticPoolEditions BASIC = new ElasticPoolEditions("Basic");

    /** Static value Standard for ElasticPoolEditions. */
    public static final ElasticPoolEditions STANDARD = new ElasticPoolEditions("Standard");

    /** Static value Premium for ElasticPoolEditions. */
    public static final ElasticPoolEditions PREMIUM = new ElasticPoolEditions("Premium");

    private String value;

    /**
     * Creates a custom value for ElasticPoolEditions.
     * @param value the custom value
     */
    public ElasticPoolEditions(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ElasticPoolEditions)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ElasticPoolEditions rhs = (ElasticPoolEditions) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
