/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for ElasticPoolState.
 */
public final class ElasticPoolState {
    /** Static value Creating for ElasticPoolState. */
    public static final ElasticPoolState CREATING = new ElasticPoolState("Creating");

    /** Static value Ready for ElasticPoolState. */
    public static final ElasticPoolState READY = new ElasticPoolState("Ready");

    /** Static value Disabled for ElasticPoolState. */
    public static final ElasticPoolState DISABLED = new ElasticPoolState("Disabled");

    private String value;

    /**
     * Creates a custom value for ElasticPoolState.
     * @param value the custom value
     */
    public ElasticPoolState(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ElasticPoolState)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ElasticPoolState rhs = (ElasticPoolState) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
